/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaHelperException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;
import org.eclipse.datatools.connectivity.oda.consumer.internal.impl.LogConfigHelper;
import org.eclipse.datatools.connectivity.oda.consumer.internal.impl.LogPathHelper;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.DriverExtensionManifest;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.ExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.util.logging.LogManager;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.RuntimeInterface;
import org.osgi.framework.Bundle;

public class OdaDriver
extends OdaObject
implements IDriver {
    public static final String ODA_BRIDGED_DRIVER = "BridgedDriverInstance";
    private String m_logDirectory;
    private Object m_appContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OdaDriver(String odaDataSourceId) throws OdaException {
        ExtensionManifest odaDataSourceManifest = null;
        try {
            odaDataSourceManifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
        }
        catch (IllegalArgumentException ex) {
            OdaException odaEx = new OdaException((Throwable)ex);
            this.handleError(odaEx);
        }
        this.init(odaDataSourceManifest);
    }

    public OdaDriver(ExtensionManifest driverConfig) throws OdaException {
        this.init(driverConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OdaDriver(String driverClassName, Locale locale, ClassLoader driverClassloader, boolean switchContextClassloader) throws OdaException {
        super(switchContextClassloader, driverClassloader);
        String context = "OdaDriver.OdaDriver( " + driverClassName + ", " + locale + ", " + driverClassloader + " )\t";
        this.logMethodCalled(context);
        try {
            if (switchContextClassloader) {
                this.setContextClassloader();
            }
            Class<?> driverClass = driverClassloader == null ? Class.forName(driverClassName) : driverClassloader.loadClass(driverClassName);
            IDriver newDriver = this.newDriverInstance(driverClass, null, false);
            this.setObject(newDriver);
            this.logMethodExitWithReturn(context, this);
        }
        catch (Exception ex) {
            OdaHelperException odaEx = new OdaHelperException(Messages.helper_cannotConstructConnectionFactory, driverClassName + ", " + driverClassloader);
            odaEx.initCause(ex);
            this.handleError(odaEx);
        }
        finally {
            if (switchContextClassloader) {
                this.resetContextClassloader();
            }
        }
    }

    private void init(ExtensionManifest driverConfig) throws OdaException {
        if (driverConfig == null) {
            throw new OdaException(Messages.helper_missingDriverInfo);
        }
        String context = "OdaDriver.init( " + driverConfig + " )\t";
        this.logMethodCalled(context);
        IDriver wrappedDriver = this.loadDriverInstance(driverConfig, true, true);
        this.setObject(wrappedDriver);
        this.setLogConfiguration(driverConfig);
        this.logMethodExitWithReturn(context, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDriver loadDriverInstance(ExtensionManifest driverConfig, boolean honorClassLoaderSwitch, boolean appliesBridgeExtension) throws OdaException {
        RuntimeInterface runtime = driverConfig.getRuntimeInterface();
        if (!$assertionsDisabled && !(runtime instanceof JavaRuntimeInterface)) {
            throw new AssertionError();
        }
        JavaRuntimeInterface javaRuntime = (JavaRuntimeInterface)runtime;
        String initEntryPoint = javaRuntime.getDriverClass();
        IDriver loadedDriver = null;
        try {
            Bundle bundle = Platform.getBundle((String)driverConfig.getNamespace());
            Class driverClass = bundle.loadClass(initEntryPoint);
            if (honorClassLoaderSwitch) {
                boolean needSwitch = javaRuntime.needSetThreadContextClassLoader();
                this.setUseContextClassLoaderSwitch(needSwitch);
                if (needSwitch) {
                    this.setDriverClassLoader(driverClass.getClassLoader());
                    this.setContextClassloader();
                }
            }
            loadedDriver = this.newDriverInstance(driverClass, driverConfig.getDataSourceElementID(), appliesBridgeExtension);
        }
        catch (Exception ex) {
            OdaHelperException odaEx = new OdaHelperException(Messages.helper_cannotConstructConnectionFactory, initEntryPoint);
            odaEx.initCause(ex);
            this.handleError(odaEx);
        }
        finally {
            if (honorClassLoaderSwitch) {
                this.resetContextClassloader();
            }
        }
        return loadedDriver;
    }

    private IDriver newDriverInstance(Class driverClass, String driverDataSourceId, boolean appliesBridgeExtension) throws InstantiationException, IllegalAccessException {
        IDriver driverBridge;
        Object driverInstance = driverClass.newInstance();
        if (appliesBridgeExtension && (driverBridge = this.newDriverBridge(driverInstance, driverDataSourceId)) != null) {
            return driverBridge;
        }
        if (driverInstance instanceof IDriver) {
            return (IDriver)driverInstance;
        }
        throw new IllegalArgumentException(driverInstance.toString());
    }

    protected IDriver newDriverBridge(Object driver) {
        return this.newDriverBridge(driver, null);
    }

    protected IDriver newDriverBridge(Object driverInstance, String driverDataSourceId) {
        if (!$assertionsDisabled && driverInstance == null) {
            throw new AssertionError();
        }
        if (driverDataSourceId == null) {
            return null;
        }
        String driverBridgeId = this.getDriverBridgeId(driverInstance);
        if (driverBridgeId == null || driverBridgeId.equalsIgnoreCase(driverDataSourceId)) {
            return null;
        }
        return this.newDriverBridgeExtension(driverInstance, driverBridgeId);
    }

    private String getDriverBridgeId(Object driver) {
        if (!$assertionsDisabled && driver == null) {
            throw new AssertionError();
        }
        String bridgeId = this.getDriverBridgeId(driver.getClass().getName());
        if (bridgeId != null) {
            return bridgeId;
        }
        Class<?>[] driverTypes = driver.getClass().getInterfaces();
        for (int i = 0; i < driverTypes.length; ++i) {
            bridgeId = this.getDriverBridgeId(driverTypes[i].getName());
            if (bridgeId == null) continue;
            return bridgeId;
        }
        return null;
    }

    private String getDriverBridgeId(String driverType) {
        String context = "OdaDriver.getDriverBridgeId( String )";
        DriverExtensionManifest manifest = null;
        try {
            manifest = ExtensionExplorer.getInstance().getDriverExtensionManifest(driverType);
        }
        catch (OdaException e) {
            this.logWarning("OdaDriver.getDriverBridgeId( String )", e.toString());
        }
        if (manifest == null) {
            return null;
        }
        return manifest.getBridgeDataSourceId();
    }

    private IDriver newDriverBridgeExtension(Object driver, String driverBridgeDataSourceId) {
        String context = "OdaDriver.newDriverBridgeExtension";
        if (driverBridgeDataSourceId == null) {
            return null;
        }
        try {
            ExtensionManifest bridgeManifest = ManifestExplorer.getInstance().getExtensionManifest(driverBridgeDataSourceId);
            if (bridgeManifest != null) {
                IDriver driverBridge = this.loadDriverInstance(bridgeManifest, false, false);
                this.setDriverBridgeContext(driverBridge, driver);
                IDriver parentBridge = this.newDriverBridge(driverBridge, bridgeManifest.getDataSourceElementID());
                if (parentBridge != null) {
                    driverBridge = parentBridge;
                }
                return driverBridge;
            }
        }
        catch (OdaException e) {
            this.logWarning("OdaDriver.newDriverBridgeExtension", e.toString());
        }
        return null;
    }

    private void setDriverBridgeContext(IDriver driverBridge, Object driver) {
        String context = "OdaDriver.setDriverBridgeContext";
        if (driverBridge == null || driver == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(ODA_BRIDGED_DRIVER, driver);
        try {
            driverBridge.setAppContext(map);
        }
        catch (RuntimeException e) {
            this.logWarning("OdaDriver.setDriverBridgeContext", e.toString());
        }
        catch (OdaException ex) {
            this.logWarning("OdaDriver.setDriverBridgeContext", ex.toString());
        }
    }

    private IDriver getDriver() {
        return (IDriver)this.getObject();
    }

    private String getLoggerName() {
        return "org.eclipse.datatools.connectivity.oda.consumer";
    }

    public void setLogDirectory(String logDirectory) {
        this.m_logDirectory = logDirectory;
    }

    private void setLogConfiguration(ExtensionManifest driverManifest) throws OdaException {
        LogConfigHelper configHelper = new LogConfigHelper(driverManifest);
        this.setLogConfiguration(configHelper.getDriverLogConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogConfiguration(LogConfiguration logConfig) throws OdaException {
        String context = "OdaDriver.setLogConfiguration( " + logConfig + " )\t";
        this.logMethodCalled(context);
        if (logConfig == null) {
            this.logMethodExit(context);
            return;
        }
        try {
            if (LogManager.getLogger((String)this.getLoggerName()) == null && this.m_logDirectory == null) {
                this.m_logDirectory = logConfig.getDataSourceId();
            }
            if (this.m_logDirectory != null && this.m_logDirectory.length() > 0) {
                this.m_logDirectory = LogPathHelper.getAbsoluteLogDirName(this.m_logDirectory);
                LogManager.getLogger((String)this.getLoggerName(), (int)logConfig.getLogLevel(), (String)this.m_logDirectory, (String)"OdaHelperLog", null);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        try {
            this.setContextClassloader();
            this.getDriver().setLogConfiguration(logConfig);
        }
        catch (UnsupportedOperationException uoException) {
            this.logUnsupportedOp(uoException, "IDriver.setLogConfiguration");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        this.logMethodExit(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnection getConnection(String dataSourceId) throws OdaException {
        String context = "OdaDriver.getConnection( " + dataSourceId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            IConnection connection = this.getDriver().getConnection(dataSourceId);
            IConnection ret = connection == null ? null : this.newConnectionHelper(connection);
            this.logMethodExitWithReturn(context, ret);
            IConnection iConnection = ret;
            return iConnection;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IDriver.getConnection( String dataSourceId )");
            IConnection iConnection = null;
            return iConnection;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IConnection iConnection = null;
            return iConnection;
        }
        catch (OdaException exception) {
            this.handleError(exception);
            IConnection iConnection = null;
            return iConnection;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    protected IConnection newConnectionHelper(IConnection connection) throws OdaException {
        int maxOpenConnections;
        OdaConnection connHelper = new OdaConnection(connection, this.switchContextClassloader(), this.getDriverClassLoader(), this.getOriginalContextClassLoader());
        connHelper.setDriverAppContext(this.m_appContext);
        try {
            maxOpenConnections = this.getMaxConnections();
        }
        catch (OdaException ex) {
            maxOpenConnections = 0;
        }
        OdaConnection.setMaxConnections(maxOpenConnections);
        return connHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxConnections() throws OdaException {
        String context = "OdaDriver.getMaxConnections()\t";
        this.logMethodCalled("OdaDriver.getMaxConnections()\t");
        try {
            this.setContextClassloader();
            int ret = this.getDriver().getMaxConnections();
            this.logMethodExitWithReturn("OdaDriver.getMaxConnections()\t", ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IDriver.getMaxConnections()");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnNegOne(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnNegOne(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppContext(Object context) throws OdaException {
        String methodName = "OdaDriver.setAppContext()\t";
        this.logMethodCalled("OdaDriver.setAppContext()\t");
        if (this.m_appContext == context) {
            this.log("OdaDriver.setAppContext()\t", "Same pass-thru application context object: " + context);
            this.logMethodExit("OdaDriver.setAppContext()\t");
            return;
        }
        try {
            this.setContextClassloader();
            this.log("OdaDriver.setAppContext()\t", "Passing thru application context to underlying ODA driver: " + context);
            this.getDriver().setAppContext(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.logUnsupportedOp(uoException, "IDriver.setAppContext");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        this.m_appContext = context;
        this.logMethodExit("OdaDriver.setAppContext()\t");
    }

    static {
        $assertionsDisabled = !OdaDriver.class.desiredAssertionStatus();
    }
}

