/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class DebugWindowContextService
implements IDebugContextService,
IPartListener2,
IDebugContextListener {
    private Map fListenersByPartId = new HashMap();
    private Map fProvidersByPartId = new HashMap();
    private Map fPostListenersByPartId = new HashMap();
    private IWorkbenchWindow fWindow;
    private List fProviders = new ArrayList();

    public DebugWindowContextService(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fWindow.getPartService().addPartListener((IPartListener2)this);
    }

    public void dispose() {
        this.fWindow.getPartService().removePartListener((IPartListener2)this);
        this.fWindow = null;
    }

    public synchronized void addDebugContextProvider(IDebugContextProvider provider) {
        IWorkbenchPart part = provider.getPart();
        String id = null;
        if (part != null) {
            id = part.getSite().getId();
        }
        this.fProvidersByPartId.put(id, provider);
        this.fProviders.add(provider);
        IWorkbenchPart active = null;
        IWorkbenchPage activePage = this.fWindow.getActivePage();
        if (activePage != null) {
            active = activePage.getActivePart();
        }
        if (this.fProviders.size() == 1 && (part == null || part.equals(active))) {
            this.notify(provider);
        }
        provider.addDebugContextListener(this);
    }

    public synchronized void removeDebugContextProvider(IDebugContextProvider provider) {
        int index = this.fProviders.indexOf(provider);
        if (index >= 0) {
            IWorkbenchPart part = provider.getPart();
            String id = null;
            if (part != null) {
                id = part.getSite().getId();
            }
            this.fProvidersByPartId.remove(id);
            this.fProviders.remove(index);
            if (index == 0) {
                IDebugContextProvider activeProvider = this.getActiveProvider();
                if (activeProvider != null) {
                    this.notify(activeProvider);
                } else {
                    this.notify(new DebugContextEvent(provider, (ISelection)new StructuredSelection(), 1));
                }
            }
        }
        provider.removeDebugContextListener(this);
    }

    public void addDebugContextListener(IDebugContextListener listener) {
        this.addDebugContextListener(listener, null);
    }

    public void addPostDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fPostListenersByPartId.get(partId);
        if (list == null) {
            list = new ListenerList();
            this.fPostListenersByPartId.put(partId, list);
        }
        list.add((Object)listener);
    }

    public void addPostDebugContextListener(IDebugContextListener listener) {
        this.addPostDebugContextListener(listener, null);
    }

    public void removePostDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fPostListenersByPartId.get(partId);
        if (list != null) {
            list.remove((Object)listener);
        }
    }

    public void removePostDebugContextListener(IDebugContextListener listener) {
        this.removePostDebugContextListener(listener, null);
    }

    public void removeDebugContextListener(IDebugContextListener listener) {
        this.removeDebugContextListener(listener, null);
    }

    protected void notify(IDebugContextProvider provdier) {
        ISelection activeContext = provdier.getActiveContext();
        if (activeContext == null) {
            activeContext = new StructuredSelection();
        }
        this.notify(new DebugContextEvent(provdier, activeContext, 1));
    }

    protected void notify(DebugContextEvent event) {
        this.notify(event, this.getListeners(null));
        IWorkbenchPart part = event.getDebugContextProvider().getPart();
        if (part != null) {
            this.notify(event, this.getListeners(part));
        }
        this.notify(event, this.getPostListeners(null));
        if (part != null) {
            this.notify(event, this.getPostListeners(part));
        }
    }

    protected void notify(final DebugContextEvent event, ListenerList list) {
        if (list != null) {
            Object[] listeners = list.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IDebugContextListener listener = (IDebugContextListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.debugContextChanged(event);
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }
    }

    protected ListenerList getListeners(IWorkbenchPart part) {
        String id = null;
        if (part != null) {
            id = part.getSite().getId();
        }
        return (ListenerList)this.fListenersByPartId.get(id);
    }

    protected ListenerList getPostListeners(IWorkbenchPart part) {
        String id = null;
        if (part != null) {
            id = part.getSite().getId();
        }
        return (ListenerList)this.fPostListenersByPartId.get(id);
    }

    public synchronized void addDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fListenersByPartId.get(partId);
        if (list == null) {
            list = new ListenerList();
            this.fListenersByPartId.put(partId, list);
        }
        list.add((Object)listener);
    }

    public void removeDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = (ListenerList)this.fListenersByPartId.get(partId);
        if (list != null) {
            list.remove((Object)listener);
        }
    }

    public ISelection getActiveContext(String partId) {
        IDebugContextProvider provider = (IDebugContextProvider)this.fProvidersByPartId.get(partId);
        if (provider != null) {
            return provider.getActiveContext();
        }
        return null;
    }

    public ISelection getActiveContext() {
        IDebugContextProvider activeProvider = this.getActiveProvider();
        if (activeProvider != null) {
            return activeProvider.getActiveContext();
        }
        return null;
    }

    protected IDebugContextProvider getActiveProvider() {
        if (!this.fProviders.isEmpty()) {
            return (IDebugContextProvider)this.fProviders.get(0);
        }
        return null;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        int index;
        IDebugContextProvider provider = (IDebugContextProvider)this.fProvidersByPartId.get(partRef.getId());
        if (provider != null && (index = this.fProviders.indexOf(provider)) > 0) {
            this.fProviders.remove(index);
            this.fProviders.add(0, provider);
            this.notify(provider);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public synchronized void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void debugContextChanged(DebugContextEvent event) {
        IDebugContextProvider provider;
        if (!this.fProviders.isEmpty() && (provider = (IDebugContextProvider)this.fProviders.get(0)) == event.getDebugContextProvider()) {
            this.notify(event);
        }
    }
}

