/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.common.CommonEditResourceHandler;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

public class ClasspathModel
implements ResourceStateInputProvider,
ResourceStateValidator {
    protected IProject project;
    protected IVirtualComponent selectedEARComponent;
    protected IArchive earFile;
    protected IVirtualComponent component;
    public EARArtifactEdit earArtifactEdit;
    protected IVirtualComponent[] availableEARComponents = null;
    protected ClassPathSelection classPathSelection;
    protected List listeners;
    protected List nonResourceFiles;
    protected ResourceStateValidator stateValidator;
    protected ArchiveManifest manifest;
    public static String NO_EAR_MESSAGE = CommonEditResourceHandler.getString("NO_EAR_JARDEP_FOR_MOD_UI_");
    protected List targetWLPRefComponentList;
    protected boolean isWLPModel = false;
    protected ClassPathSelection classPathWLPSelection;
    protected Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            IVirtualComponent e1 = (IVirtualComponent)o1;
            IVirtualComponent e2 = (IVirtualComponent)o2;
            return e1.getProject().getName().compareTo(e2.getProject().getName());
        }
    };

    public ClasspathModel(ArchiveManifest initialManifest) {
        this.manifest = initialManifest;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.initializeComponent();
        this.getAvailableEARComponents();
    }

    private void initializeComponent() {
        this.setComponent(ComponentCore.createComponent((IProject)this.getProject()));
    }

    protected IVirtualComponent[] refreshAvailableEARs() {
        if (this.component != null) {
            IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects(this.getComponent().getProject());
            this.availableEARComponents = ComponentUtilities.getComponents((IProject[])earProjects);
            if (this.availableEARComponents != null && this.availableEARComponents.length > 0) {
                Arrays.sort(this.availableEARComponents, this.comparator);
                if (this.selectedEARComponent == null || !Arrays.asList(this.availableEARComponents).contains(this.selectedEARComponent)) {
                    this.selectedEARComponent = this.availableEARComponents.length > 0 ? this.availableEARComponents[0] : null;
                }
            }
        }
        return this.availableEARComponents;
    }

    public IVirtualComponent[] getAvailableEARComponents() {
        if (this.availableEARComponents == null) {
            this.refreshAvailableEARs();
        }
        return this.availableEARComponents;
    }

    public IVirtualComponent getSelectedEARComponent() {
        return this.selectedEARComponent;
    }

    public void setSelectedEARComponent(IVirtualComponent component) {
        this.selectedEARComponent = component;
        this.fireNotification(new ClasspathModelEvent(2));
    }

    public String getArchiveURI() {
        if (this.selectedEARComponent != null) {
            IVirtualReference[] refs = this.selectedEARComponent.getReferences();
            IVirtualComponent moduleComp = this.getComponent();
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getReferencedComponent().equals(moduleComp)) {
                    return refs[i].getArchiveName();
                }
                ++i;
            }
        }
        return null;
    }

    public EARArtifactEdit getEARArtifactEdit() {
        if (this.earArtifactEdit == null || this.selectedEARComponentChanged()) {
            this.earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead(this.selectedEARComponent);
        }
        return this.earArtifactEdit;
    }

    private boolean selectedEARComponentChanged() {
        if (this.earArtifactEdit != null && !this.earArtifactEdit.getComponent().getName().equals(this.selectedEARComponent.getName())) {
            this.earArtifactEdit.dispose();
            this.earArtifactEdit = null;
            return true;
        }
        return false;
    }

    protected void initializeEARFile() {
        if (this.selectedEARComponent == null || !this.isDDInEAR(this.selectedEARComponent)) {
            this.earFile = null;
            return;
        }
        try {
            this.earFile = JavaEEArchiveUtilities.INSTANCE.openArchive(this.selectedEARComponent);
        }
        catch (ArchiveOpenFailureException aofex) {
            this.handleOpenFailureException((Exception)((Object)aofex));
        }
    }

    protected void initializeSelection(ArchiveManifest existing) {
        block18: {
            try {
                try {
                    this.initializeEARFile();
                    this.initializeArchive();
                    if (J2EEProjectUtilities.isEARProject(this.getProject())) break block18;
                    if (this.getProject() != null) {
                        if (existing == null) {
                            if (this.manifest != null) {
                                J2EEProjectUtilities.writeManifest(this.getProject(), this.manifest);
                            } else {
                                this.manifest = J2EEProjectUtilities.readManifest(this.getProject());
                            }
                        } else {
                            J2EEProjectUtilities.writeManifest(this.getProject(), existing);
                            this.manifest = existing;
                        }
                        if (this.selectedEARComponent != null) {
                            IVirtualReference[] archiveFiles = this.selectedEARComponent.getReferences();
                            IVirtualComponent anArchive = null;
                            int i = 0;
                            while (i < archiveFiles.length) {
                                anArchive = archiveFiles[i].getReferencedComponent();
                                try {
                                    if (J2EEProjectUtilities.isEJBComponent(anArchive)) {
                                        IModelProvider modelProvider = ModelProviderManager.getModelProvider(anArchive.getProject());
                                        modelProvider.getModelObject();
                                    }
                                    J2EEProjectUtilities.readManifest(anArchive.getProject());
                                }
                                catch (ManifestException mfEx) {
                                    Logger.getLogger().logError((Throwable)mfEx);
                                }
                                catch (DeploymentDescriptorLoadException ddException) {
                                    Logger.getLogger().logError((Throwable)ddException);
                                }
                                ++i;
                            }
                        }
                    }
                    this.createClassPathSelection();
                }
                catch (IOException e) {
                    this.handleOpenFailureException(e);
                    if (this.earFile != null) {
                        JavaEEArchiveUtilities.INSTANCE.closeArchive(this.earFile);
                    }
                }
            }
            finally {
                if (this.earFile != null) {
                    JavaEEArchiveUtilities.INSTANCE.closeArchive(this.earFile);
                }
            }
        }
    }

    protected void initializeArchive() {
    }

    protected void createClassPathSelection() {
        this.classPathSelection = this.getComponent() != null && this.selectedEARComponent != null ? new ClassPathSelection(this.getComponent(), this.selectedEARComponent) : null;
    }

    protected boolean isDDInEAR(IVirtualComponent aComponent) {
        IProject mofRoot = aComponent.getProject();
        if (mofRoot == null || !mofRoot.exists()) {
            return false;
        }
        return mofRoot.exists((IPath)new Path(String.valueOf(aComponent.getRootFolder().getProjectRelativePath().toString()) + "//" + "META-INF/application.xml"));
    }

    protected void handleOpenFailureException(Exception ex) {
        Logger.getLogger().logError((Throwable)ex);
    }

    public void dispose() {
        if (this.earArtifactEdit != null) {
            this.earArtifactEdit.dispose();
            this.earArtifactEdit = null;
        }
    }

    public ClassPathSelection getClassPathSelection() {
        if (this.classPathSelection == null) {
            this.initializeSelection(null);
        }
        return this.classPathSelection;
    }

    public void resetClassPathSelection(ArchiveManifest mf) {
        this.initializeSelection(mf);
        this.fireNotification(new ClasspathModelEvent(4));
    }

    public void resetClassPathSelection() {
        this.resetClassPathSelection(null);
    }

    public void resetClassPathSelectionForWLPs() {
        this.classPathWLPSelection = null;
    }

    public void addListener(ClasspathModelListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ClasspathModelListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void fireNotification(ClasspathModelEvent evt) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ClasspathModelListener listener = (ClasspathModelListener)this.listeners.get(i);
            listener.modelChanged(evt);
            ++i;
        }
    }

    public void setSelection(ClasspathElement element, boolean selected) {
        element.setSelected(selected);
        if (!this.isWLPModel()) {
            this.updateManifestClasspath();
        } else {
            this.fireNotification(new ClasspathModelEvent(1));
        }
    }

    public void setAllClasspathElementsSelected(boolean selected) {
        ClassPathSelection s = this.getClassPathSelection();
        if (s != null) {
            s.setAllSelected(selected);
            this.updateManifestClasspath();
        }
    }

    public void setAllClasspathElementsSelected(List elements, boolean selected) {
        ClassPathSelection s = this.getClassPathSelection();
        if (s != null) {
            s.setAllSelected(elements, selected);
            this.updateManifestClasspath();
        }
    }

    public Archive getArchive() {
        return null;
    }

    public void updateManifestClasspath() {
        if (this.classPathSelection != null && this.classPathSelection.isModified()) {
            this.manifest.setClassPath(this.classPathSelection.toString());
            this.fireNotification(new ClasspathModelEvent(1));
        }
    }

    public void updateMainClass(String mainClass) {
        this.manifest.setMainClass(mainClass);
        this.fireNotification(new ClasspathModelEvent(5));
    }

    public void updateImplVersion(String implVersion) {
        this.manifest.setImplemenationVersion(implVersion);
        this.fireNotification(new ClasspathModelEvent(7));
    }

    public void fireSavedEvent() {
        this.fireNotification(new ClasspathModelEvent(6));
    }

    public void primSetManifest(ArchiveManifest mf) {
        this.manifest = mf;
    }

    public void setManifest(ArchiveManifest newManifest) {
        try {
            J2EEProjectUtilities.writeManifest(this.getProject(), newManifest);
        }
        catch (IOException e) {
            this.handleOpenFailureException(e);
        }
        this.getClassPathSelection();
        this.fireNotification(new ClasspathModelEvent(3));
    }

    public void selectEAR(int index) {
        ArchiveManifestImpl mf = new ArchiveManifestImpl((Manifest)((ArchiveManifestImpl)this.getArchive().getManifest()));
        JavaEEArchiveUtilities.INSTANCE.closeArchive(this.earFile);
        this.selectedEARComponent = this.availableEARComponents[index];
        this.initializeSelection((ArchiveManifest)mf);
        this.fireNotification(new ClasspathModelEvent(2));
    }

    public void moveUp(List toMoveUp) {
        this.getClassPathSelection().moveUp(toMoveUp);
        this.updateManifestClasspath();
    }

    public void moveDown(List toMoveDown) {
        this.getClassPathSelection().moveDown(toMoveDown);
        this.updateManifestClasspath();
    }

    public void refresh() {
        ArchiveManifest mf = null;
        if (this.getComponent() != null) {
            mf = J2EEProjectUtilities.readManifest(this.getProject());
        }
        this.refreshAvailableEARs();
        this.resetClassPathSelection(mf);
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    public List getNonResourceFiles() {
        if (this.nonResourceFiles == null) {
            this.initNonResourceFiles();
        }
        return this.nonResourceFiles;
    }

    protected void initNonResourceFiles() {
        if (this.getComponent() == null) {
            return;
        }
        this.nonResourceFiles = new ArrayList(3);
        this.nonResourceFiles.add(this.getComponent().getProject().getFile(".project"));
        this.nonResourceFiles.add(this.getComponent().getProject().getFile(".classpath"));
        IFile mf = J2EEProjectUtilities.getManifestFile(this.getComponent().getProject());
        if (mf != null) {
            this.nonResourceFiles.add(mf);
        }
    }

    public List getNonResourceInconsistentFiles() {
        return null;
    }

    public boolean isDirty() {
        ClassPathSelection selection = this.getClassPathSelection();
        if (selection == null) {
            return false;
        }
        return selection.isModified();
    }

    public Set getAffectedFiles() {
        HashSet<IFile> result = new HashSet<IFile>();
        IFile aFile = J2EEProjectUtilities.getManifestFile(this.getComponent().getProject());
        if (aFile != null && aFile.exists()) {
            result.add(aFile);
        }
        result.addAll(ProjectUtilities.getFilesAffectedByClasspathChange((IProject)this.getComponent().getProject()));
        return result;
    }

    public List getResources() {
        return Collections.EMPTY_LIST;
    }

    public boolean selectDependencyIfNecessary(IProject referencedProject) {
        this.getClassPathSelection();
        if (this.classPathSelection == null || this.classPathSelection.hasDirectOrIndirectDependencyTo(referencedProject)) {
            return false;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(referencedProject);
        if (element != null) {
            this.setSelection(element, true);
            return true;
        }
        return false;
    }

    public boolean selectDependencyIfNecessary(String jarName) {
        this.getClassPathSelection();
        if (this.classPathSelection == null || this.classPathSelection.hasDirectOrIndirectDependencyTo(jarName)) {
            return false;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(jarName);
        if (element != null) {
            this.setSelection(element, true);
            return true;
        }
        return false;
    }

    public void removeDependency(String jarName) {
        this.getClassPathSelection();
        if (this.classPathSelection == null) {
            return;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(jarName);
        if (element != null && element.isValid()) {
            this.setSelection(element, false);
        }
    }

    public void removeDependency(IProject referencedProject) {
        this.getClassPathSelection();
        if (this.classPathSelection == null) {
            return;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(referencedProject);
        if (element != null && element.isValid()) {
            this.setSelection(element, false);
        }
    }

    public void selectFilterLevel(int filterLevel) {
        this.getClassPathSelection();
        if (this.classPathSelection != null) {
            this.classPathSelection.selectFilterLevel(filterLevel);
        }
        this.updateManifestClasspath();
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().validateState(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public void setComponent(IVirtualComponent component) {
        this.component = component;
    }

    public ClassPathSelection getClassPathSelectionForWLPs() {
        if (this.classPathWLPSelection == null) {
            this.initializeSelectionForWLPs();
        }
        return this.classPathWLPSelection;
    }

    private void initializeSelectionForWLPs() {
        block34: {
            this.classPathWLPSelection = new ClassPathSelection();
            try {
                IClasspathContainer container = J2EEComponentClasspathUpdater.getInstance().getWebAppLibrariesContainer(this.component.getProject(), true);
                IClasspathEntry[] containerEntries = container != null ? container.getClasspathEntries() : null;
                Path libPath = new Path("/WEB-INF/lib");
                HashSet hs = new HashSet();
                hs.addAll(J2EEProjectUtilities.getAllJavaNonFlexProjects());
                IProject[] utilityProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType("jst.utility");
                hs.addAll(Arrays.asList(utilityProjects));
                IProject[] ejbProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType("jst.ejb");
                hs.addAll(Arrays.asList(ejbProjects));
                HashMap pathToComp = new HashMap();
                for (Object item : hs) {
                    IJavaProject javaProject;
                    IProject utilProject = null;
                    IVirtualComponent comp = null;
                    if (item instanceof IProject) {
                        utilProject = (IProject)item;
                        comp = ComponentCore.createComponent((IProject)utilProject);
                        if (utilProject.getName().startsWith(".")) {
                            continue;
                        }
                    } else if (item instanceof IVirtualComponent) {
                        utilProject = ((IVirtualComponent)item).getProject();
                        comp = (IVirtualComponent)item;
                    }
                    boolean existingEntry = false;
                    if (containerEntries != null) {
                        int j = 0;
                        while (j < containerEntries.length) {
                            IClasspathEntry eachEntry = containerEntries[j];
                            if (eachEntry.getEntryKind() == 2 && eachEntry.getPath().toString().equals("/" + utilProject.getName())) {
                                IVirtualReference ref = this.component.getReference(utilProject.getName());
                                if (ref == null || !ref.getRuntimePath().equals((Object)libPath)) break;
                                existingEntry = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!existingEntry && (javaProject = JavaCore.create((IProject)this.component.getProject())) != null) {
                        IClasspathEntry[] entry = javaProject.getRawClasspath();
                        int j = 0;
                        while (j < entry.length) {
                            IClasspathEntry eachEntry = entry[j];
                            if (eachEntry.getEntryKind() == 2 && eachEntry.getPath().toString().equals("/" + utilProject.getName())) {
                                IVirtualReference ref = this.component.getReference(utilProject.getName());
                                if (ref == null || !ref.getRuntimePath().equals((Object)libPath)) break;
                                existingEntry = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (existingEntry) {
                        this.classPathWLPSelection.buildClasspathComponentDependencyMap(comp, pathToComp);
                    }
                    this.classPathWLPSelection.createProjectElement(utilProject, existingEntry);
                    this.classPathWLPSelection.setFilterLevel(2);
                }
                for (IVirtualComponent c : pathToComp.values()) {
                    URI archiveURI = URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)c));
                    String unresolvedURI = null;
                    try {
                        unresolvedURI = ModuleURIUtil.getArchiveName((URI)archiveURI);
                    }
                    catch (UnresolveableURIException e) {
                        e.printStackTrace();
                    }
                    if (unresolvedURI == null) continue;
                    ClasspathElement element = this.classPathWLPSelection.createClasspathArchiveElement(c.getProject(), archiveURI, unresolvedURI);
                    this.classPathWLPSelection.addClasspathElement(element, unresolvedURI);
                }
                if (this.component == null || !J2EEProjectUtilities.isDynamicWebProject(this.component.getProject()) || !(this.component instanceof J2EEModuleVirtualComponent)) break block34;
                J2EEModuleVirtualComponent j2eeComp = (J2EEModuleVirtualComponent)this.component;
                IVirtualReference[] newrefs = j2eeComp.getNonJavaReferences();
                int i = 0;
                while (i < newrefs.length) {
                    boolean isBinary;
                    IVirtualReference ref = newrefs[i];
                    IVirtualComponent referencedComponent = ref.getReferencedComponent();
                    if (referencedComponent != null && (isBinary = referencedComponent.isBinary())) {
                        String unresolvedURI = "";
                        try {
                            unresolvedURI = ModuleURIUtil.getArchiveName((URI)URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)));
                        }
                        catch (UnresolveableURIException e) {
                            e.printStackTrace();
                        }
                        URI archiveURI = URI.createURI((String)unresolvedURI);
                        boolean alreadyInList = false;
                        for (ClasspathElement tmpelement : this.classPathWLPSelection.getClasspathElements()) {
                            if (!tmpelement.getText().equals(archiveURI.lastSegment())) continue;
                            alreadyInList = true;
                            break;
                        }
                        ClasspathElement element = null;
                        if (!alreadyInList) {
                            IJavaProject javaProject;
                            boolean inContainer = false;
                            if (containerEntries != null) {
                                String lastSegment = archiveURI.lastSegment();
                                int j = 0;
                                while (!inContainer && j < containerEntries.length) {
                                    if (containerEntries[j].getPath().lastSegment().equals(lastSegment)) {
                                        inContainer = true;
                                    }
                                    ++j;
                                }
                            }
                            if (!inContainer && (javaProject = JavaCore.create((IProject)this.component.getProject())) != null) {
                                VirtualArchiveComponent vComp = (VirtualArchiveComponent)referencedComponent;
                                File diskFile = vComp.getUnderlyingDiskFile();
                                Path path = null;
                                if (diskFile.exists()) {
                                    path = new Path(diskFile.getAbsolutePath());
                                } else {
                                    IFile iFile = vComp.getUnderlyingWorkbenchFile();
                                    path = iFile.getFullPath();
                                }
                                inContainer = this.inClassPath(javaProject, (IPath)path);
                            }
                            if (inContainer) {
                                element = this.classPathWLPSelection.createArchiveElement(URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)), referencedComponent.getName(), archiveURI.lastSegment());
                                this.classPathWLPSelection.addClasspathElement(element, unresolvedURI);
                            } else {
                                element = this.classPathWLPSelection.createArchiveElement(URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)), archiveURI.lastSegment(), null);
                                this.classPathWLPSelection.addClasspathElement(element, unresolvedURI);
                            }
                        }
                    }
                    ++i;
                }
                try {
                    this.classPathWLPSelection.createClasspathEntryElements(this.component, (IPath)libPath);
                }
                catch (CoreException ce) {
                    Logger.getLogger((String)"org.eclipse.jst.j2ee").logError((Throwable)ce);
                }
            }
            catch (CoreException coreException) {
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    public boolean isWLPModel() {
        return this.isWLPModel;
    }

    public void setWLPModel(boolean isWLPModel) {
        this.isWLPModel = isWLPModel;
    }

    private boolean inClassPath(IJavaProject javaProject, IPath path) {
        boolean existingEntry = false;
        IClasspathEntry[] entry = null;
        try {
            entry = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        int j = 0;
        while (j < entry.length) {
            IClasspathEntry classPathEntry;
            IClasspathEntry eachEntry = entry[j];
            if ((eachEntry.getEntryKind() == 1 || eachEntry.getEntryKind() == 4) && (classPathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)eachEntry)) != null && classPathEntry.getPath().equals((Object)path)) {
                existingEntry = true;
                break;
            }
            ++j;
        }
        return existingEntry;
    }
}

