/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class SwitchCase
extends Statement {
    private final Expression value;
    private final Statement[] actions;
    private final boolean isDefault;

    public SwitchCase(int n, int n2, Expression expression, Statement[] statementArray, boolean bl) {
        super(n, n2);
        assert (statementArray != null);
        this.value = expression;
        this.actions = statementArray;
        this.isDefault = bl;
        if (expression != null) {
            expression.setParent(this);
        }
        int n3 = 0;
        while (n3 < statementArray.length) {
            statementArray[n3].setParent(this);
            ++n3;
        }
    }

    public SwitchCase(int n, int n2, Expression expression, List list, boolean bl) {
        this(n, n2, expression, list == null ? null : list.toArray(new Statement[list.size()]), bl);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        if (this.value != null) {
            this.value.accept(visitor);
        }
        int n = 0;
        while (n < this.actions.length) {
            this.actions[n].accept(visitor);
            ++n;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.value != null) {
            this.value.traverseTopDown(visitor);
        }
        int n = 0;
        while (n < this.actions.length) {
            this.actions[n].traverseTopDown(visitor);
            ++n;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        if (this.value != null) {
            this.value.traverseBottomUp(visitor);
        }
        int n = 0;
        while (n < this.actions.length) {
            this.actions[n].traverseBottomUp(visitor);
            ++n;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<SwitchCase");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" isDefault='").append(this.isDefault).append("'>\n");
        stringBuffer.append("\t").append(string).append("<Value>\n");
        if (this.value != null) {
            this.value.toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t").append(string).append("</Value>\n");
        int n = 0;
        while (n < this.actions.length) {
            this.actions[n].toString(stringBuffer, "\t" + string);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append(string).append("</SwitchCase>");
    }

    public int getType() {
        return 55;
    }

    public Statement[] getActions() {
        return this.actions;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Expression getValue() {
        return this.value;
    }
}

