/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.visitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Collection;
import org.eclipse.php.internal.core.ast.nodes.ASTError;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.parser.ASTParser;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class CodeBuilder
implements Visitor {
    static final StringBuffer buffer = new StringBuffer();
    private String str;

    public static void main(String[] stringArray) {
        try {
            CodeBuilder codeBuilder = new CodeBuilder();
            String string = stringArray[0];
            String string2 = stringArray[1];
            File file = new File(string);
            String[] stringArray2 = file.list();
            int n = 0;
            while (n < stringArray2.length) {
                String string3 = stringArray2[n];
                codeBuilder.str = CodeBuilder.readFile(String.valueOf(string) + "/" + string3);
                StringReader stringReader = new StringReader(codeBuilder.str);
                Program program = ASTParser.parse(stringReader);
                System.out.println(program);
                program.accept(codeBuilder);
                System.out.println(buffer.toString());
                CodeBuilder.printOutputfile(String.valueOf(string2) + "/" + string3);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printOutputfile(String string) throws FileNotFoundException {
        File file = new File(string);
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        printStream.print(buffer.toString());
        printStream.close();
    }

    private static String readFile(String string) throws FileNotFoundException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        int n = fileInputStream.read();
        while (n != -1) {
            stringBuffer.append((char)n);
            n = fileInputStream.read();
        }
        fileInputStream.close();
        return stringBuffer.toString();
    }

    private void acceptQuoteExpression(Expression[] expressionArray) {
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray[n].accept(this);
            ++n;
        }
    }

    public void visit(ArrayAccess arrayAccess) {
        arrayAccess.getVariableName().accept(this);
        if (arrayAccess.getIndex() != null) {
            if (arrayAccess.getArrayType() == 1) {
                buffer.append("[");
                arrayAccess.getIndex().accept(this);
                buffer.append("]");
            } else if (arrayAccess.getArrayType() == 2) {
                buffer.append("{");
                arrayAccess.getIndex().accept(this);
                buffer.append("}");
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void visit(ArrayCreation arrayCreation) {
        buffer.append("array(");
        ArrayElement[] arrayElementArray = arrayCreation.getElements();
        int n = 0;
        while (n < arrayElementArray.length) {
            arrayElementArray[n].accept(this);
            buffer.append(",");
            ++n;
        }
        buffer.append(")");
    }

    public void visit(ArrayElement arrayElement) {
        if (arrayElement.getKey() != null) {
            arrayElement.getKey().accept(this);
            buffer.append("=>");
        }
        arrayElement.getValue().accept(this);
    }

    public void visit(Assignment assignment) {
        assignment.getVariable().accept(this);
        buffer.append(Assignment.getOperator(assignment.getOperator()));
        assignment.getValue().accept(this);
    }

    public void visit(ASTError aSTError) {
        buffer.append(this.str.substring(aSTError.getStart(), aSTError.getEnd()));
    }

    public void visit(BackTickExpression backTickExpression) {
        buffer.append("`");
        Expression[] expressionArray = backTickExpression.getExpressions();
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray[n].accept(this);
            ++n;
        }
        buffer.append("`");
    }

    public void visit(Block block) {
        if (block.isCurly()) {
            buffer.append("{\n");
        } else {
            buffer.append(":\n");
        }
        Statement[] statementArray = block.getStatements();
        int n = 0;
        while (n < statementArray.length) {
            statementArray[n].accept(this);
            ++n;
        }
        if (block.isCurly()) {
            buffer.append("\n}\n");
        } else {
            buffer.append("end;\n");
        }
    }

    public void visit(BreakStatement breakStatement) {
        buffer.append("break ");
        if (breakStatement.getExpr() != null) {
            breakStatement.getExpr().accept(this);
        }
        buffer.append(";\n");
    }

    public void visit(CastExpression castExpression) {
        buffer.append("(");
        buffer.append(CastExpression.getCastType(castExpression.getCastType()));
        buffer.append(")");
        castExpression.getExpr().accept(this);
    }

    public void visit(CatchClause catchClause) {
        buffer.append("catch (");
        catchClause.getClassName().accept(this);
        buffer.append(" ");
        catchClause.getVariable().accept(this);
        buffer.append(") ");
        catchClause.getStatement().accept(this);
    }

    public void visit(ClassConstantDeclaration classConstantDeclaration) {
        buffer.append("const ");
        boolean bl = true;
        Identifier[] identifierArray = classConstantDeclaration.getVariableNames();
        Expression[] expressionArray = classConstantDeclaration.getConstantValues();
        int n = 0;
        while (n < identifierArray.length) {
            if (!bl) {
                buffer.append(",");
            }
            identifierArray[n].accept(this);
            buffer.append(" = ");
            expressionArray[n].accept(this);
            bl = false;
            ++n;
        }
        buffer.append(";\n");
    }

    public void visit(ClassDeclaration classDeclaration) {
        Identifier[] identifierArray;
        buffer.append("class ");
        classDeclaration.getName().accept(this);
        if (classDeclaration.getSuperClass() != null) {
            buffer.append(" extends ");
            classDeclaration.getSuperClass().accept(this);
        }
        if ((identifierArray = classDeclaration.getInterfaces()) != null && identifierArray.length != 0) {
            buffer.append(" implements ");
            identifierArray[0].accept(this);
            int n = 1;
            while (n < identifierArray.length) {
                buffer.append(" , ");
                identifierArray[n].accept(this);
                ++n;
            }
        }
        classDeclaration.getBody().accept(this);
    }

    public void visit(ClassInstanceCreation classInstanceCreation) {
        buffer.append("new ");
        classInstanceCreation.getClassName().accept(this);
        Expression[] expressionArray = classInstanceCreation.getCtorParams();
        if (expressionArray.length != 0) {
            buffer.append("(");
            expressionArray[0].accept(this);
            int n = 1;
            while (n < expressionArray.length) {
                buffer.append(",");
                expressionArray[n].accept(this);
                ++n;
            }
            buffer.append(")");
        }
    }

    public void visit(ClassName className) {
        className.getClassName().accept(this);
    }

    public void visit(CloneExpression cloneExpression) {
        buffer.append("clone ");
        cloneExpression.getExpr().accept(this);
    }

    public void visit(Comment comment) {
        buffer.append(this.str.substring(comment.getStart(), comment.getEnd()));
    }

    public void visit(ConditionalExpression conditionalExpression) {
        conditionalExpression.getCondition().accept(this);
        buffer.append(" ? ");
        conditionalExpression.getIfTrue().accept(this);
        buffer.append(" : ");
        conditionalExpression.getIfFalse().accept(this);
    }

    public void visit(ContinueStatement continueStatement) {
        buffer.append("continue ");
        if (continueStatement.getExpr() != null) {
            continueStatement.getExpr().accept(this);
        }
        buffer.append(";\n");
    }

    public void visit(DeclareStatement declareStatement) {
        buffer.append("declare (");
        boolean bl = true;
        Identifier[] identifierArray = declareStatement.getDirectiveNames();
        Expression[] expressionArray = declareStatement.getDirectiveValues();
        int n = 0;
        while (n < identifierArray.length) {
            if (!bl) {
                buffer.append(",");
            }
            identifierArray[n].accept(this);
            buffer.append(" = ");
            expressionArray[n].accept(this);
            bl = false;
            ++n;
        }
        buffer.append(")");
        declareStatement.getAction().accept(this);
    }

    public void visit(DoStatement doStatement) {
        buffer.append("do ");
        doStatement.getAction().accept(this);
        buffer.append("while (");
        doStatement.getCondition().accept(this);
        buffer.append(");\n");
    }

    public void visit(EchoStatement echoStatement) {
        buffer.append("echo ");
        Expression[] expressionArray = echoStatement.getExpressions();
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray[n].accept(this);
            ++n;
        }
        buffer.append(";\n ");
    }

    public void visit(EmptyStatement emptyStatement) {
        buffer.append(";\n");
    }

    public void visit(ExpressionStatement expressionStatement) {
        expressionStatement.getExpr().accept(this);
        buffer.append(";\n");
    }

    public void visit(FieldAccess fieldAccess) {
        fieldAccess.getDispatcher().accept(this);
        buffer.append("->");
        fieldAccess.getField().accept(this);
    }

    public void visit(FieldsDeclaration fieldsDeclaration) {
        Variable[] variableArray = fieldsDeclaration.getVariableNames();
        Expression[] expressionArray = fieldsDeclaration.getInitialValues();
        int n = 0;
        while (n < variableArray.length) {
            buffer.append(String.valueOf(fieldsDeclaration.getModifierString()) + " ");
            variableArray[n].accept(this);
            if (expressionArray[n] != null) {
                buffer.append(" = ");
                expressionArray[n].accept(this);
            }
            buffer.append(";\n");
            ++n;
        }
    }

    public void visit(ForEachStatement forEachStatement) {
        buffer.append("foreach (");
        forEachStatement.getExpression().accept(this);
        buffer.append(" as ");
        if (forEachStatement.getKey() != null) {
            forEachStatement.getKey().accept(this);
            buffer.append(" => ");
        }
        forEachStatement.getValue().accept(this);
        buffer.append(")");
        forEachStatement.getStatement().accept(this);
    }

    public void visit(FormalParameter formalParameter) {
        if (formalParameter.getParameterType() != null) {
            formalParameter.getParameterType().accept(this);
        }
        formalParameter.getParameterName().accept(this);
        if (formalParameter.getDefaultValue() != null) {
            formalParameter.getDefaultValue().accept(this);
        }
    }

    public void visit(ForStatement forStatement) {
        boolean bl = true;
        buffer.append("for (");
        Expression[] expressionArray = forStatement.getInitializations();
        Expression[] expressionArray2 = forStatement.getConditions();
        Expression[] expressionArray3 = forStatement.getIncreasements();
        int n = 0;
        while (n < expressionArray.length) {
            if (!bl) {
                buffer.append(",");
            }
            expressionArray[n].accept(this);
            bl = false;
            ++n;
        }
        bl = true;
        buffer.append(" ; ");
        n = 0;
        while (n < expressionArray2.length) {
            if (!bl) {
                buffer.append(",");
            }
            expressionArray2[n].accept(this);
            bl = false;
            ++n;
        }
        bl = true;
        buffer.append(" ; ");
        n = 0;
        while (n < expressionArray3.length) {
            if (!bl) {
                buffer.append(",");
            }
            expressionArray3[n].accept(this);
            bl = false;
            ++n;
        }
        buffer.append(" ) ");
        forStatement.getAction().accept(this);
    }

    public void visit(FunctionDeclaration functionDeclaration) {
        functionDeclaration.getFunctionName().accept(this);
        buffer.append("(");
        FormalParameter[] formalParameterArray = functionDeclaration.getFormalParameters();
        if (formalParameterArray.length != 0) {
            formalParameterArray[0].accept(this);
            int n = 1;
            while (n < formalParameterArray.length) {
                buffer.append(",");
                formalParameterArray[n].accept(this);
                ++n;
            }
            buffer.append(")");
        }
        if (functionDeclaration.getBody() != null) {
            functionDeclaration.getBody().accept(this);
        }
    }

    public void visit(FunctionInvocation functionInvocation) {
        functionInvocation.getFunctionName().accept(this);
        buffer.append("(");
        Expression[] expressionArray = functionInvocation.getParameters();
        if (expressionArray.length != 0) {
            expressionArray[0].accept(this);
            int n = 1;
            while (n < expressionArray.length) {
                buffer.append(",");
                expressionArray[n].accept(this);
                ++n;
            }
        }
        buffer.append(")");
    }

    public void visit(FunctionName functionName) {
        functionName.getFunctionName().accept(this);
    }

    public void visit(GlobalStatement globalStatement) {
        buffer.append("global ");
        boolean bl = true;
        Variable[] variableArray = globalStatement.getVariables();
        int n = 0;
        while (n < variableArray.length) {
            if (!bl) {
                buffer.append(", ");
            }
            variableArray[n].accept(this);
            bl = false;
            ++n;
        }
        buffer.append(";\n ");
    }

    public void visit(Identifier identifier) {
        buffer.append(identifier.getName());
    }

    public void visit(IfStatement ifStatement) {
        buffer.append("if(");
        ifStatement.getCondition().accept(this);
        buffer.append(")");
        ifStatement.getTrueStatement().accept(this);
        if (ifStatement.getFalseStatement() != null) {
            buffer.append("else");
            ifStatement.getFalseStatement().accept(this);
        }
    }

    public void visit(IgnoreError ignoreError) {
        buffer.append("@");
        ignoreError.getExpr().accept(this);
    }

    public void visit(Include include) {
        buffer.append(Include.getType(include.getIncludeType()));
        buffer.append(" (");
        include.getExpr().accept(this);
        buffer.append(")");
    }

    public void visit(InfixExpression infixExpression) {
        infixExpression.getLeft().accept(this);
        buffer.append(InfixExpression.getOperator(infixExpression.getOperator()));
        infixExpression.getRight().accept(this);
    }

    public void visit(InLineHtml inLineHtml) {
        buffer.append(this.str.substring(inLineHtml.getStart(), inLineHtml.getEnd()));
    }

    public void visit(InstanceOfExpression instanceOfExpression) {
        instanceOfExpression.getExpr().accept(this);
        buffer.append(" instanceof ");
        instanceOfExpression.getClassName().accept(this);
    }

    public void visit(InterfaceDeclaration interfaceDeclaration) {
        buffer.append("interface ");
        interfaceDeclaration.getName().accept(this);
        buffer.append(" extends ");
        boolean bl = true;
        Identifier[] identifierArray = interfaceDeclaration.getInterfaces();
        int n = 0;
        while (identifierArray != null && n < identifierArray.length) {
            if (!bl) {
                buffer.append(", ");
            }
            identifierArray[n].accept(this);
            bl = false;
            ++n;
        }
        interfaceDeclaration.getBody().accept(this);
    }

    public void visit(ListVariable listVariable) {
        buffer.append("list(");
        boolean bl = true;
        VariableBase[] variableBaseArray = listVariable.getVariables();
        int n = 0;
        while (n < variableBaseArray.length) {
            if (!bl) {
                buffer.append(", ");
            }
            variableBaseArray[n].accept(this);
            bl = false;
            ++n;
        }
        buffer.append(")");
    }

    public void visit(MethodDeclaration methodDeclaration) {
        methodDeclaration.getFunction().accept(this);
    }

    public void visit(MethodInvocation methodInvocation) {
        methodInvocation.getDispatcher().accept(this);
        buffer.append("->");
        methodInvocation.getMethod().accept(this);
    }

    public void visit(ParenthesisExpression parenthesisExpression) {
        buffer.append("(");
        if (parenthesisExpression.getExpr() != null) {
            parenthesisExpression.getExpr().accept(this);
        }
        buffer.append(")");
    }

    public void visit(PostfixExpression postfixExpression) {
        postfixExpression.getVariable().accept(this);
        buffer.append(PostfixExpression.getOperator(postfixExpression.getOperator()));
    }

    public void visit(PrefixExpression prefixExpression) {
        prefixExpression.getVariable().accept(this);
        buffer.append(PrefixExpression.getOperator(prefixExpression.getOperator()));
    }

    public void visit(Program program) {
        boolean bl = false;
        Statement[] statementArray = program.getStatements();
        int n = 0;
        while (n < statementArray.length) {
            boolean bl2 = statementArray[n] instanceof InLineHtml;
            if (!bl2 && !bl) {
                buffer.append("<?php\n");
                statementArray[n].accept(this);
                bl = true;
            } else if (!bl2 && bl) {
                statementArray[n].accept(this);
                buffer.append("\n");
            } else if (bl2 && bl) {
                buffer.append("?>\n");
                statementArray[n].accept(this);
                buffer.append("\n");
                bl = false;
            } else {
                statementArray[n].accept(this);
                buffer.append("\n");
            }
            ++n;
        }
        if (bl) {
            buffer.append("?>\n");
        }
        Collection collection = program.getComments();
        for (Comment comment : collection) {
            comment.accept(this);
        }
    }

    public void visit(Quote quote) {
        switch (quote.getQuoteType()) {
            case 0: {
                buffer.append("\"");
                this.acceptQuoteExpression(quote.getExpressions());
                buffer.append("\"");
                break;
            }
            case 1: {
                buffer.append("'");
                this.acceptQuoteExpression(quote.getExpressions());
                buffer.append("'");
                break;
            }
            case 2: {
                buffer.append("<<<Heredoc\n");
                this.acceptQuoteExpression(quote.getExpressions());
                buffer.append("\nHeredoc");
            }
        }
    }

    public void visit(Reference reference) {
        buffer.append("&");
        reference.getExpression().accept(this);
    }

    public void visit(ReflectionVariable reflectionVariable) {
        buffer.append("$");
        reflectionVariable.getVariableName().accept(this);
    }

    public void visit(ReturnStatement returnStatement) {
        buffer.append("return ");
        if (returnStatement.getExpr() != null) {
            returnStatement.getExpr().accept(this);
        }
        buffer.append(";\n");
    }

    public void visit(Scalar scalar) {
        if (scalar.getScalarType() == 3) {
            buffer.append(this.str.substring(scalar.getStart(), scalar.getEnd()));
        } else {
            buffer.append(scalar.getStringValue());
        }
    }

    public void visit(StaticConstantAccess staticConstantAccess) {
        staticConstantAccess.getClassName().accept(this);
        buffer.append("::");
        staticConstantAccess.getConstant().accept(this);
    }

    public void visit(StaticFieldAccess staticFieldAccess) {
        staticFieldAccess.getClassName().accept(this);
        buffer.append("::");
        staticFieldAccess.getField().accept(this);
    }

    public void visit(StaticMethodInvocation staticMethodInvocation) {
        staticMethodInvocation.getClassName().accept(this);
        buffer.append("::");
        staticMethodInvocation.getMethod().accept(this);
    }

    public void visit(StaticStatement staticStatement) {
        buffer.append("static ");
        boolean bl = true;
        Expression[] expressionArray = staticStatement.getExpressions();
        int n = 0;
        while (n < expressionArray.length) {
            if (!bl) {
                buffer.append(", ");
            }
            expressionArray[n].accept(this);
            bl = false;
            ++n;
        }
        buffer.append(";\n");
    }

    public void visit(SwitchCase switchCase) {
        if (switchCase.getValue() != null) {
            switchCase.getValue().accept(this);
            buffer.append(":\n");
        }
        Statement[] statementArray = switchCase.getActions();
        int n = 0;
        while (n < statementArray.length) {
            statementArray[n].accept(this);
            ++n;
        }
    }

    public void visit(SwitchStatement switchStatement) {
        buffer.append("switch (");
        switchStatement.getExpr().accept(this);
        buffer.append(")");
        switchStatement.getStatement().accept(this);
    }

    public void visit(ThrowStatement throwStatement) {
        throwStatement.getExpr().accept(this);
    }

    public void visit(TryStatement tryStatement) {
        buffer.append("try ");
        tryStatement.getTryStatement().accept(this);
        CatchClause[] catchClauseArray = tryStatement.getCatchClauses();
        int n = 0;
        while (n < catchClauseArray.length) {
            catchClauseArray[n].accept(this);
            ++n;
        }
    }

    public void visit(UnaryOperation unaryOperation) {
        buffer.append(UnaryOperation.getOperator(unaryOperation.getOperator()));
        unaryOperation.getExpr().accept(this);
    }

    public void visit(Variable variable) {
        variable.getVariableName().accept(this);
    }

    public void visit(WhileStatement whileStatement) {
        buffer.append("while (");
        whileStatement.getCondition().accept(this);
        buffer.append(")\n");
        whileStatement.getAction().accept(this);
    }
}

