/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.markers;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPTask;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.validation.internal.TaskListUtility;

public class MarkerContributor {
    private static MarkerContributor instance;
    private static String ID;
    private static String PHP_PROBLEM_MARKER_TYPE;
    private static String[] owners;
    private final TaskTagsProvider taskTagsProvider = TaskTagsProvider.getInstance();

    static {
        ID = "org.eclipse.php.core.documentModel.validate.PHPProblemsMarker";
        PHP_PROBLEM_MARKER_TYPE = "org.eclipse.php.core.phpproblemmarker";
        owners = new String[]{ID};
    }

    public static MarkerContributor getInstance() {
        if (instance == null) {
            instance = new MarkerContributor();
        }
        return instance;
    }

    private MarkerContributor() {
    }

    public void markFileProblems(IFile iFile, boolean bl) {
        PHPFileData pHPFileData = this.getFileModel(iFile);
        if (pHPFileData == null) {
            return;
        }
        IPHPMarker[] iPHPMarkerArray = pHPFileData.getMarkers();
        try {
            iFile.deleteMarkers(PHP_PROBLEM_MARKER_TYPE, false, 2);
        }
        catch (CoreException coreException) {}
        if (bl) {
            this.markTasks(iFile, iPHPMarkerArray);
        }
        this.markErrors(iFile, iPHPMarkerArray);
    }

    private void markErrors(IFile iFile, IPHPMarker[] iPHPMarkerArray) {
        if (iPHPMarkerArray != null) {
            try {
                int n = 0;
                while (iPHPMarkerArray.length > n) {
                    String string = iPHPMarkerArray[n].getType();
                    if (string.equals("ERROR") || string.equals("WARNING") || string.equals("INFO")) {
                        String string2 = iPHPMarkerArray[n].getDescription();
                        UserData userData = iPHPMarkerArray[n].getUserData();
                        int n2 = 2;
                        this.createMarker(iFile, userData, PHP_PROBLEM_MARKER_TYPE, string2, n2);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
        }
    }

    private void markTasks(IFile iFile, IPHPMarker[] iPHPMarkerArray) {
        if (iFile == null || !iFile.exists()) {
            return;
        }
        IMarker[] iMarkerArray = null;
        Map[] mapArray = null;
        try {
            TaskListUtility.removeAllTasks((IResource)iFile, (String[])owners, null);
        }
        catch (CoreException coreException) {
            Logger.logException(coreException);
        }
        try {
            iMarkerArray = iFile.findMarkers("org.eclipse.core.resources.taskmarker", false, 2);
            mapArray = new Map[iMarkerArray.length];
            int n = 0;
            while (n < mapArray.length) {
                mapArray[n] = iMarkerArray[n].getAttributes();
                ++n;
            }
            iFile.deleteMarkers("org.eclipse.core.resources.taskmarker", false, 2);
        }
        catch (CoreException coreException) {}
        if (iPHPMarkerArray != null) {
            PHPTask pHPTask;
            TaskTag[] taskTagArray = this.taskTagsProvider.getProjectTaskTags(iFile.getProject());
            if (taskTagArray == null) {
                taskTagArray = this.taskTagsProvider.getWorkspaceTaskTags();
            }
            boolean bl = this.taskTagsProvider.getProjectTagsCaseSensitive(iFile.getProject());
            int n = 0;
            while (iPHPMarkerArray.length > n) {
                String string = iPHPMarkerArray[n].getType();
                if (string.equals("TASK")) {
                    pHPTask = (PHPTask)iPHPMarkerArray[n];
                    String string2 = String.valueOf(pHPTask.getTaskName()) + " " + pHPTask.getDescription();
                    UserData userData = pHPTask.getUserData();
                    int n2 = this.getPriority(pHPTask.getTaskName(), taskTagArray, bl);
                    try {
                        this.createMarker(iFile, userData, "org.eclipse.core.resources.taskmarker", string2, n2);
                    }
                    catch (CoreException coreException) {}
                }
                ++n;
            }
            if (iMarkerArray != null) {
                n = 0;
                while (n < iMarkerArray.length) {
                    try {
                        boolean bl2 = iMarkerArray[n].exists();
                        if (!bl2 && mapArray[n].get("rulerPHPTask") != null) {
                            pHPTask = iFile.createMarker("org.eclipse.core.resources.taskmarker");
                            pHPTask.setAttributes(mapArray[n]);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++n;
                }
            }
        }
    }

    public void markFile(IFile iFile) {
        this.markFileProblems(iFile, true);
    }

    private PHPFileData getFileModel(IFile iFile) {
        return PHPWorkspaceModelManager.getInstance().getModelForFile(iFile.getFullPath().toString(), false);
    }

    private void createMarker(IFile iFile, UserData userData, String string, String string2, int n) throws CoreException {
        IMarker iMarker = iFile.createMarker(string);
        iMarker.setAttribute("lineNumber", userData.getStopLine() + 1);
        iMarker.setAttribute("message", (Object)string2);
        iMarker.setAttribute("priority", n);
        if (string == PHP_PROBLEM_MARKER_TYPE) {
            iMarker.setAttribute("severity", 2);
        }
    }

    private int getPriority(String string, TaskTag[] taskTagArray, boolean bl) {
        int n = 0;
        while (n < taskTagArray.length) {
            boolean bl2 = bl ? taskTagArray[n].getTag().equals(string) : taskTagArray[n].getTag().equalsIgnoreCase(string);
            if (bl2) {
                return taskTagArray[n].getPriority();
            }
            ++n;
        }
        return 1;
    }
}

