/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.util;

import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.SaveDDLUtility;

public class RTEHelper {
    public static IFile saveDDL(String[] ddlStatements, DatabaseDefinition databaseDefinition, IPath path, String statementTerminator) {
        IFile ddlFile = null;
        StringWriter writer = new StringWriter();
        String terminator = RTEHelper.getDefaultStatementTerminator(databaseDefinition);
        if (statementTerminator != null) {
            terminator = statementTerminator;
        }
        for (int i = 0; i < ddlStatements.length; ++i) {
            writer.write(ddlStatements[i] + terminator);
        }
        ddlFile = SaveDDLUtility.getInstance().saveDDLFileAsResource(writer, path.toString());
        return ddlFile;
    }

    private static String getDefaultStatementTerminator(DatabaseDefinition dbDef) {
        return dbDef.getProduct().equals("SQL Server") ? "\r\nGo\r\n\r\n" : ";\r\n\r\n";
    }
}

