/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogCheckConstraint;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableConstraintLoader;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class DerbyTableConstraintLoader
extends JDBCTableConstraintLoader {
    public DerbyTableConstraintLoader(ICatalogObject catalogObject) {
        super(catalogObject);
    }

    public void loadForeignKeys(List containmentList, Collection existingFKs) throws SQLException {
        super.loadForeignKeys(containmentList, existingFKs);
        this.loadCheckConstraint(this.getCatalogObject().getConnection(), containmentList, this.getTable());
    }

    private void loadCheckConstraint(Connection connection, List containmentList, Table table) {
        String query = "SELECT CONSTRAINTNAME,CHECKDEFINITION FROM SYS.SYSCONSTRAINTS A,SYS.SYSSCHEMAS B, SYS.SYSTABLES C, SYS.SYSCHECKS D WHERE A.TYPE='C' AND A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + table.getSchema().getName() + "'" + " AND A.TABLEID= C.TABLEID" + " AND C.TABLENAME='" + table.getName() + "'" + " AND A.CONSTRAINTID=D.CONSTRAINTID";
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String check_name = r.getString("CONSTRAINTNAME");
                DerbyCatalogCheckConstraint check = new DerbyCatalogCheckConstraint();
                check.setName(check_name);
                containmentList.add(check);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

