/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpoint;

public class PdtBreakpoint
implements DBGpBreakpoint {
    private PHPLineBreakpoint bp;
    private IFile workspaceFile;

    public PdtBreakpoint(PHPLineBreakpoint pHPLineBreakpoint) {
        IResource iResource;
        this.bp = pHPLineBreakpoint;
        IMarker iMarker = this.bp.getMarker();
        int n = 0;
        if (pHPLineBreakpoint instanceof PHPRunToLineBreakpoint) {
            iResource = ((PHPRunToLineBreakpoint)pHPLineBreakpoint).getSourceFile();
            n = this.bp.getRuntimeBreakpoint().getLineNumber();
        } else {
            iResource = iMarker.getResource();
            n = iMarker.getAttribute("lineNumber", 0);
        }
        String string = "";
        if (iResource instanceof IWorkspaceRoot) {
            try {
                string = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Include");
                string = iMarker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", string);
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(string));
                if (iFile instanceof IFile) {
                    this.workspaceFile = iFile;
                }
            }
            catch (CoreException coreException) {}
        } else {
            string = iResource.getRawLocation().toString();
            if (iResource instanceof IFile) {
                this.workspaceFile = (IFile)iResource;
            }
        }
        this.bp.getRuntimeBreakpoint().setFileName(string);
        this.bp.getRuntimeBreakpoint().setLineNumber(n);
    }

    public IBreakpoint getBreakpoint() {
        return this.bp;
    }

    public void setBreakpoint(IBreakpoint iBreakpoint) {
        this.bp = (PHPLineBreakpoint)iBreakpoint;
    }

    public int getID() {
        return this.bp.getRuntimeBreakpoint().getID();
    }

    public void setID(int n) {
        this.bp.getRuntimeBreakpoint().setID(n);
    }

    public boolean hasConditionChanged() {
        return this.bp.isConditionChanged();
    }

    public void resetConditionChanged() {
        this.bp.setConditionChanged(false);
    }

    public IFile getIFile() {
        return this.workspaceFile;
    }

    public String getFileName() {
        return this.bp.getRuntimeBreakpoint().getFileName();
    }

    public int getLineNumber() {
        return this.bp.getRuntimeBreakpoint().getLineNumber();
    }

    public String getExpression() {
        return this.bp.getRuntimeBreakpoint().getExpression();
    }

    public boolean isConditional() {
        return this.bp instanceof PHPConditionalBreakpoint;
    }

    public boolean isConditionEnabled() {
        if (this.isConditional()) {
            return ((PHPConditionalBreakpoint)this.bp).isConditionEnabled();
        }
        return false;
    }
}

