/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;

public class DBGpThread
extends DBGpElement
implements IThread {
    private IBreakpoint[] breakpoints;

    public DBGpThread(DBGpTarget dBGpTarget) {
        super(dBGpTarget);
    }

    public String getName() throws DebugException {
        return "PHP Thread";
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.breakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.breakpoints;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return ((DBGpTarget)this.getDebugTarget()).getStackFrames();
        }
        return new IStackFrame[0];
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] iStackFrameArray = this.getStackFrames();
        if (iStackFrameArray.length > 0) {
            return iStackFrameArray[0];
        }
        return null;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return ((IStep)this.getDebugTarget()).canStepReturn();
    }

    public boolean isStepping() {
        return ((IStep)this.getDebugTarget()).isStepping();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public void stepInto() throws DebugException {
        ((IStep)this.getDebugTarget()).stepInto();
    }

    public void stepOver() throws DebugException {
        ((IStep)this.getDebugTarget()).stepOver();
    }

    public void stepReturn() throws DebugException {
        ((IStep)this.getDebugTarget()).stepReturn();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setBreakpoints(IBreakpoint[] iBreakpointArray) {
        this.breakpoints = iBreakpointArray;
    }
}

