/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ArchiveFilter;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class AddJarAction
extends RuntimeClasspathAction {
    private ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 0) {
                return new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, "", null);
            }
            int i = 0;
            while (i < selection.length) {
                if (!(selection[i] instanceof IFile)) {
                    return new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, "", null);
                }
                ++i;
            }
            return new Status(0, JDIDebugPlugin.getUniqueIdentifier(), 0, "", null);
        }
    };

    public AddJarAction(IClasspathViewer viewer) {
        super(ActionMessages.AddJarAction_Add__JARs_1, viewer);
    }

    public void run() {
        ArchiveFilter filter = new ArchiveFilter(this.getSelectedJars());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(this.validator);
        dialog.setTitle(ActionMessages.AddJarAction_JAR_Selection_7);
        dialog.setMessage(ActionMessages.AddJarAction_Choose_jars_to_add__8);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IRuntimeClasspathEntry[] res = new IRuntimeClasspathEntry[elements.length];
            int i = 0;
            while (i < res.length) {
                IResource elem = (IResource)elements[i];
                res[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IResource)elem);
                ++i;
            }
            this.getViewer().addEntries(res);
        }
    }

    protected List getSelectedJars() {
        List list = this.getEntriesAsList();
        ArrayList<IResource> jars = new ArrayList<IResource>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IResource res;
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iter.next();
            if (entry.getType() != 2 || (res = entry.getResource()) == null || !(res instanceof IFile)) continue;
            jars.add(res);
        }
        return jars;
    }

    protected int getActionType() {
        return 1;
    }
}

