/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.editor;

import java.util.ArrayList;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTDeployable;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParamDefList;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLStatement;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class SQLLabelProvider
extends LabelProvider {
    private ArrayList _fLabelDecorators;

    SQLLabelProvider() {
    }

    public Image getBaseImage(Object element) {
        if (!(element instanceof SimpleNode)) {
            return null;
        }
        if (element instanceof IASTSQLStatement) {
            return ((IASTSQLStatement)element).getImage();
        }
        if (element instanceof IASTDeployable) {
            return ((IASTDeployable)element).getImage();
        }
        if (element instanceof IASTSQLParam) {
            return SQLEditorResources.getImage("datatype");
        }
        if (element instanceof IASTSQLParamDefList) {
            return SQLEditorResources.getImage("parameter");
        }
        return null;
    }

    public String getBaseText(Object element) {
        if (element instanceof SimpleNode) {
            return ((SimpleNode)element).toString();
        }
        return super.getText(element);
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this._fLabelDecorators == null) {
            this._fLabelDecorators = new ArrayList(2);
        }
        this._fLabelDecorators.add(decorator);
    }

    protected Image decorateImage(Image image, Object element) {
        if (this._fLabelDecorators != null && image != null) {
            for (int i = 0; i < this._fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                image = decorator.decorateImage(image, element);
            }
        }
        return image;
    }

    public Image getImage(Object element) {
        return this.decorateImage(this.getBaseImage(element), element);
    }

    protected String decorateText(String text, Object element) {
        if (this._fLabelDecorators != null && text.length() > 0) {
            for (int i = 0; i < this._fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                text = decorator.decorateText(text, element);
            }
        }
        return text;
    }

    public String getText(Object element) {
        return this.decorateText(this.getBaseText(element), element);
    }

    public void dispose() {
        if (this._fLabelDecorators != null) {
            for (int i = 0; i < this._fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                decorator.dispose();
            }
            this._fLabelDecorators = null;
        }
    }

    public void addListener(ILabelProviderListener listener) {
        if (this._fLabelDecorators != null) {
            for (int i = 0; i < this._fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                decorator.addListener(listener);
            }
        }
        super.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this._fLabelDecorators != null) {
            for (int i = 0; i < this._fLabelDecorators.size(); ++i) {
                ILabelDecorator decorator = (ILabelDecorator)this._fLabelDecorators.get(i);
                decorator.removeListener(listener);
            }
        }
        super.removeListener(listener);
    }

    public static ILabelDecorator[] getDecorators(boolean errortick, ILabelDecorator extra) {
        if (errortick) {
            if (extra == null) {
                return new ILabelDecorator[0];
            }
            return new ILabelDecorator[]{extra};
        }
        if (extra != null) {
            return new ILabelDecorator[]{extra};
        }
        return null;
    }
}

