/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.IAnnotationEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.IConnectionPreference;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PFValidator;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpolicy.PFLinkBendpointEditPolicy;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpolicy.PFLinkEditPolicy;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpolicy.PFLinkEndpointEditPolicy;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.figure.PFLinkFigure;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLinkBendpoint;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPackage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.PageflowLinkPropertySource;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.PFBatchAdapter;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowAnnotationUtil;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class PageflowLinkEditPart
extends AbstractConnectionEditPart
implements IConnectionPreference,
IAnnotationEditPart,
PFValidator {
    private PFLinkAdapter adapter = new PFLinkAdapter();
    private IPropertySource propertySource = null;
    public static final ImageDescriptor IMG_WARNING = EditorPlugin.getDefault().getImageDescriptor("facesconfig/Pageflow_Quickfix_Error.gif");
    private int connectionStyle = -1;
    private PFLinkBendpointEditPolicy bendpointEditPolicy;

    public PageflowLinkEditPart(PageflowLink element) {
        this.setModel(element);
    }

    protected IFigure createFigure() {
        PFLinkFigure figure_ = new PFLinkFigure();
        return figure_;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new PFLinkEndpointEditPolicy());
        if (this.getConnectionRouterStyle() == 0) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)this.getBendpointEditPolicy());
        }
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new PFLinkEditPolicy());
    }

    private PFLinkBendpointEditPolicy getBendpointEditPolicy() {
        if (this.bendpointEditPolicy == null) {
            this.bendpointEditPolicy = new PFLinkBendpointEditPolicy();
        }
        return this.bendpointEditPolicy;
    }

    public PageflowLink getPFLink() {
        return (PageflowLink)this.getModel();
    }

    public void activate() {
        this.getPFLink().eAdapters().add((Object)this.adapter);
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    public Object getAdapter(Class key) {
        if (key == IPropertySource.class) {
            return this.getPropertySource();
        }
        return super.getAdapter(key);
    }

    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new PageflowLinkPropertySource(this.getPFLink());
        }
        return this.propertySource;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.resetLabel();
        if (this.getConnectionRouterStyle() == 0) {
            this.refreshBendpoints();
        }
    }

    protected void refreshBendpoints() {
        EList modelConstraint = this.getPFLink().getBendPoints();
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < modelConstraint.size()) {
            PageflowLinkBendpoint wbp = (PageflowLinkBendpoint)modelConstraint.get(i);
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(wbp.getFirstRelativeDimension(), wbp.getSecondRelativeDimension());
            rbp.setWeight((float)(i + 1) / ((float)modelConstraint.size() + 1.0f));
            figureConstraint.add(rbp);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    public void setLineWidth(int w) {
        ((PFLinkFigure)this.getFigure()).setLineWidth(w);
    }

    public void setLabelVisible(boolean b) {
        ((PFLinkFigure)this.getFigure()).setLabelVisible(b);
    }

    public void setForegroundColor(Color c) {
        ((PFLinkFigure)this.getFigure()).setForegroundColor(c);
    }

    public void setBackgroundColor(Color c) {
        ((PFLinkFigure)this.getFigure()).setBackgroundColor(c);
    }

    public void setFont(Font f) {
        ((PFLinkFigure)this.getFigure()).setFont(f);
    }

    public void setLabelForegroundColor(Color c) {
        ((PFLinkFigure)this.getFigure()).setLabelForegroundColor(c);
    }

    public void setLabelBackgroundColor(Color c) {
        ((PFLinkFigure)this.getFigure()).setLabelBackgroundColor(c);
    }

    private boolean needDrawingLabel() {
        return ((PageflowLink)this.getModel()).getOutcome() != null && ((PageflowLink)this.getModel()).getOutcome().trim().length() > 0;
    }

    private boolean needDrawingAction() {
        return ((PageflowLink)this.getModel()).getFromaction() != null && ((PageflowLink)this.getModel()).getFromaction().trim().length() > 0;
    }

    public void addAnnotation(final Annotation annotation) {
        this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ((PFLinkFigure)PageflowLinkEditPart.this.getFigure()).setImage(PageflowLinkEditPart.getImage(IMG_WARNING));
                ((PFLinkFigure)PageflowLinkEditPart.this.getFigure()).setToolTipText(annotation.getText());
            }
        });
    }

    public void removeAnnotation() {
        this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ((PFLinkFigure)PageflowLinkEditPart.this.getFigure()).clearIcon();
                PageflowLinkEditPart.this.resetLabel();
            }
        });
    }

    public void resetLabel() {
        StringBuffer tip = new StringBuffer();
        if (this.needDrawingAction()) {
            ((PFLinkFigure)this.getFigure()).setActionImage();
            tip.append(PageflowMessages.PageflowLinkEditPart_FromAction).append(((PageflowLink)this.getModel()).getFromaction());
        } else if (((PFLinkFigure)this.getFigure()).getImage() != PageflowLinkEditPart.getImage(IMG_WARNING)) {
            ((PFLinkFigure)this.getFigure()).clearIcon();
        }
        if (this.needDrawingLabel()) {
            ((PFLinkFigure)this.getFigure()).setLabel(((PageflowLink)this.getModel()).getOutcome());
            if (tip.length() > 0) {
                tip.append("\n");
            }
            tip.append(PageflowMessages.PageflowLinkEditPart_FromOutcome).append(((PageflowLink)this.getModel()).getOutcome());
        } else {
            ((PFLinkFigure)this.getFigure()).clearOutcome();
        }
        ((PFLinkFigure)this.getFigure()).setToolTipText(tip.toString());
    }

    public IResource getMarkerResource() {
        IResource resource = WebrootUtil.getResource((EObject)this.getModel());
        return resource;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        Image image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
        if (image == null) {
            EditorPlugin.getDefault().getImageRegistry().put(imageDescriptor.toString(), imageDescriptor);
            image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
        }
        return image;
    }

    public void setConnectionRouterStyle(int style) {
        this.connectionStyle = style;
        if (this.getConnectionRouterStyle() == 0) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)this.getBendpointEditPolicy());
            this.refreshVisuals();
        } else {
            this.removeEditPolicy("Connection Bendpoint Policy");
            this.refreshVisuals();
        }
    }

    public int getConnectionRouterStyle() {
        if (this.connectionStyle == -1) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            String connectionStyle_ = store.getString("LineRouting");
            this.connectionStyle = "Manhattan".equals(connectionStyle_) ? 1 : 0;
        }
        return this.connectionStyle;
    }

    public void validate() {
        PageflowAnnotationUtil.validateLink(this);
    }

    private class PFLinkAdapter
    extends PFBatchAdapter {
        private Notifier _newTarget = null;

        private PFLinkAdapter() {
        }

        public Notifier getTarget() {
            return this._newTarget;
        }

        public boolean isAdapterForType(Object type) {
            return PageflowLinkEditPart.this.getModel().getClass() == type;
        }

        public void doNotifyChanged(Notification notification) {
            int type = notification.getEventType();
            int featureId = notification.getFeatureID(PageflowPackage.class);
            switch (type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    if (featureId == 11 || featureId == 10 || featureId == 9) {
                        PageflowAnnotationUtil.validateLink(PageflowLinkEditPart.this);
                    }
                    PageflowLinkEditPart.this.refreshVisuals();
                }
            }
        }

        public void setTarget(Notifier newTarget) {
            this._newTarget = newTarget;
        }
    }
}

