/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.jsf.common.ui.ICommonConstants;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.Alerts;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class JSFUICommonPlugin
extends AbstractUIPlugin
implements ICommonConstants {
    private static final String PROPERTIES = "default.properties";
    private static boolean TWO_DOT_ONE;
    private static boolean THREE_DOT;
    private static String _version;
    private static JSFUICommonPlugin _plugin;
    private Logger _log;
    private ResourceBundle _resourceBundle;
    private Properties _properties;
    private URL _pluginBase;
    private static Alerts _alerts;

    public JSFUICommonPlugin() {
        _plugin = this;
        this.versionCheck();
    }

    private void versionCheck() {
        String version = (String)ResourcesPlugin.getPlugin().getBundle().getHeaders().get("Bundle-Version");
        Version identifier = new Version(version);
        TWO_DOT_ONE = identifier.getMajor() == 2 && identifier.getMinor() == 1;
        THREE_DOT = identifier.getMajor() == 3;
        _version = identifier.toString();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (!JSFUICommonPlugin.isThreeDot()) {
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Requires eclipse version 3.x", null));
        }
        try {
            this._resourceBundle = ResourceBundle.getBundle("org.eclipse.jst.jsf.common.ui.CommonResources");
            _alerts = new Alerts(this, this._resourceBundle);
            this._properties = new Properties();
            InputStream input = null;
            this._pluginBase = this.getBundle().getEntry("/");
            try {
                input = new URL(this._pluginBase, PROPERTIES).openStream();
                this._properties.load(input);
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
            this._log = new Logger(this.getBundle(), this._resourceBundle);
        }
        catch (Exception ee) {
            if (this._log != null) {
                this._log.error("log.msg", "Problems starting plug-in Web Application Development Common.", ee);
            }
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Problems starting plug-in Web Application Development Common", (Throwable)ee));
        }
    }

    public static JSFUICommonPlugin getDefault() {
        return _plugin;
    }

    public static Alerts getAlerts() {
        return _alerts;
    }

    public static Logger getLogger(Class theClass) {
        return JSFUICommonPlugin.getDefault().getRootLogger();
    }

    public Logger getRootLogger() {
        return this._log;
    }

    public static String getPluginId() {
        return JSFUICommonPlugin.getDefault().getBundle().getSymbolicName();
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JSFUICommonPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getPluginDecriptorBundle() {
        return Platform.getResourceBundle((Bundle)JSFUICommonPlugin.getDefault().getBundle());
    }

    public Properties getProperties() {
        return this._properties;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public Image getImage(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        Image image = images.get(name);
        if (image == null) {
            try {
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(this._pluginBase, "icons/" + name));
                images.put(name, id);
                image = images.get(name);
            }
            catch (MalformedURLException ee) {
                this._log.error("log.msg", "log.CommonPlugin.image.error", name, ee);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        ImageDescriptor id = images.getDescriptor(name);
        if (id == null) {
            try {
                id = ImageDescriptor.createFromURL((URL)new URL(this._pluginBase, "icons/" + name));
                images.put(name, id);
            }
            catch (MalformedURLException ee) {
                this._log.error("log.msg", "log.CommonPlugin.image.error", name, ee);
            }
        }
        return id;
    }

    public InputStream readFile(String file) throws MalformedURLException, IOException {
        return new URL(this._pluginBase, file).openStream();
    }

    public static boolean isTwoDotOne() {
        return TWO_DOT_ONE;
    }

    public static boolean isThreeDot() {
        return THREE_DOT;
    }

    public static String getVersion() {
        return _version;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (JSFUICommonPlugin.getDefault().getWorkbench() == null) {
            return null;
        }
        return JSFUICommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = JSFUICommonPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("console.logging.on", this._properties.getProperty("console.logging.on", Boolean.TRUE.toString()));
        store.setDefault("console.logging.max.level", this.strToIntLogLevel(this._properties.getProperty("console.logging.max.level", "ERROR")));
        store.setDefault("eclipse.logging.on", this._properties.getProperty("eclipse.logging.on", Boolean.TRUE.toString()));
        store.setDefault("eclipse.logging.max.level", this.strToIntLogLevel(this._properties.getProperty("eclipse.logging.max.level", "ERROR")));
        store.setDefault("file.logging.on", this._properties.getProperty("file.logging.on", Boolean.FALSE.toString()));
        store.setDefault("file.logging.max.level", this.strToIntLogLevel(this._properties.getProperty("file.logging.max.level", "ERROR")));
        store.setDefault("file.logging.path", this._properties.getProperty("file.logging.path", ""));
        store.setDefault("file.logging.startup.clear", this._properties.getProperty("file.logging.startup.clear", Boolean.TRUE.toString()));
        store.setDefault("file.logging.rollover.frequency", this._properties.getProperty("file.logging.rollover.frequency", "DAILY"));
    }

    private int strToIntLogLevel(String str) {
        if (str == null) {
            return 3;
        }
        if (str.equalsIgnoreCase("DEBUG")) {
            return 0;
        }
        if (str.equalsIgnoreCase("INFO")) {
            return 1;
        }
        if (str.equalsIgnoreCase("WARN")) {
            return 2;
        }
        if (str.equalsIgnoreCase("FATAL")) {
            return 4;
        }
        return 3;
    }

    public int strToIntFrequency(String str) {
        if (str == null) {
            return 0;
        }
        if (str.equalsIgnoreCase("WEEKLY")) {
            return 1;
        }
        if (str.equalsIgnoreCase("MONTHLY")) {
            return 2;
        }
        return 0;
    }
}

