/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.perspectives;

import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebuggerPerspective
implements IPerspectiveFactory {
    public static final String DEBUGGER_PERSPECTIVE_ID = "org.eclipse.datatools.sqltools.debugger.perspectives.DebuggerPerspective";
    public static final String ID_NAVIGATOR_FOLDER_VIEW = "org.eclipse.debug.internal.ui.NavigatorFolderView";
    public static final String ID_TOOLS_FOLDER_VIEW = "org.eclipse.debug.internal.ui.ToolsFolderView";
    public static final String ID_CONSOLE_FOLDER_VIEW = "org.eclipse.debug.internal.ui.ConsoleFolderView";
    public static final String ID_OUTLINE_FOLDER_VIEW = "org.eclipse.debug.internal.ui.OutlineFolderView";

    public void createInitialLayout(IPageLayout layout) {
        IFolderLayout consoleFolder = layout.createFolder(ID_CONSOLE_FOLDER_VIEW, 4, 0.75f, layout.getEditorArea());
        consoleFolder.addView("org.eclipse.datatools.sqltools.result.resultView");
        consoleFolder.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        consoleFolder.addPlaceholder("org.eclipse.ui.views.PropertySheet");
        IFolderLayout navFolder = layout.createFolder(ID_NAVIGATOR_FOLDER_VIEW, 3, 0.45f, layout.getEditorArea());
        navFolder.addView("org.eclipse.debug.ui.DebugView");
        navFolder.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");
        IFolderLayout toolsFolder = layout.createFolder(ID_TOOLS_FOLDER_VIEW, 2, 0.5f, ID_NAVIGATOR_FOLDER_VIEW);
        toolsFolder.addView("org.eclipse.debug.ui.VariableView");
        toolsFolder.addView("org.eclipse.debug.ui.BreakpointView");
        toolsFolder.addPlaceholder("org.eclipse.debug.ui.ExpressionView");
        toolsFolder.addPlaceholder("org.eclipse.debug.ui.RegisterView");
        IFolderLayout outlineFolder = layout.createFolder(ID_OUTLINE_FOLDER_VIEW, 2, 0.75f, layout.getEditorArea());
        outlineFolder.addView("org.eclipse.ui.views.ContentOutline");
        layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
        layout.addActionSet(IDebugUIConstants.DEBUG_ACTION_SET);
        layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        this.setContentsOfShowViewMenu(layout);
    }

    protected void setContentsOfShowViewMenu(IPageLayout layout) {
        layout.addShowViewShortcut("org.eclipse.debug.ui.DebugView");
        layout.addShowViewShortcut("org.eclipse.debug.ui.VariableView");
        layout.addShowViewShortcut("org.eclipse.debug.ui.BreakpointView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
    }

    public static void changePerspective() {
        try {
            IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor desc = reg.findPerspectiveWithId(DEBUGGER_PERSPECTIVE_ID);
            IWorkbench i = PlatformUI.getWorkbench();
            IWorkbenchWindow[] j = i.getWorkbenchWindows();
            IWorkbenchWindow window = i.getActiveWorkbenchWindow();
            if (window == null) {
                DebuggerCorePlugin.getDefault().log(DebuggerMessages.perspective_DebuggerPerspective_activeWinNull1);
                window = j[0];
            }
            if (window == null) {
                DebuggerCorePlugin.getDefault().log(DebuggerMessages.perspective_DebuggerPerspective_activeWinNull2);
            }
            IWorkbenchPage page = window.getActivePage();
            page.setPerspective(desc);
        }
        catch (Exception e) {
            DebuggerCorePlugin.getDefault().log(DebuggerMessages.perspective_DebuggerPerspective_changePerspectiveException);
        }
    }
}

