/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.delegates;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistryReader;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ValidatorDelegatesRegistry {
    private static ValidatorDelegatesRegistry instance;
    private Map delegatesByTarget = new HashMap();

    public static ValidatorDelegatesRegistry getInstance() {
        if (instance == null) {
            instance = new ValidatorDelegatesRegistry();
            ValidatorDelegatesRegistryReader reader = new ValidatorDelegatesRegistryReader(instance);
            reader.readRegistry();
        }
        return instance;
    }

    void add(ValidatorDelegateDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        String targetID = descriptor.getTargetID();
        HashMap<String, ValidatorDelegateDescriptor> delegates = (HashMap<String, ValidatorDelegateDescriptor>)this.delegatesByTarget.get(targetID);
        if (delegates == null) {
            delegates = new HashMap<String, ValidatorDelegateDescriptor>();
            this.delegatesByTarget.put(targetID, delegates);
        }
        delegates.put(descriptor.getId(), descriptor);
    }

    public String getDefaultDelegate(String targetID) {
        Map delegates = this.getDelegateDescriptors(targetID);
        if (delegates == null) {
            return null;
        }
        Iterator delegatesIterator = delegates.values().iterator();
        if (!delegatesIterator.hasNext()) {
            return null;
        }
        ValidatorDelegateDescriptor descriptor = (ValidatorDelegateDescriptor)delegatesIterator.next();
        return descriptor.getId();
    }

    public IValidator getDelegate(String targetID, String delegateID) throws ValidationException {
        ValidatorDelegateDescriptor descriptor = this.getDescriptor(targetID, delegateID);
        if (descriptor == null) {
            return null;
        }
        IValidator delegate = descriptor.getValidator();
        return delegate;
    }

    public Map getDelegateDescriptors(String targetID) {
        return (Map)this.delegatesByTarget.get(targetID);
    }

    public ValidatorDelegateDescriptor getDescriptor(String targetID, String delegateID) {
        Map delegates = (Map)this.delegatesByTarget.get(targetID);
        if (delegates == null) {
            return null;
        }
        if (delegateID == null) {
            return null;
        }
        ValidatorDelegateDescriptor descriptor = (ValidatorDelegateDescriptor)delegates.get(delegateID);
        return descriptor;
    }

    public boolean hasDelegates(String targetID) {
        Map delegatesByID = (Map)this.delegatesByTarget.get(targetID);
        boolean hasDelegates = delegatesByID != null && !delegatesByID.isEmpty();
        return hasDelegates;
    }
}

