/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleCommentAction
extends TextEditorAction {
    private ITextOperationTarget fOperationTarget;
    private String fDocumentPartitioning;
    private Map fPrefixesMap;

    public ToggleCommentAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
        super(resourceBundle, string, iTextEditor);
    }

    public void run() {
        if (this.fOperationTarget == null || this.fDocumentPartitioning == null || this.fPrefixesMap == null) {
            return;
        }
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        final int n = this.isSelectionCommented(iTextEditor.getSelectionProvider().getSelection()) ? 12 : 11;
        Shell shell = iTextEditor.getSite().getShell();
        if (!this.fOperationTarget.canDoOperation(n)) {
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Error commenting code");
            }
            return;
        }
        Display display = null;
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                ToggleCommentAction.this.fOperationTarget.doOperation(n);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSelectionCommented(ISelection iSelection) {
        if (!(iSelection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection iTextSelection = (ITextSelection)iSelection;
        IDocument iDocument = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        try {
            IRegion iRegion = this.getTextBlockFromSelection(iTextSelection, iDocument);
            ITypedRegion[] iTypedRegionArray = TextUtilities.computePartitioning((IDocument)iDocument, (String)this.fDocumentPartitioning, (int)iRegion.getOffset(), (int)iRegion.getLength(), (boolean)false);
            int n = 0;
            int[] nArray = new int[iTypedRegionArray.length * 2];
            int n2 = 0;
            int n3 = 0;
            while (n2 < iTypedRegionArray.length) {
                nArray[n3] = this.getFirstCompleteLineOfRegion((IRegion)iTypedRegionArray[n2], iDocument);
                int n4 = iTypedRegionArray[n2].getLength();
                int n5 = iTypedRegionArray[n2].getOffset() + n4;
                if (n4 > 0) {
                    --n5;
                }
                nArray[n3 + 1] = nArray[n3] == -1 ? -1 : iDocument.getLineOfOffset(n5);
                n += nArray[n3 + 1] - nArray[n3] + 1;
                ++n2;
                n3 += 2;
            }
            n2 = 0;
            n3 = 0;
            while (n2 < iTypedRegionArray.length) {
                String[] stringArray = (String[])this.fPrefixesMap.get(iTypedRegionArray[n2].getType());
                if (stringArray != null && stringArray.length > 0 && nArray[n3] >= 0 && nArray[n3 + 1] >= 0 && !this.isBlockCommented(nArray[n3], nArray[n3 + 1], stringArray, iDocument)) {
                    return false;
                }
                ++n2;
                n3 += 2;
            }
            return true;
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return false;
        }
    }

    private IRegion getTextBlockFromSelection(ITextSelection iTextSelection, IDocument iDocument) {
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(iTextSelection.getOffset());
            int n = iTextSelection.getLength() == 0 ? iRegion.getLength() : iTextSelection.getLength() + (iTextSelection.getOffset() - iRegion.getOffset());
            return new Region(iRegion.getOffset(), n);
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return null;
        }
    }

    private int getFirstCompleteLineOfRegion(IRegion iRegion, IDocument iDocument) {
        try {
            int n = iDocument.getLineOfOffset(iRegion.getOffset());
            int n2 = iDocument.getLineOffset(n);
            if (n2 >= iRegion.getOffset()) {
                return n;
            }
            n2 = iDocument.getLineOffset(n + 1);
            return n2 > iRegion.getOffset() + iRegion.getLength() ? -1 : n + 1;
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBlockCommented(int n, int n2, String[] stringArray, IDocument iDocument) {
        try {
            int n3 = n;
            while (true) {
                if (n3 > n2) {
                    return true;
                }
                IRegion iRegion = iDocument.getLineInformation(n3);
                String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                int[] nArray = TextUtilities.indexOf((String[])stringArray, (String)string, (int)0);
                if (nArray[0] == -1) {
                    return false;
                }
                String string2 = iDocument.get(iRegion.getOffset(), nArray[0]);
                if ((string2 = string2.trim()).length() != 0) {
                    return false;
                }
                ++n3;
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return false;
        }
    }

    public void update() {
        super.update();
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor iTextEditor = this.getTextEditor();
        if (this.fOperationTarget == null && iTextEditor != null) {
            this.fOperationTarget = (ITextOperationTarget)iTextEditor.getAdapter(ITextOperationTarget.class);
        }
        boolean bl = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(11) && this.fOperationTarget.canDoOperation(12);
        this.setEnabled(bl);
    }

    public void setEditor(ITextEditor iTextEditor) {
        super.setEditor(iTextEditor);
        this.fOperationTarget = null;
    }

    public void configure(ISourceViewer iSourceViewer, SourceViewerConfiguration sourceViewerConfiguration) {
        this.fPrefixesMap = null;
        String[] stringArray = sourceViewerConfiguration.getConfiguredContentTypes(iSourceViewer);
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String[] stringArray2 = sourceViewerConfiguration.getDefaultPrefixes(iSourceViewer, string);
            if (stringArray2 != null && stringArray2.length > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    if (stringArray2[n3].length() == 0) {
                        ++n2;
                    }
                    ++n3;
                }
                if (n2 > 0) {
                    String[] stringArray3 = new String[stringArray2.length - n2];
                    int n4 = 0;
                    int n5 = 0;
                    while (n4 < stringArray2.length) {
                        String string2 = stringArray2[n4];
                        if (string2.length() != 0) {
                            stringArray3[n5] = string2;
                            ++n5;
                        }
                        ++n4;
                    }
                    stringArray2 = stringArray3;
                }
                hashMap.put(string, stringArray2);
            }
            ++n;
        }
        this.fDocumentPartitioning = sourceViewerConfiguration.getConfiguredDocumentPartitioning(iSourceViewer);
        this.fPrefixesMap = hashMap;
    }
}

