/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.php.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TransferData;

public class DelegatingDropAdapter
implements DropTargetListener {
    private TransferDropTargetListener[] fListeners;
    private TransferDropTargetListener fChosenListener;

    public DelegatingDropAdapter(TransferDropTargetListener[] transferDropTargetListenerArray) {
        this.fListeners = transferDropTargetListenerArray;
        Assert.isNotNull((Object)transferDropTargetListenerArray);
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.fChosenListener = null;
        dropTargetEvent.currentDataType = this.selectPreferredListener(dropTargetEvent.dataTypes);
        if (this.fChosenListener != null) {
            this.fChosenListener.dragEnter(dropTargetEvent);
        }
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragLeave(dropTargetEvent);
        }
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragOperationChanged(dropTargetEvent);
        }
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dragOver(dropTargetEvent);
        }
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        if (this.fChosenListener != null) {
            this.fChosenListener.drop(dropTargetEvent);
        }
        this.fChosenListener = null;
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        if (this.fChosenListener != null) {
            this.fChosenListener.dropAccept(dropTargetEvent);
        }
    }

    private TransferData selectPreferredListener(TransferData[] transferDataArray) {
        int n = 0;
        while (n < this.fListeners.length) {
            TransferData transferData = this.computeTransferData(transferDataArray, this.fListeners[n]);
            if (transferData != null) {
                return transferData;
            }
            ++n;
        }
        return null;
    }

    private TransferData computeTransferData(TransferData[] transferDataArray, TransferDropTargetListener transferDropTargetListener) {
        int n = 0;
        while (n < transferDataArray.length) {
            if (transferDropTargetListener.getTransfer().isSupportedType(transferDataArray[n])) {
                this.fChosenListener = transferDropTargetListener;
                return transferDataArray[n];
            }
            ++n;
        }
        return null;
    }
}

