/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public class Element {
    public final ElementType type;
    public final String name;
    public final Element parent;

    public Element(ElementType elementType, String string, Element element) {
        this.type = elementType;
        this.name = string;
        this.parent = element;
    }

    public Element(ElementType elementType, String string) {
        this(elementType, string, null);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        assert (object instanceof Element);
        Element element = (Element)object;
        if (this.parent == null ? element.parent != null : !this.parent.equals(element.parent)) {
            return false;
        }
        if (this.name == null ? element.name != null : !this.name.equals(element.name)) {
            return false;
        }
        return !(this.type == null ? element.type != null : !this.type.equals((Object)element.type));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Element ");
        stringBuffer.append(this.type.toString());
        stringBuffer.append(": ");
        stringBuffer.append(", Name: ");
        stringBuffer.append(this.name);
        stringBuffer.append(", Parent: ");
        stringBuffer.append(this.parent);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static class ElementFactory {
        private ElementFactory() {
        }

        public static final Element createElement(PHPFileData pHPFileData, boolean bl) {
            Element element = new Element(ElementType.FILE, pHPFileData.getComparableName());
            return bl ? ElementFactory.createElement(element) : element;
        }

        public static final Element createElement(PHPClassData pHPClassData, boolean bl) {
            Element element = new Element(ElementType.CLASS, pHPClassData.getName());
            return bl ? ElementFactory.createElement(element) : element;
        }

        public static final Element createElement(PHPFunctionData pHPFunctionData, boolean bl) {
            Element element = new Element(ElementType.FUNCTION, pHPFunctionData.getName());
            return bl ? ElementFactory.createElement(element) : element;
        }

        public static final Element createElement(PHPClassData pHPClassData, PHPFunctionData pHPFunctionData, boolean bl) {
            Element element = ElementFactory.createElement(pHPClassData, false);
            Element element2 = new Element(ElementType.METHOD, pHPFunctionData.getName(), element);
            return bl ? ElementFactory.createElement(element2) : element2;
        }

        public static final Element createElement(PHPClassData pHPClassData, PHPClassVarData pHPClassVarData, boolean bl) {
            Element element = ElementFactory.createElement(pHPClassData, false);
            Element element2 = new Element(ElementType.FIELD, pHPClassVarData.getName(), element);
            return bl ? ElementFactory.createElement(element2) : element2;
        }

        public static final Element createElement(PHPClassData pHPClassData, PHPClassConstData pHPClassConstData, boolean bl) {
            Element element = ElementFactory.createElement(pHPClassData, false);
            Element element2 = new Element(ElementType.CONSTANT, pHPClassConstData.getName(), element);
            return bl ? ElementFactory.createElement(element2) : element2;
        }

        public static final Element createElement(Element element) {
            return new Element(ElementType.DOC, null, element);
        }

        public static Element createElement(PHPCodeData pHPCodeData, boolean bl) {
            Element element = null;
            PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
            if (pHPCodeData instanceof PHPFileData) {
                element = ElementFactory.createElement((PHPFileData)pHPCodeData, false);
            } else if (pHPCodeData instanceof PHPClassData) {
                element = ElementFactory.createElement((PHPClassData)pHPCodeData, false);
            } else if (pHPCodeData instanceof PHPFunctionData) {
                if (pHPCodeData2 instanceof PHPClassData) {
                    assert (pHPCodeData2 != null);
                    element = ElementFactory.createElement((PHPClassData)pHPCodeData2, (PHPFunctionData)pHPCodeData, false);
                } else {
                    assert (pHPCodeData2 instanceof PHPFileData);
                    element = ElementFactory.createElement((PHPFunctionData)pHPCodeData, false);
                }
            } else if (pHPCodeData instanceof PHPClassVarData) {
                assert (pHPCodeData2 != null);
                element = ElementFactory.createElement((PHPClassData)pHPCodeData2, (PHPClassVarData)pHPCodeData, false);
            } else if (pHPCodeData instanceof PHPClassConstData) {
                assert (pHPCodeData2 != null);
                element = ElementFactory.createElement((PHPClassData)pHPCodeData2, (PHPClassConstData)pHPCodeData, false);
            } else {
                throw new IllegalStateException("Internal Error: CodeData is not supported as folded element");
            }
            return bl ? ElementFactory.createElement(element) : element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        FILE("File"),
        CLASS("Class"),
        FUNCTION("Function"),
        METHOD("Method"),
        FIELD("Field"),
        CONSTANT("Constant"),
        DOC("PHP Doc");

        private final String elementTypeName;

        private ElementType(String string2) {
            this.elementTypeName = string2;
        }

        public String toString() {
            return this.elementTypeName;
        }
    }
}

