/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectOutline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.StandardPHPElementContentProvider;
import org.eclipse.php.internal.ui.SuperClassTreeContentProvider;
import org.eclipse.php.internal.ui.explorer.PHPTreeViewer;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlinePart;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.widgets.Control;

public class ProjectOutlineContentProvider
extends StandardPHPElementContentProvider
implements ModelListener,
IWorkspaceModelListener {
    public static final int INCLUDES = 1;
    public static final int CONSTANTS = 2;
    public static final int CLASSES = 3;
    public static final int FUNCTIONS = 4;
    private final ProjectOutlinePart fPart;
    private IProject fStoredProject;
    private PHPTreeViewer fViewer;
    private OutlineNode[] groupNodes;
    private OutlineNode[] nodes;
    private Timer timer;
    private ITreeContentProvider superClassContentProvider = new SuperClassTreeContentProvider(this);

    public ProjectOutlineContentProvider(ProjectOutlinePart projectOutlinePart, boolean bl) {
        this.fPart = projectOutlinePart;
        this.fViewer = projectOutlinePart.getViewer();
    }

    public static int getNodeType(Object object) {
        if (object instanceof OutlineNode) {
            return ((OutlineNode)object).getType();
        }
        return -1;
    }

    public void dispose() {
        PHPWorkspaceModelManager.getInstance().removeWorkspaceModelListener((IWorkspaceModelListener)this);
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.dispose();
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        this.postAdd(pHPFileData);
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        this.postRefresh(pHPFileData, true);
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
        this.postRemove(pHPFileData);
    }

    public Object[] getChildrenInternal(Object object) {
        if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            if (this.groupNodes == null || iProject != this.fStoredProject) {
                this.groupNodes = this.getOutlineChildren(iProject);
                this.fStoredProject = iProject;
            }
            return this.groupNodes;
        }
        if (object instanceof OutlineNode) {
            OutlineNode outlineNode = (OutlineNode)object;
            return outlineNode.getChildren();
        }
        if (object instanceof PHPCodeData) {
            ArrayList arrayList = new ArrayList(Arrays.asList(super.getChildrenInternal(object)));
            arrayList.addAll(Arrays.asList(this.superClassContentProvider.getChildren(object)));
            return arrayList.toArray();
        }
        return super.getChildrenInternal(object);
    }

    private OutlineNode[] getOutlineChildren(IProject iProject) {
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        if (this.nodes == null) {
            this.nodes = new OutlineNode[]{new OutlineNode(2, "Constants", pHPProjectModel, this.fPart), new OutlineNode(3, "Classes", pHPProjectModel, this.fPart), new OutlineNode(4, "Functions", pHPProjectModel, this.fPart)};
        } else {
            int n = 0;
            while (n < this.nodes.length) {
                this.nodes[n].setModel(pHPProjectModel);
                ++n;
            }
        }
        return this.nodes;
    }

    public boolean hasChildrenInternal(Object object) {
        if (object instanceof IProject) {
            return true;
        }
        if (object instanceof OutlineNode) {
            OutlineNode outlineNode = (OutlineNode)object;
            return outlineNode.hasChildren();
        }
        if (object instanceof PHPCodeData && this.superClassContentProvider.hasChildren(object)) {
            return true;
        }
        return super.hasChildrenInternal(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        this.fViewer = (PHPTreeViewer)viewer;
        if (object == null && object2 != null) {
            PHPWorkspaceModelManager.getInstance().addWorkspaceModelListener((IWorkspaceModelListener)this);
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
        } else if (object != null && object2 == null) {
            PHPWorkspaceModelManager.getInstance().removeWorkspaceModelListener((IWorkspaceModelListener)this);
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        }
        this.postRefresh(object2, true);
    }

    protected Object internalGetParent(Object object) {
        Object object2;
        if (object instanceof PHPCodeData && (object2 = this.superClassContentProvider.getParent(object)) != null) {
            return object2;
        }
        object2 = super.internalGetParent(object);
        if (object2 == this.fViewer.getInput() || object2 instanceof PHPFileData) {
            if (this.groupNodes == null) {
                this.groupNodes = this.getOutlineChildren(this.fStoredProject);
            }
            int n = 0;
            while (n < this.groupNodes.length) {
                if (this.groupNodes[n].getType() == 3 && object instanceof PHPClassData) {
                    return this.groupNodes[n];
                }
                if (this.groupNodes[n].getType() == 4 && object instanceof PHPFunctionData) {
                    return this.groupNodes[n];
                }
                if (this.groupNodes[n].getType() == 2 && object instanceof PHPConstantData) {
                    return this.groupNodes[n];
                }
                ++n;
            }
        }
        return object2;
    }

    private void postAdd(final PHPFileData pHPFileData) {
        if (this.fViewer == null || this.fViewer.getControl() == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (ProjectOutlineContentProvider.this.fViewer == null) {
                    return;
                }
                Control control = ProjectOutlineContentProvider.this.fViewer.getControl();
                if (control == null || control.isDisposed() || !control.isVisible()) {
                    return;
                }
                IResource iResource = PHPModelUtil.getResource((Object)pHPFileData);
                if (iResource == null) {
                    return;
                }
                if (iResource.getProject() != ProjectOutlineContentProvider.this.fStoredProject) {
                    return;
                }
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iResource.getProject());
                int n = 0;
                while (n < ProjectOutlineContentProvider.this.groupNodes.length) {
                    OutlineNode outlineNode = ProjectOutlineContentProvider.this.groupNodes[n];
                    if (pHPProjectModel != outlineNode.getModel()) {
                        outlineNode.setModel(pHPProjectModel);
                    }
                    Object[] objectArray = outlineNode.addChildren(pHPFileData);
                    ProjectOutlineContentProvider.this.fViewer.add(outlineNode, objectArray);
                    ++n;
                }
                n = 0;
                while (n < ProjectOutlineContentProvider.this.treeProviders.length) {
                    IPHPTreeContentProvider iPHPTreeContentProvider = ProjectOutlineContentProvider.this.treeProviders[n];
                    Object[] objectArray = iPHPTreeContentProvider.getChildren(ProjectOutlineContentProvider.this.fStoredProject);
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        ProjectOutlineContentProvider.this.fViewer.refresh(objectArray[n2], true);
                        ++n2;
                    }
                    ++n;
                }
            }
        };
        this.fViewer.getControl().getDisplay().asyncExec(runnable);
    }

    private void postRemove(final PHPFileData pHPFileData) {
        if (this.fViewer == null || this.fViewer.getControl() == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (ProjectOutlineContentProvider.this.fViewer == null) {
                    return;
                }
                Control control = ProjectOutlineContentProvider.this.fViewer.getControl();
                if (control == null || control.isDisposed() || !control.isVisible()) {
                    return;
                }
                IResource iResource = PHPModelUtil.getResource((Object)pHPFileData);
                if (iResource == null) {
                    return;
                }
                if (iResource.getProject() != ProjectOutlineContentProvider.this.fStoredProject) {
                    return;
                }
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iResource.getProject());
                int n = 0;
                while (n < ProjectOutlineContentProvider.this.groupNodes.length) {
                    OutlineNode outlineNode = ProjectOutlineContentProvider.this.groupNodes[n];
                    if (pHPProjectModel != outlineNode.getModel()) {
                        outlineNode.setModel(pHPProjectModel);
                    }
                    Object[] objectArray = outlineNode.removeChildren(pHPFileData);
                    ProjectOutlineContentProvider.this.fViewer.remove(outlineNode, objectArray);
                    ++n;
                }
                n = 0;
                while (n < ProjectOutlineContentProvider.this.treeProviders.length) {
                    IPHPTreeContentProvider iPHPTreeContentProvider = ProjectOutlineContentProvider.this.treeProviders[n];
                    Object[] objectArray = iPHPTreeContentProvider.getChildren(ProjectOutlineContentProvider.this.fStoredProject);
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        ProjectOutlineContentProvider.this.fViewer.refresh(objectArray[n2], true);
                        ++n2;
                    }
                    ++n;
                }
            }
        };
        this.fViewer.getControl().getDisplay().asyncExec(runnable);
    }

    public void postRefresh(final Object object, boolean bl) {
        if (this.fViewer == null || this.fViewer.getControl() == null) {
            return;
        }
        final Runnable runnable = new Runnable(){

            public void run() {
                if (ProjectOutlineContentProvider.this.fViewer == null) {
                    return;
                }
                Control control = ProjectOutlineContentProvider.this.fViewer.getControl();
                if (control == null || control.isDisposed() || !control.isVisible()) {
                    return;
                }
                IResource iResource = PHPModelUtil.getResource((Object)object);
                if (iResource == null) {
                    return;
                }
                if (iResource.getProject() != ProjectOutlineContentProvider.this.fStoredProject) {
                    return;
                }
                PHPProjectModel pHPProjectModel = null;
                pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iResource.getProject());
                int n = 0;
                while (n < ProjectOutlineContentProvider.this.groupNodes.length) {
                    OutlineNode outlineNode = ProjectOutlineContentProvider.this.groupNodes[n];
                    if (pHPProjectModel != outlineNode.getModel()) {
                        outlineNode.setModel(pHPProjectModel);
                    }
                    outlineNode.loadChildren();
                    ProjectOutlineContentProvider.this.fViewer.refresh(outlineNode, true);
                    ++n;
                }
                n = 0;
                while (n < ProjectOutlineContentProvider.this.treeProviders.length) {
                    IPHPTreeContentProvider iPHPTreeContentProvider = ProjectOutlineContentProvider.this.treeProviders[n];
                    Object[] objectArray = iPHPTreeContentProvider.getChildren(ProjectOutlineContentProvider.this.fStoredProject);
                    if (objectArray != null) {
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            ProjectOutlineContentProvider.this.fViewer.refresh(objectArray[n2], true);
                            ++n2;
                        }
                    }
                    ++n;
                }
                ISelection iSelection = ProjectOutlineContentProvider.this.fViewer.getSelection();
                if (iSelection.isEmpty()) {
                    ProjectOutlineContentProvider.this.fViewer.setSelection(ProjectOutlineContentProvider.this.fViewer.getStoredSelection(), false);
                }
            }
        };
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                ProjectOutlineContentProvider.this.fViewer.getControl().getDisplay().asyncExec(runnable);
            }
        }, 1000L);
    }

    public void projectModelAdded(IProject iProject) {
        if (this.fPart.isInCurrentProject(iProject)) {
            this.postRefresh(iProject, true);
        }
    }

    public void projectModelChanged(IProject iProject) {
    }

    public void projectModelRemoved(IProject iProject) {
        if (this.fPart.isInCurrentProject(iProject)) {
            this.postRefresh(iProject, true);
        }
    }

    static /* synthetic */ Object[] access$0() {
        return StandardPHPElementContentProvider.NO_CHILDREN;
    }

    public static class OutlineNode
    implements Comparable {
        private final Set children = new TreeSet();
        private final ProjectOutlinePart part;
        private final String text;
        private final int type;
        private PHPProjectModel model;

        public OutlineNode(int n, String string, PHPProjectModel pHPProjectModel, ProjectOutlinePart projectOutlinePart) {
            this.type = n;
            this.text = string;
            this.model = pHPProjectModel;
            this.part = projectOutlinePart;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            if (object instanceof OutlineNode) {
                OutlineNode outlineNode = (OutlineNode)object;
                return this.type - outlineNode.type;
            }
            return 0;
        }

        public Object[] getChildren() {
            if (this.model == null) {
                return ProjectOutlineContentProvider.access$0();
            }
            return this.children.toArray();
        }

        public PHPProjectModel getModel() {
            return this.model;
        }

        public String getText() {
            return this.text;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasChildren() {
            if (this.model == null) {
                return false;
            }
            return this.children.size() > 0;
        }

        PHPCodeData[] addChildren(PHPFileData pHPFileData) {
            PHPCodeData[] pHPCodeDataArray = new PHPCodeData[]{};
            if (pHPFileData != null) {
                switch (this.type) {
                    case 3: {
                        pHPCodeDataArray = pHPFileData.getClasses();
                        break;
                    }
                    case 4: {
                        pHPCodeDataArray = pHPFileData.getFunctions();
                        break;
                    }
                    case 2: {
                        pHPCodeDataArray = pHPFileData.getConstants();
                    }
                }
            }
            int n = 0;
            while (n < pHPCodeDataArray.length) {
                this.children.add(pHPCodeDataArray[n]);
                ++n;
            }
            return pHPCodeDataArray;
        }

        PHPCodeData[] removeChildren(PHPFileData pHPFileData) {
            PHPCodeData[] pHPCodeDataArray = new PHPCodeData[]{};
            if (pHPFileData != null) {
                switch (this.type) {
                    case 3: {
                        pHPCodeDataArray = pHPFileData.getClasses();
                        break;
                    }
                    case 4: {
                        pHPCodeDataArray = pHPFileData.getFunctions();
                        break;
                    }
                    case 2: {
                        pHPCodeDataArray = pHPFileData.getConstants();
                    }
                }
            }
            int n = 0;
            while (n < pHPCodeDataArray.length) {
                this.children.remove(pHPCodeDataArray[n]);
                ++n;
            }
            return pHPCodeDataArray;
        }

        void loadChildren() {
            if (this.model == null) {
                return;
            }
            this.children.clear();
            Object[] objectArray = ProjectOutlineContentProvider.access$0();
            switch (this.type) {
                case 3: {
                    if (this.part.isShowAll()) {
                        objectArray = this.model.getClasses();
                        break;
                    }
                    objectArray = this.model.getPHPUserModel().getClasses();
                    break;
                }
                case 4: {
                    if (this.part.isShowAll()) {
                        objectArray = this.model.getFunctions();
                        break;
                    }
                    objectArray = this.model.getPHPUserModel().getFunctions();
                    break;
                }
                case 2: {
                    objectArray = this.part.isShowAll() ? this.model.getConstants() : this.model.getPHPUserModel().getConstants();
                }
            }
            int n = 0;
            while (n < objectArray.length) {
                this.children.add(objectArray[n]);
                ++n;
            }
        }

        public void resetChildren() {
            this.children.clear();
        }

        public void setModel(PHPProjectModel pHPProjectModel) {
            this.model = pHPProjectModel;
        }
    }
}

