/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.ui.workingset.WorkingSetFilterActionGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class WorkingSetMenuContributionItem
extends ContributionItem {
    private int fId;
    private IWorkingSet fWorkingSet;
    private WorkingSetFilterActionGroup fActionGroup;
    private Image fImage;

    public WorkingSetMenuContributionItem(int n, WorkingSetFilterActionGroup workingSetFilterActionGroup, IWorkingSet iWorkingSet) {
        super(WorkingSetMenuContributionItem.getId(n));
        Assert.isNotNull((Object)workingSetFilterActionGroup);
        Assert.isNotNull((Object)iWorkingSet);
        this.fId = n;
        this.fActionGroup = workingSetFilterActionGroup;
        this.fWorkingSet = iWorkingSet;
    }

    public void fill(Menu menu, int n) {
        ImageDescriptor imageDescriptor;
        MenuItem menuItem = new MenuItem(menu, 16, n);
        menuItem.setText("&" + this.fId + " " + this.fWorkingSet.getName());
        if (this.fImage == null && (imageDescriptor = this.fWorkingSet.getImage()) != null) {
            this.fImage = imageDescriptor.createImage();
        }
        menuItem.setImage(this.fImage);
        menuItem.setSelection(this.fWorkingSet.equals(this.fActionGroup.getWorkingSet()));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                WorkingSetMenuContributionItem.this.fActionGroup.setWorkingSet(WorkingSetMenuContributionItem.this.fWorkingSet, true);
                iWorkingSetManager.addRecentWorkingSet(WorkingSetMenuContributionItem.this.fWorkingSet);
            }
        });
    }

    public void dispose() {
        if (this.fImage != null && !this.fImage.isDisposed()) {
            this.fImage.dispose();
        }
        this.fImage = null;
        super.dispose();
    }

    public boolean isDynamic() {
        return true;
    }

    static String getId(int n) {
        return String.valueOf(WorkingSetMenuContributionItem.class.getName()) + "." + n;
    }
}

