/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.style.HiddenElementStyle;
import org.eclipse.jst.pagedesigner.css2.widget.ImageWidgetProvider;
import org.eclipse.jst.pagedesigner.parts.EditProxyAdapter;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;

public class HiddenProvider
extends ImageWidgetProvider {
    private static final int GAP = 3;
    private String _label = null;
    private boolean _labelVisible = true;
    private FontMetrics _fontMetrics;

    public HiddenProvider(Image image, Element convertedElement) {
        super(image, new HiddenElementStyle(convertedElement));
    }

    public HiddenProvider(Image image, ElementEditPart editPart) {
        super(image, new HiddenElementStyle(new EditProxyAdapter(editPart)));
    }

    public DimensionInfo getPreferredDimension(int width, int height) {
        int preWidth = width;
        int preHeight = height;
        this._fontMetrics = this.getFontMetrics();
        if (width <= 0) {
            preWidth = this.getLabelWidth() + this._imageWidth;
        }
        if (height <= 0) {
            preHeight = Math.max(this.getLabelHeight(), this._imageHeight);
        }
        return new DimensionInfo(preWidth, preHeight, -1);
    }

    private FontMetrics getFontMetrics() {
        Font swtfont = Display.getCurrent().getSystemFont();
        return FigureUtilities.getFontMetrics((Font)swtfont);
    }

    private int getLabelHeight() {
        if (this._labelVisible && this._label != null && !this._label.equals("") && this._fontMetrics != null) {
            return this._fontMetrics.getHeight();
        }
        return 0;
    }

    public int getLabelWidth() {
        if (this._labelVisible && this._label != null && !this._label.equals("") && this._fontMetrics != null) {
            Font swtfont = Display.getCurrent().getSystemFont();
            return FigureUtilities.getTextWidth((String)this._label, (Font)swtfont) + 3;
        }
        return 0;
    }

    public void paintFigure(Graphics g, Rectangle rect) {
        g.fillRectangle(rect);
        g.setClip(rect);
        int imageAreaWidth = Math.min(rect.width, this._imageWidth);
        int imageAreaHeight = Math.min(rect.height, this._imageHeight);
        if (this._image != null) {
            g.drawImage(this._image, 0, 0, this._imageWidth, this._imageHeight, rect.x, rect.y + (rect.height - imageAreaHeight) / 2, imageAreaWidth, imageAreaHeight);
        }
        if (this._label != null && this._labelVisible) {
            int leading = 0;
            if (this._fontMetrics != null) {
                leading = this._fontMetrics.getLeading();
            }
            Color fg = FigureUtilities.darker((Color)g.getBackgroundColor());
            g.setForegroundColor(fg);
            g.drawString(this._label, imageAreaWidth + 3, rect.y + (rect.height - this.getLabelHeight()) / 2 + leading);
            fg.dispose();
        }
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public boolean isLabelVisible() {
        return this._labelVisible;
    }

    public void setLabelVisible(boolean labelVisible) {
        this._labelVisible = labelVisible;
    }
}

