/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.IDriverInstancePropertyDescriptor;
import org.eclipse.datatools.connectivity.internal.DriverUtil;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DriverClassBrowsePropertyDescriptor
extends TextPropertyDescriptor
implements IDriverInstancePropertyDescriptor {
    private static String DRIVER_CLASS_PROP_ID = "org.eclipse.datatools.connectivity.db.driverClass";
    private String[] mJarList = null;

    public DriverClassBrowsePropertyDescriptor() {
        super((Object)DRIVER_CLASS_PROP_ID, ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.property.label"));
    }

    public DriverClassBrowsePropertyDescriptor(Object id, String displayName, String[] jarList) {
        super(id, displayName);
        this.mJarList = jarList;
    }

    public DriverClassBrowsePropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public void setJarList(String[] jarList) {
        this.mJarList = jarList;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        DriverClassDialogCellEditor editor = new DriverClassDialogCellEditor(parent);
        return editor;
    }

    public void setDriverInstance(DriverInstance instance) {
        this.mJarList = instance.getJarListAsArray();
    }

    private class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public String getText(Object obj) {
            String name = (String)obj;
            if (name != null) {
                return name;
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private ArrayList mList = null;

        public ListContentProvider(ArrayList list) {
            this.mList = list;
        }

        public Object[] getElements(Object inputElement) {
            return this.mList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DriverClassDialogCellEditor
    extends DialogCellEditor {
        public DriverClassDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            ArrayList classes = new ArrayList();
            for (int i = 0; i < DriverClassBrowsePropertyDescriptor.this.mJarList.length; ++i) {
                String filepath = DriverClassBrowsePropertyDescriptor.this.mJarList[i];
                File file = new File(filepath);
                try {
                    new JarFile(file);
                }
                catch (ZipException e) {
                    continue;
                }
                catch (IOException e) {
                    String msg = e.getLocalizedMessage();
                    if (e.getLocalizedMessage() == null || e.getLocalizedMessage().trim().length() == 0) {
                        msg = ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.msg");
                    }
                    ExceptionHandler.showException(cellEditorWindow.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), msg, e);
                    return null;
                }
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(cellEditorWindow.getShell());
                try {
                    pmd.run(true, false, new IRunnableWithProgress(this, file, classes){
                        private final /* synthetic */ File val$file;
                        private final /* synthetic */ ArrayList val$classes;
                        private final /* synthetic */ DriverClassDialogCellEditor this$1;
                        {
                            this.this$1 = this$1;
                            this.val$file = val$file;
                            this.val$classes = val$classes;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                String[] classStr = DriverUtil.getDriverClassesFromJar((File)this.val$file, (IProgressMonitor)monitor);
                                this.val$classes.addAll(Arrays.asList(classStr));
                            }
                            catch (Exception e1) {
                                InvocationTargetException ce = new InvocationTargetException(e1);
                                throw ce;
                            }
                        }
                    });
                    continue;
                }
                catch (InvocationTargetException e) {
                    String msg = e.getLocalizedMessage();
                    if (e.getLocalizedMessage() == null || e.getLocalizedMessage().trim().length() == 0) {
                        msg = ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.msg");
                    }
                    ExceptionHandler.showException(cellEditorWindow.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), msg, e);
                    return null;
                }
                catch (InterruptedException e) {
                    String msg = e.getLocalizedMessage();
                    if (e.getLocalizedMessage() == null || e.getLocalizedMessage().trim().length() == 0) {
                        msg = ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.msg");
                    }
                    ExceptionHandler.showException(cellEditorWindow.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), msg, e);
                    return null;
                }
            }
            if (classes.size() > 0) {
                Object[] results;
                ListDialog listDialog = new ListDialog(cellEditorWindow.getShell());
                listDialog.setTitle(ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.jardialog.title"));
                listDialog.setMessage(ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.jardialog.msg"));
                listDialog.setHelpAvailable(false);
                listDialog.setContentProvider((IStructuredContentProvider)new ListContentProvider(classes));
                listDialog.setLabelProvider((ILabelProvider)new ListLabelProvider());
                listDialog.setInput(classes);
                listDialog.setInitialSelections(new Object[]{this.getValue()});
                int returnCode = listDialog.open();
                if (returnCode == 0 && (results = listDialog.getResult()).length > 0 && results[0] instanceof String) {
                    return results[0];
                }
            } else {
                String title = ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.noclasses.title");
                String message = ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.noclasses.msg");
                MessageDialog.openInformation((Shell)cellEditorWindow.getShell(), (String)title, (String)message);
            }
            return null;
        }
    }
}

