/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.List;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaVariable;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class FieldResolver
extends TemplateVariableResolver {
    private final String fDefaultType;
    private String fType;

    public FieldResolver() {
        this("java.lang.Object");
    }

    FieldResolver(String defaultType) {
        this.fDefaultType = defaultType;
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        List params = variable.getVariableType().getParams();
        this.fType = params.size() == 0 ? this.fDefaultType : (String)params.get(0);
        if (variable instanceof JavaVariable) {
            JavaContext jc = (JavaContext)context;
            JavaVariable jv = (JavaVariable)variable;
            jv.setParamType(this.fType);
            Object[] fields = jc.getFields(this.fType);
            if (fields.length <= 0) {
                super.resolve(variable, context);
                return;
            }
            jv.setChoices(fields);
            jc.markAsUsed(jv.getDefaultValue());
            if (fields.length > 1) {
                variable.setUnambiguous(false);
            } else {
                variable.setUnambiguous(this.isUnambiguous(context));
            }
        } else {
            super.resolve(variable, context);
        }
    }

    protected String[] resolveAll(TemplateContext context) {
        JavaContext jc = (JavaContext)context;
        CompilationUnitCompletion.Variable[] iterables = jc.getFields(this.fType);
        String[] names = new String[iterables.length];
        int i = 0;
        while (i < iterables.length) {
            names[i] = iterables[i].getName();
            ++i;
        }
        if (names.length > 0) {
            jc.markAsUsed(names[0]);
        }
        return names;
    }
}

