/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jst.jsf.common.ui.internal.utils.StyleCombo;
import org.eclipse.jst.pagedesigner.properties.celleditors.StyleComboCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.ui.internal.Logger;

public class LabeledStyleComboCellEditor
extends StyleComboCellEditor {
    private boolean _fSettingValue = false;
    private Object[] _values;

    public static LabeledStyleComboCellEditor newInstance(Composite parent, Map valueLabelMap, String defaultValue, int style) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Object key : valueLabelMap.keySet()) {
            String label = (String)valueLabelMap.get(key);
            list.add(new Object[]{key, label});
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String label1 = (String)((Object[])o1)[1];
                String label2 = (String)((Object[])o2)[1];
                return label1.compareTo(label2);
            }
        });
        Object[] values = new Object[list.size()];
        String[] labels = new String[list.size()];
        int i = 0;
        int n = list.size();
        while (i < n) {
            values[i] = ((Object[])list.get(i))[0];
            labels[i] = (String)((Object[])list.get(i))[1];
            ++i;
        }
        return new LabeledStyleComboCellEditor(parent, values, labels, defaultValue, style);
    }

    public LabeledStyleComboCellEditor(Composite parent, Object[] values, String[] labels, String defaultValue, int style) {
        super(parent, labels, style);
        StyleCombo combo = (StyleCombo)this.getControl();
        combo.setDefaultValue(defaultValue);
        this._values = values;
    }

    protected Object doGetValue() {
        Object index = super.doGetValue();
        int selection1 = -1;
        if (index instanceof Integer) {
            selection1 = (Integer)index;
        }
        if (selection1 >= 0) {
            return this._values[selection1];
        }
        if (this.getControl() instanceof StyleCombo) {
            return ((StyleCombo)this.getControl()).getText();
        }
        return null;
    }

    protected void doSetValue(Object value) {
        if (this._fSettingValue) {
            return;
        }
        this._fSettingValue = true;
        if (value instanceof Integer) {
            super.doSetValue(value);
        } else {
            String stringValue = value.toString();
            int selection1 = -1;
            int i = 0;
            while (i < this._values.length) {
                if (this._values[i].equals(stringValue)) {
                    selection1 = i;
                }
                ++i;
            }
            if (selection1 >= 0) {
                super.doSetValue(new Integer(selection1));
            } else {
                super.doSetValue(new Integer(-1));
                if (this.getControl() instanceof StyleCombo && !stringValue.equals(((StyleCombo)this.getControl()).getText())) {
                    ((StyleCombo)this.getControl()).setText(stringValue);
                }
            }
        }
        this._fSettingValue = false;
    }

    public void setItems(String[] newItems) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            Logger.log((int)4, (String)"Attempted to update item list for disposed cell editor");
            return;
        }
        Object previousSelectedValue = this.getValue();
        super.setItems(newItems);
        if (previousSelectedValue != null && this.getControl() instanceof StyleCombo) {
            int i = 0;
            while (i < newItems.length) {
                if (newItems[i].equals(previousSelectedValue)) {
                    this.setValue(previousSelectedValue);
                }
                ++i;
            }
        }
    }
}

