/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class RuntimeTreeContentProvider
extends AbstractTreeContentProvider {
    public void fillTree() {
        this.clean();
        ArrayList list = new ArrayList();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                IRuntimeType runtimeType = runtimes[i].getRuntimeType();
                try {
                    AbstractTreeContentProvider.TreeElement ele = this.getOrCreate(list, runtimeType.getVendor());
                    ele.contents.add(runtimes[i]);
                    this.elementToParentMap.put(runtimes[i], ele);
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Error in runtime content provider", e);
                }
                ++i;
            }
        }
        this.elements = list.toArray();
    }
}

