/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ResourceBundle;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.externalfile.ExternalSQLFileEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions.SetConnectionInfoAction;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.AbstractConnectionInfoComposite;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoComposite2;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.Messages;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SQLScrapbookEditor
extends SQLEditor {
    public static final String EDITOR_ID = "org.eclipse.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor";
    private IAction _setConnectionInfoAction;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setDocumentProvider(SqlscrapbookPlugin.getDefault().getSQLEditorDocumentProvider());
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        ISQLEditorInput newInput = null;
        if (input instanceof SQLScrapbookEditorInput) {
            newInput = (SQLScrapbookEditorInput)input;
        } else if (input instanceof IFileEditorInput) {
            newInput = new SQLScrapbookEditorInput(((IFileEditorInput)input).getFile());
        } else if (input instanceof IPathEditorInput) {
            IFileStore store = EFS.getLocalFileSystem().getStore(((IPathEditorInput)input).getPath());
            newInput = new ExternalSQLFileEditorInput(store);
        } else if (input instanceof ILocationProvider) {
            IFileStore store = EFS.getLocalFileSystem().getStore(((ILocationProvider)input).getPath((Object)input));
            newInput = new ExternalSQLFileEditorInput(store);
        } else if (input instanceof IAdaptable) {
            URI uri = (URI)input.getAdapter(URI.class);
            if (uri == null) {
                Class<?> clazz = input.getClass();
                try {
                    Method getURI = clazz.getMethod("getURI", null);
                    uri = (URI)getURI.invoke((Object)input, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (uri != null) {
                IFileStore store = EFS.getStore((URI)uri);
                newInput = new ExternalSQLFileEditorInput(store);
            }
        }
        if (newInput == null) {
            super.doSetInput(input);
        } else {
            if (input instanceof SQLScrapbookEditorInput) {
                newInput.setEditorSite(this.getEditorSite());
            }
            super.doSetInput((IEditorInput)newInput);
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = Messages.getBundleForConstructedKeys();
        this._setConnectionInfoAction = new SetConnectionInfoAction(bundle, "SetConnectionInfo.", (ITextEditor)this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.attachProfileAction", this._setConnectionInfoAction);
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "org.eclipse.datatools.sqltools.sqleditor.attachProfileAction");
    }

    public void requestConnection() {
        this._setConnectionInfoAction.run();
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        this.doSetConnectionInfo(connInfo);
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ((ToolbarSourceViewer)SQLScrapbookEditor.this.getSV()).connBar.init(SQLScrapbookEditor.this.getConnectionInfo().getDatabaseVendorDefinitionId().toString(), SQLScrapbookEditor.this.getConnectionInfo().getConnectionProfileName(), SQLScrapbookEditor.this.getConnectionInfo().getDatabaseName());
            }
        });
    }

    protected void doSetConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        super.setConnectionInfo(connInfo);
        if (this.getEditorInput() instanceof IFileEditorInput) {
            SQLFileUtil.setEncodedConnectionInfo(((IFileEditorInput)this.getEditorInput()).getFile(), connInfo.encode());
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SQLScrapbookEditor.this.setTitleToolTip(SQLScrapbookEditor.this.getTitleToolTip());
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getEditorInput() instanceof SQLEditorStorageEditorInput) {
            this.doSaveAs();
        } else {
            super.doSave(monitor);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected SQLEditor.AdaptedSourceViewer doCreateSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new ToolbarSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
    }

    public void refreshConnectionStatus() {
        super.refreshConnectionStatus();
        if (this.getSV() != null) {
            ((ToolbarSourceViewer)this.getSV()).refreshConnectionStatus();
        }
    }

    public class ToolbarSourceViewer
    extends SQLEditor.AdaptedSourceViewer
    implements Listener {
        private AbstractConnectionInfoComposite connBar;
        private boolean initialized;

        public ToolbarSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
            super((SQLEditor)SQLScrapbookEditor.this, parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
            this.initialized = false;
        }

        protected void createControl(Composite parent, int styles) {
            Composite fDefaultComposite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginBottom = 0;
            fDefaultComposite.setLayout((Layout)gridLayout);
            fDefaultComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.connBar = new ConnectionInfoComposite2(fDefaultComposite, Window.getDefaultOrientation(), this, SQLScrapbookEditor.this.getConnectionInfo(), null, 154);
            this.connBar.setLayoutData(new GridData(4, 0x1000000, true, false));
            ((GridLayout)this.connBar.getLayout()).marginWidth = 12;
            Composite textComposite = new Composite(fDefaultComposite, 0);
            textComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            textComposite.setLayout((Layout)new FillLayout());
            super.createControl(textComposite, styles);
        }

        public void handleEvent(Event event) {
            String content = this.getDocument().get();
            SQLScrapbookEditor.this.doSetConnectionInfo(this.connBar.getConnectionInfo());
            this.getDocument().set(content);
        }

        public void refreshConnectionStatus() {
            if (this.connBar != null) {
                if (!this.initialized) {
                    this.connBar.init();
                    this.initialized = true;
                }
                this.connBar.refreshConnectionStatus();
            }
        }
    }
}

