/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.saveFiles.SaveAsDialog;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class UntitledPHPEditor
extends PHPStructuredEditor {
    public static HashMap<IPath, IPath> latestSavedUntitled = new HashMap();

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.performSaveAs(iProgressMonitor);
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        TextFileDocumentProvider textFileDocumentProvider = (TextFileDocumentProvider)this.getDocumentProvider();
        IDocument iDocument = textFileDocumentProvider.getDocument((Object)iEditorInput);
        String string = this.loadPHPTemplate();
        iDocument.set(string);
        textFileDocumentProvider.saveDocument(null, (Object)iEditorInput, iDocument, true);
    }

    private String loadPHPTemplate() {
        String string = this.getPreferenceStore().getString("newFileTemplateName");
        if (string == null || string.length() == 0) {
            return "";
        }
        PHPTemplateStore pHPTemplateStore = (PHPTemplateStore)PHPUiPlugin.getDefault().getTemplateStore();
        Template template = pHPTemplateStore.findTemplate(string);
        if (template != null) {
            return template.getPattern();
        }
        return "";
    }

    public IFile getFile() {
        NonExistingPHPFileEditorInput nonExistingPHPFileEditorInput = (NonExistingPHPFileEditorInput)this.getEditorInput();
        return ExternalFilesRegistry.getInstance().getFileEntry(nonExistingPHPFileEditorInput.getPath().toString());
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        boolean bl;
        block21: {
            Shell shell = this.getSite().getShell();
            IEditorInput iEditorInput = this.getEditorInput();
            IDocumentProvider iDocumentProvider = this.getDocumentProvider();
            IPath iPath = null;
            SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
            IPath iPath2 = ((NonExistingPHPFileEditorInput)iEditorInput).getPath();
            String string = iPath2.lastSegment();
            saveAsDialog.setOriginalName(string);
            saveAsDialog.create();
            if (saveAsDialog.open() == 1) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                }
                return;
            }
            iPath = saveAsDialog.getResult();
            if (iPath == null) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IFile iFile = iWorkspace.getRoot().getFile(iPath);
            FileEditorInput fileEditorInput = new FileEditorInput(iFile);
            if (iDocumentProvider == null) {
                return;
            }
            bl = false;
            try {
                try {
                    iDocumentProvider.aboutToChange((Object)fileEditorInput);
                    iDocumentProvider.saveDocument(iProgressMonitor, (Object)fileEditorInput, iDocumentProvider.getDocument((Object)iEditorInput), true);
                    bl = true;
                }
                catch (CoreException coreException) {
                    Logger.logException(coreException);
                    IStatus iStatus = coreException.getStatus();
                    if (iStatus == null || iStatus.getSeverity() != 8) {
                        String string2 = PHPUIMessages.getString("UntitledPHPEditor_saveError");
                        String string3 = NLSUtility.format((String)PHPUIMessages.getString("UntitledPHPEditor_documentCannotBeSaved"), (Object)coreException.getMessage());
                        MessageDialog.openError((Shell)shell, (String)string2, (String)string3);
                    }
                    latestSavedUntitled.put(iPath2, iPath);
                    if (iPath != null) {
                        this.close(false);
                        try {
                            EditorUtility.openInEditor(iPath.toString(), 0);
                        }
                        catch (CoreException coreException2) {
                            Logger.logException(coreException2);
                        }
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                latestSavedUntitled.put(iPath2, iPath);
                if (iPath != null) {
                    this.close(false);
                    try {
                        EditorUtility.openInEditor(iPath.toString(), 0);
                    }
                    catch (CoreException coreException) {
                        Logger.logException(coreException);
                    }
                }
                throw throwable;
            }
            latestSavedUntitled.put(iPath2, iPath);
            if (iPath != null) {
                this.close(false);
                try {
                    EditorUtility.openInEditor(iPath.toString(), 0);
                }
                catch (CoreException coreException) {
                    Logger.logException(coreException);
                }
            }
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
    }
}

