/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.openType.OpenPhpTypeDialog;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class PHPCodeHyperLink
implements IHyperlink {
    private IRegion fRegion;
    private CodeData[] codeDatas;

    public PHPCodeHyperLink(IRegion iRegion, CodeData[] codeDataArray) {
        this.fRegion = iRegion;
        this.codeDatas = codeDataArray;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        CodeData codeData;
        OpenPhpTypeDialog openPhpTypeDialog;
        if (this.codeDatas == null) {
            return;
        }
        if (this.codeDatas.length > 1) {
            openPhpTypeDialog = new OpenPhpTypeDialog(Display.getDefault().getActiveShell());
            openPhpTypeDialog.getFilter().setSelectClasses(false);
            openPhpTypeDialog.getFilter().setSelectFunctions(false);
            openPhpTypeDialog.getFilter().setSelectConstants(false);
            if (this.codeDatas[0] instanceof PHPClassData) {
                openPhpTypeDialog.getFilter().setSelectClasses(true);
            } else if (this.codeDatas[0] instanceof PHPConstantData) {
                openPhpTypeDialog.getFilter().setSelectConstants(true);
            } else if (this.codeDatas[0] instanceof PHPFunctionData) {
                openPhpTypeDialog.getFilter().setSelectFunctions(true);
            } else {
                return;
            }
            openPhpTypeDialog.setInitialElements(this.codeDatas);
            openPhpTypeDialog.setInitFilterText(this.codeDatas[0].getName());
            if (openPhpTypeDialog.open() == 1) {
                return;
            }
            codeData = openPhpTypeDialog.getSelectedElement();
        } else {
            codeData = this.codeDatas[0];
        }
        openPhpTypeDialog = EditorUtility.isOpenInEditor(codeData);
        if (openPhpTypeDialog != null) {
            IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
            if (iWorkbenchPage != null) {
                iWorkbenchPage.bringToTop((IWorkbenchPart)openPhpTypeDialog);
            }
            EditorUtility.revealInEditor((IEditorPart)openPhpTypeDialog, (PHPCodeData)codeData);
        } else {
            try {
                openPhpTypeDialog = EditorUtility.openInEditor(codeData);
                EditorUtility.revealInEditor((IEditorPart)openPhpTypeDialog, (PHPCodeData)codeData);
            }
            catch (PartInitException partInitException) {
                Logger.logException(partInitException);
            }
        }
    }
}

