/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates.resolver;

import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateContext;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PhpTemplateFunctionContainerResolver
extends TemplateVariableResolver {
    public static final String NO_FUNCTION = "no_function_scope";

    public PhpTemplateFunctionContainerResolver() {
        super("function_container", "resolving a php function name");
    }

    protected String resolve(TemplateContext templateContext) {
        PhpTemplateContext phpTemplateContext = (PhpTemplateContext)templateContext;
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        if (iModelManager == null) {
            return null;
        }
        IStructuredModel iStructuredModel = iModelManager.getExistingModelForRead(phpTemplateContext.getDocument());
        if (iStructuredModel == null) {
            return null;
        }
        try {
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            PHPFileData pHPFileData = dOMModelForPHP.getFileData();
            if (pHPFileData == null) {
                return null;
            }
            PHPCodeContext pHPCodeContext = ModelSupport.createContext((PHPFileData)pHPFileData, (int)phpTemplateContext.getStart());
            String string = pHPCodeContext.getContainerFunctionName();
            if (string == null || string.equals("")) {
                return NO_FUNCTION;
            }
            String string2 = string;
            return string2;
        }
        finally {
            iStructuredModel.releaseFromRead();
        }
    }
}

