/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PHPPreferencePageBlocksRegistry;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.php.ui.preferences.IPHPPreferencePageBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public abstract class AbstractPHPPropertyPreferencePage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private static final Object DISABLE_LINK = "DISABLE_LINK";
    protected Map fData = null;
    protected Button fEnableProjectSettings;
    private Link fProjectSettingsLink;
    protected IPHPPreferencePageBlock[] projectScopeAddons;
    protected IPHPPreferencePageBlock[] workspaceAddons;

    public final void applyData(Object object) {
        super.applyData(object);
        if (object instanceof Map) {
            this.fData = (Map)object;
            this.updateLinkEnablement();
        }
    }

    protected Control createWorkspaceContents(Composite composite) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        composite2.setLayout((Layout)new GridLayout());
        try {
            this.workspaceAddons = PHPPreferencePageBlocksRegistry.getPHPPreferencePageBlock(this.getPreferencePageID());
            int n = 0;
            while (n < this.workspaceAddons.length) {
                this.workspaceAddons[n].setCompositeAddon(composite2);
                this.workspaceAddons[n].initializeValues((PreferencePage)this);
                ++n;
            }
            scrolledCompositeImpl.setContent((Control)composite2);
        }
        catch (Exception exception) {
            PHPUiPlugin.log(exception);
        }
        return scrolledCompositeImpl;
    }

    protected Control createProjectContents(Composite composite) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        composite2.setLayout((Layout)new GridLayout());
        try {
            this.projectScopeAddons = PHPPreferencePageBlocksRegistry.getPHPPreferencePageBlock(this.getPropertyPageID());
            int n = 0;
            while (n < this.projectScopeAddons.length) {
                this.projectScopeAddons[n].setCompositeAddon(composite2);
                this.projectScopeAddons[n].initializeValues((PreferencePage)this);
                ++n;
            }
            scrolledCompositeImpl.setContent((Control)composite2);
        }
        catch (Exception exception) {
            PHPUiPlugin.log(exception);
        }
        return scrolledCompositeImpl;
    }

    public final Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite3.setLayout((Layout)new GridLayout(2, false));
        if (this.getProject() != null) {
            this.fEnableProjectSettings = new Button(composite3, 32);
            this.fEnableProjectSettings.setText("Enable project specific settings");
            this.fEnableProjectSettings.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            boolean bl = this.createPreferenceScopes()[0].getNode(this.getPreferenceNodeQualifier()).getBoolean(this.getProjectSettingsKey(), false);
            this.fEnableProjectSettings.setSelection(bl);
        } else {
            Label label = new Label(composite3, 32);
            label.setLayoutData((Object)new GridData());
        }
        this.fProjectSettingsLink = new Link(composite3, 0);
        this.fProjectSettingsLink.setFont(composite2.getFont());
        this.fProjectSettingsLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        if (this.getProject() != null) {
            this.fProjectSettingsLink.setText("<a>Configure Workspace Settings...</a>");
        } else {
            this.fProjectSettingsLink.setText("<a>Configure Project Specific Settings...</a>");
        }
        this.updateLinkEnablement();
        this.fProjectSettingsLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AbstractPHPPropertyPreferencePage.this.getProject() == null) {
                    AbstractPHPPropertyPreferencePage.this.openProjectSettings();
                } else {
                    AbstractPHPPropertyPreferencePage.this.openWorkspaceSettings();
                }
            }
        });
        if (this.getProject() != null) {
            Label label = new Label(composite2, 258);
            label.setLayoutData((Object)new GridData(256));
        }
        final Control control = this.createProjectContents(composite2);
        control.setLayoutData((Object)new GridData(256));
        if (this.fEnableProjectSettings == null) {
            Control control2 = this.createWorkspaceContents(composite2);
            control2.setLayoutData((Object)new GridData(1808));
        } else {
            SelectionAdapter selectionAdapter = new SelectionAdapter(){
                ControlEnableState enablements = null;

                public void widgetSelected(SelectionEvent selectionEvent) {
                    super.widgetSelected(selectionEvent);
                    if (AbstractPHPPropertyPreferencePage.this.fEnableProjectSettings.getSelection()) {
                        if (this.enablements != null) {
                            this.enablements.restore();
                            this.enablements = null;
                        }
                    } else {
                        this.enablements = ControlEnableState.disable((Control)control);
                    }
                }
            };
            selectionAdapter.widgetSelected(null);
            this.fEnableProjectSettings.addSelectionListener((SelectionListener)selectionAdapter);
        }
        return composite2;
    }

    public void createControl(Composite composite) {
        if (this.getProject() != null) {
            this.noDefaultAndApplyButton();
        }
        super.createControl(composite);
    }

    protected IScopeContext[] createPreferenceScopes() {
        IProject iProject = this.getProject();
        if (iProject != null) {
            return new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    protected abstract String getPreferenceNodeQualifier();

    protected abstract String getPreferencePageID();

    protected IProject getProject() {
        if (this.getElement() != null && this.getElement() instanceof IProject) {
            return (IProject)this.getElement();
        }
        return null;
    }

    protected abstract String getProjectSettingsKey();

    protected abstract String getPropertyPageID();

    protected boolean isElementSettingsEnabled() {
        return this.fEnableProjectSettings != null && this.fEnableProjectSettings.getSelection();
    }

    void openProjectSettings() {
        Object[] objectArray;
        ListDialog listDialog = new ListDialog(this.getShell()){

            protected Control createDialogArea(Composite composite) {
                Control control = super.createDialogArea(composite);
                this.getTableViewer().setSorter((ViewerSorter)new ResourceSorter(1));
                return control;
            }
        };
        listDialog.setMessage("Select the project to configure:");
        listDialog.setContentProvider(new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return ((IWorkspace)object).getRoot().getProjects();
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        listDialog.setLabelProvider((ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PHPUiPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        listDialog.setInput((Object)ResourcesPlugin.getWorkspace());
        listDialog.setTitle("Project Specific Configuration");
        if (listDialog.open() == 0 && (objectArray = listDialog.getResult()).length > 0) {
            IProject iProject = (IProject)listDialog.getResult()[0];
            HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
            hashMap.put(DISABLE_LINK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)iProject, (String)this.getPropertyPageID(), (String[])new String[]{this.getPropertyPageID()}, hashMap).open();
        }
    }

    void openWorkspaceSettings() {
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        hashMap.put(DISABLE_LINK, Boolean.TRUE);
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)this.getPreferencePageID(), (String[])new String[]{this.getPreferencePageID()}, hashMap).open();
    }

    public boolean performOk() {
        int n;
        boolean bl = super.performOk();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes();
        if (this.getProject() != null) {
            if (this.isElementSettingsEnabled()) {
                iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier()).putBoolean(this.getProjectSettingsKey(), this.fEnableProjectSettings.getSelection());
            } else {
                iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier()).remove(this.getProjectSettingsKey());
            }
        }
        if (this.projectScopeAddons != null) {
            n = 0;
            while (n < this.projectScopeAddons.length) {
                this.projectScopeAddons[n].performOK(this.isElementSettingsEnabled());
                ++n;
            }
        }
        if (this.workspaceAddons != null) {
            n = 0;
            while (n < this.workspaceAddons.length) {
                this.workspaceAddons[n].performOK(false);
                ++n;
            }
        }
        return bl;
    }

    public void performDefaults() {
        int n = 0;
        while (n < this.projectScopeAddons.length) {
            this.projectScopeAddons[n].performDefaults();
            ++n;
        }
        n = 0;
        while (n < this.workspaceAddons.length) {
            this.workspaceAddons[n].performDefaults();
            ++n;
        }
        super.performDefaults();
    }

    public void performApply() {
        super.performApply();
    }

    private void updateLinkEnablement() {
        if (this.fData != null && this.fProjectSettingsLink != null) {
            this.fProjectSettingsLink.setEnabled(!Boolean.TRUE.equals(this.fData.get(DISABLE_LINK)));
        }
    }
}

