/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search.text;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.internal.ui.text.FileMatch;

public class ResultVisitor
extends TextSearchRequestor {
    private final List fResult = new LinkedList();
    private final boolean fIsFileSearchOnly;
    private final boolean fSearchInBinaries;
    private final List fCachedMatches = new ArrayList();

    public ResultVisitor(boolean bl, boolean bl2) {
        this.fIsFileSearchOnly = bl;
        this.fSearchInBinaries = bl2;
    }

    public ResultVisitor() {
        this(false, false);
    }

    public boolean acceptFile(IFile iFile) throws CoreException {
        if (this.fIsFileSearchOnly) {
            this.fResult.add(new FileMatch(iFile, 0, 0));
        }
        this.flushMatches();
        return true;
    }

    public boolean reportBinaryFile(IFile iFile) {
        return this.fSearchInBinaries;
    }

    public boolean acceptPatternMatch(TextSearchMatchAccess textSearchMatchAccess) throws CoreException {
        this.fCachedMatches.add(new FileMatch(textSearchMatchAccess.getFile(), textSearchMatchAccess.getMatchOffset(), textSearchMatchAccess.getMatchLength()));
        return true;
    }

    public void beginReporting() {
        this.fCachedMatches.clear();
    }

    public void endReporting() {
        this.flushMatches();
    }

    public List getResult() {
        return this.fResult;
    }

    public void clear() {
        this.fResult.clear();
    }

    private void flushMatches() {
        if (!this.fCachedMatches.isEmpty()) {
            this.fResult.addAll(this.fCachedMatches);
        }
    }
}

