/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PerspectiveManager {
    public static boolean fPrompting;

    public static void switchToPerspective(IWorkbenchWindow iWorkbenchWindow, String string) {
        try {
            iWorkbenchWindow.getWorkbench().showPerspective(string, iWorkbenchWindow);
        }
        catch (WorkbenchException workbenchException) {
            MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)PHPUIMessages.getString("PerspectiveManager_PerspectiveError_Title"), (String)PHPUIMessages.getString("PerspectiveManager_PerspectiveError_Message"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldSwitchPerspective(IWorkbenchWindow iWorkbenchWindow, String string) {
        MessageDialogWithToggle messageDialogWithToggle;
        String string2 = PerspectiveManager.getPerspectiveLabel(string);
        String string3 = NLS.bind((String)PHPUIMessages.getString("PerspectiveManager_Switch_Dialog_Message"), (Object)string2);
        String string4 = String.valueOf(string) + ".switch_to_perspective";
        if (PerspectiveManager.isCurrentPerspective(iWorkbenchWindow, string)) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        String string5 = PHPUiPlugin.getDefault().getPreferenceStore().getString(string4);
        if ("always".equals(string5)) {
            return true;
        }
        if ("never".equals(string5)) {
            return false;
        }
        Shell shell = iWorkbenchWindow.getShell();
        if (shell == null || fPrompting) {
            return false;
        }
        fPrompting = true;
        if (shell.getMinimized()) {
            shell.setMinimized(false);
        }
        boolean bl = (messageDialogWithToggle = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)PHPUIMessages.getString("PerspectiveManager_Switch_Dialog_Title"), (String)string3, null, (boolean)false, (IPreferenceStore)PHPUiPlugin.getDefault().getPreferenceStore(), (String)string4)).getReturnCode() == 2;
        Class<PerspectiveManager> clazz = PerspectiveManager.class;
        synchronized (PerspectiveManager.class) {
            fPrompting = false;
            PerspectiveManager.class.notifyAll();
            // ** MonitorExit[var9_9] (shouldn't be in output)
            if (PerspectiveManager.isCurrentPerspective(iWorkbenchWindow, string)) {
                bl = false;
            }
            return bl;
        }
    }

    public static boolean isCurrentPerspective(IWorkbenchWindow iWorkbenchWindow, String string) {
        IPerspectiveDescriptor iPerspectiveDescriptor;
        IWorkbenchPage iWorkbenchPage;
        boolean bl = false;
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iPerspectiveDescriptor = iWorkbenchPage.getPerspective()) != null) {
            bl = string.equals(iPerspectiveDescriptor.getId());
        }
        return bl;
    }

    public static String getPerspectiveLabel(String string) {
        IPerspectiveDescriptor iPerspectiveDescriptor = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(string);
        if (iPerspectiveDescriptor == null) {
            return null;
        }
        return iPerspectiveDescriptor.getLabel();
    }
}

