/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.RefactoringSessionReader;
import org.eclipse.ltk.internal.core.refactoring.RefactoringSessionTransformer;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptorProxy;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringContributionManager;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RefactoringHistoryManager {
    public static final char DELIMITER_COMPONENT = '\t';
    public static final char DELIMITER_ENTRY = '\n';
    private static final Calendar fgCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT+00:00"));
    private RefactoringSessionDescriptor fCachedDescriptor = null;
    private Document fCachedDocument = null;
    private IPath fCachedPath = null;
    private IFileStore fCachedStore = null;
    private final IFileStore fHistoryStore;
    private final String fProjectName;

    private static void checkArgument(Object argument, boolean whitespace) throws CoreException {
        if (argument instanceof String) {
            String string = (String)argument;
            char[] characters = string.toCharArray();
            if (characters.length == 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, RefactoringCoreMessages.RefactoringHistoryManager_empty_argument, null));
            }
            if (whitespace) {
                int index = 0;
                while (index < characters.length) {
                    if (Character.isWhitespace(characters[index])) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, RefactoringCoreMessages.RefactoringHistoryManager_whitespace_argument_key, null));
                    }
                    ++index;
                }
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10007, RefactoringCoreMessages.RefactoringHistoryManager_non_string_argument, null));
        }
    }

    public static void checkArgumentMap(Map arguments) throws CoreException {
        Assert.isNotNull((Object)arguments);
        Iterator iterator = arguments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RefactoringHistoryManager.checkArgument(entry.getKey(), true);
            RefactoringHistoryManager.checkArgument(entry.getValue(), false);
        }
    }

    private static CoreException createCoreException(Throwable exception) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10006, exception.getLocalizedMessage(), exception));
    }

    public static String escapeString(String string) {
        if (string.indexOf(9) < 0) {
            int length = string.length();
            StringBuffer buffer = new StringBuffer(length + 16);
            int index = 0;
            while (index < length) {
                char character = string.charAt(index);
                if ('\t' == character) {
                    buffer.append('\t');
                }
                buffer.append(character);
                ++index;
            }
            return buffer.toString();
        }
        return string;
    }

    public static Map getArgumentMap(RefactoringDescriptor descriptor) {
        Map arguments = null;
        RefactoringContribution contribution = RefactoringContributionManager.getInstance().getRefactoringContribution(descriptor.getID());
        if (contribution != null) {
            arguments = contribution.retrieveArgumentMap(descriptor);
        } else if (descriptor instanceof DefaultRefactoringDescriptor) {
            arguments = ((DefaultRefactoringDescriptor)descriptor).getArguments();
        }
        return arguments;
    }

    private static void readRefactoringDescriptorProxies(IFileStore store, String project, Collection collection, long start, long end, IProgressMonitor monitor, String task) throws CoreException {
        try {
            int index;
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 22);
            IFileInfo info = store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 2));
            if (!info.isDirectory() && info.exists() && store.getName().equalsIgnoreCase("refactorings.index")) {
                InputStream stream = null;
                try {
                    try {
                        stream = store.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                        RefactoringDescriptorProxy[] proxies = RefactoringHistoryManager.readRefactoringDescriptorProxies(stream, project, start, end);
                        index = 0;
                        while (index < proxies.length) {
                            collection.add(proxies[index]);
                            ++index;
                        }
                        monitor.worked(1);
                    }
                    catch (IOException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                }
                catch (Throwable throwable) {
                    monitor.worked(1);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.worked(1);
                    throw throwable;
                }
                monitor.worked(1);
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.worked(1);
            } else {
                monitor.worked(4);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IFileStore[] stores = store.childStores(0, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 2));
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 12);
            try {
                subMonitor.beginTask(task, stores.length);
                index = 0;
                while (index < stores.length) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(stores[index], project, collection, start, end, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1), task);
                    ++index;
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static RefactoringDescriptorProxy[] readRefactoringDescriptorProxies(InputStream stream, String project, long start, long end) throws IOException {
        ArrayList<DefaultRefactoringDescriptorProxy> list = new ArrayList<DefaultRefactoringDescriptorProxy>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
        while (reader.ready()) {
            int index;
            String line = reader.readLine();
            if (line == null || (index = line.indexOf(9)) <= 0) continue;
            try {
                long stamp = new Long(line.substring(0, index));
                if (stamp < start || stamp > end) continue;
                list.add(new DefaultRefactoringDescriptorProxy(RefactoringHistoryManager.unescapeString(line.substring(index + 1)), project, stamp));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return list.toArray(new RefactoringDescriptorProxy[list.size()]);
    }

    public static RefactoringDescriptor[] readRefactoringDescriptors(InputStream stream) throws CoreException {
        ArrayList list = new ArrayList(64);
        RefactoringHistoryManager.readRefactoringDescriptors(stream, list, (IProgressMonitor)new NullProgressMonitor());
        return list.toArray(new RefactoringDescriptor[list.size()]);
    }

    private static void readRefactoringDescriptors(InputStream stream, Collection collection, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 1);
            RefactoringDescriptor[] results = new RefactoringSessionReader(true).readSession(new InputSource(new BufferedInputStream(stream))).getRefactorings();
            int index = 0;
            while (index < results.length) {
                collection.add(results[index]);
                ++index;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void removeIndexTree(IFileStore store, IProgressMonitor monitor, String task) throws CoreException {
        try {
            monitor.beginTask(task, 16);
            IFileInfo info = store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            if (info.isDirectory()) {
                if (info.getName().equalsIgnoreCase(".refactorings")) {
                    return;
                }
                IFileStore[] stores = store.childStores(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1, 2);
                try {
                    subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, stores.length);
                    int index = 0;
                    while (index < stores.length) {
                        IFileInfo current = stores[index].fetchInfo(0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1, 2));
                        if (current.isDirectory()) {
                            char[] characters = stores[index].getName().toCharArray();
                            int offset = 0;
                            while (offset < characters.length) {
                                if (Character.isDigit(characters[offset])) {
                                    return;
                                }
                                ++offset;
                            }
                        }
                        ++index;
                    }
                }
                finally {
                    subMonitor.done();
                    return;
                }
            }
            IFileStore parent = store.getParent();
            store.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            RefactoringHistoryManager.removeIndexTree(parent, (IProgressMonitor)new SubProgressMonitor(monitor, 12, 2), task);
            return;
        }
        finally {
            monitor.done();
        }
    }

    public static void sortRefactoringDescriptorsAscending(RefactoringDescriptor[] descriptors) {
        Arrays.sort(descriptors, new Comparator(){

            public final int compare(Object first, Object second) {
                RefactoringDescriptor predecessor = (RefactoringDescriptor)first;
                RefactoringDescriptor successor = (RefactoringDescriptor)second;
                long delta = predecessor.getTimeStamp() - successor.getTimeStamp();
                if (delta > 0L) {
                    return 1;
                }
                if (delta < 0L) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static void sortRefactoringDescriptorsAscending(RefactoringDescriptorProxy[] proxies) {
        Arrays.sort(proxies, new Comparator(){

            public final int compare(Object first, Object second) {
                RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                long delta = predecessor.getTimeStamp() - successor.getTimeStamp();
                if (delta > 0L) {
                    return 1;
                }
                if (delta < 0L) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static void sortRefactoringDescriptorsDescending(RefactoringDescriptorProxy[] proxies) {
        Arrays.sort(proxies, new Comparator(){

            public final int compare(Object first, Object second) {
                RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                long delta = successor.getTimeStamp() - predecessor.getTimeStamp();
                if (delta > 0L) {
                    return 1;
                }
                if (delta < 0L) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static IPath stampToPath(long stamp) {
        fgCalendar.setTimeInMillis(stamp);
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(fgCalendar.get(1));
        buffer.append('/');
        buffer.append(fgCalendar.get(2) + 1);
        buffer.append('/');
        buffer.append(fgCalendar.get(3));
        return new Path(buffer.toString());
    }

    private static Object transformDescriptor(RefactoringDescriptor descriptor, boolean projects) throws CoreException {
        RefactoringSessionTransformer transformer = new RefactoringSessionTransformer(projects);
        try {
            transformer.beginSession(null, "1.0");
            try {
                String id = descriptor.getID();
                transformer.beginRefactoring(id, descriptor.getTimeStamp(), descriptor.getProject(), descriptor.getDescription(), descriptor.getComment(), descriptor.getFlags());
                Map arguments = RefactoringHistoryManager.getArgumentMap(descriptor);
                if (arguments != null) {
                    RefactoringHistoryManager.checkArgumentMap(arguments);
                    Iterator iterator = arguments.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        transformer.createArgument((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            finally {
                transformer.endRefactoring();
            }
        }
        finally {
            transformer.endSession();
        }
        return transformer.getResult();
    }

    public static String unescapeString(String string) {
        if (string.indexOf(9) < 0) {
            int length = string.length();
            StringBuffer buffer = new StringBuffer(length);
            int index = 0;
            while (index < length) {
                char escape;
                char character = string.charAt(index);
                if ('\t' != character || index >= length - 1 || '\t' != (escape = string.charAt(index + 1))) {
                    buffer.append(character);
                }
                ++index;
            }
            return buffer.toString();
        }
        return string;
    }

    private static void writeIndexEntry(IFileStore file, RefactoringDescriptorProxy[] proxies, int flags, IProgressMonitor monitor, String task) throws CoreException, IOException {
        OutputStream output = null;
        try {
            monitor.beginTask(task, 2);
            file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            output = new BufferedOutputStream(file.openOutputStream(flags, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
            RefactoringHistoryManager.writeRefactoringDescriptorProxies(output, proxies);
        }
        catch (Throwable throwable) {
            monitor.done();
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        monitor.done();
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeRefactoringDescriptorProxies(OutputStream stream, RefactoringDescriptorProxy[] proxies) throws IOException {
        StringBuffer buffer = new StringBuffer(proxies.length * 64);
        RefactoringHistoryManager.sortRefactoringDescriptorsAscending(proxies);
        int index = 0;
        while (index < proxies.length) {
            buffer.append(proxies[index].getTimeStamp());
            buffer.append('\t');
            buffer.append(RefactoringHistoryManager.escapeString(proxies[index].getDescription()));
            buffer.append('\n');
            ++index;
        }
        stream.write(buffer.toString().getBytes("utf-8"));
    }

    public static void writeRefactoringSession(OutputStream stream, RefactoringSessionDescriptor descriptor, boolean stamps) throws CoreException {
        RefactoringSessionTransformer transformer = new RefactoringSessionTransformer(true);
        RefactoringDescriptor[] descriptors = descriptor.getRefactorings();
        try {
            transformer.beginSession(descriptor.getComment(), descriptor.getVersion());
            int index = 0;
            while (index < descriptors.length) {
                RefactoringDescriptor current = descriptors[index];
                if (current != null) {
                    try {
                        long stamp = stamps ? current.getTimeStamp() : -1L;
                        transformer.beginRefactoring(current.getID(), stamp, current.getProject(), current.getDescription(), current.getComment(), current.getFlags());
                        Map arguments = RefactoringHistoryManager.getArgumentMap(current);
                        if (arguments != null) {
                            RefactoringHistoryManager.checkArgumentMap(arguments);
                            Iterator iterator = arguments.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                transformer.createArgument((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                    }
                    finally {
                        transformer.endRefactoring();
                    }
                }
                ++index;
            }
        }
        finally {
            transformer.endSession();
        }
        Object result = transformer.getResult();
        if (result instanceof Node) {
            try {
                Transformer transform = TransformerFactory.newInstance().newTransformer();
                transform.setOutputProperty("indent", "yes");
                transform.setOutputProperty("method", "xml");
                transform.setOutputProperty("encoding", "utf-8");
                transform.transform(new DOMSource((Node)result), new StreamResult(stream));
            }
            catch (TransformerConfigurationException exception) {
                throw RefactoringHistoryManager.createCoreException(exception);
            }
            catch (TransformerFactoryConfigurationError exception) {
                throw RefactoringHistoryManager.createCoreException(exception);
            }
            catch (TransformerException exception) {
                Throwable throwable = exception.getException();
                if (throwable instanceof IOException) {
                    throw RefactoringHistoryManager.createCoreException(exception);
                }
                RefactoringCorePlugin.log(exception);
            }
        }
    }

    RefactoringHistoryManager(IFileStore store, String name) {
        Assert.isNotNull((Object)store);
        Assert.isTrue((name == null || !"".equals(name) ? 1 : 0) != 0);
        this.fHistoryStore = store;
        this.fProjectName = name;
    }

    void addRefactoringDescriptor(RefactoringDescriptor descriptor, boolean sort, IProgressMonitor monitor) throws CoreException {
        block28: {
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 18);
                long stamp = descriptor.getTimeStamp();
                if (stamp < 0L) break block28;
                IPath path = RefactoringHistoryManager.stampToPath(stamp);
                IFileStore folder = this.fHistoryStore.getChild(path);
                IFileStore history = folder.getChild("refactorings.history");
                IFileStore index = folder.getChild("refactorings.index");
                RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[]{new DefaultRefactoringDescriptorProxy(descriptor.getDescription(), descriptor.getProject(), descriptor.getTimeStamp())};
                if (history.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) {
                    InputStream input = null;
                    try {
                        try {
                            input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                            Document document = this.getCachedDocument(path, input);
                            try {
                                input.close();
                                input = null;
                            }
                            catch (IOException iOException) {}
                            monitor.worked(1);
                            Object result = RefactoringHistoryManager.transformDescriptor(descriptor, false);
                            if (result instanceof Document) {
                                boolean found = false;
                                NodeList list = ((Document)result).getElementsByTagName("refactoring");
                                Element root = document.getDocumentElement();
                                if (sort) {
                                    String string = Long.toString(stamp);
                                    int offset = 0;
                                    while (offset < list.getLength()) {
                                        Element element = (Element)list.item(offset);
                                        String attribute = element.getAttribute("stamp");
                                        if (attribute != null && string.compareTo(attribute) > 0) {
                                            root.insertBefore(document.importNode(element, true), element);
                                            found = true;
                                            break;
                                        }
                                        ++offset;
                                    }
                                }
                                if (!found) {
                                    root.appendChild(document.importNode(list.item(0), true));
                                }
                                this.writeHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                                if (sort) {
                                    HashSet set = new HashSet(64);
                                    RefactoringHistoryManager.readRefactoringDescriptorProxies(index, null, set, 0L, Long.MAX_VALUE, (IProgressMonitor)new SubProgressMonitor(monitor, 2), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                                    RefactoringHistoryManager.writeIndexEntry(index, set.toArray(new RefactoringDescriptorProxy[set.size()]), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 3, 2), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                                } else {
                                    RefactoringHistoryManager.writeIndexEntry(index, proxies, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 5, 2), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                                }
                            }
                        }
                        catch (ParserConfigurationException exception) {
                            throw RefactoringHistoryManager.createCoreException(exception);
                        }
                        catch (IOException exception) {
                            throw RefactoringHistoryManager.createCoreException(exception);
                        }
                        catch (SAXException exception) {
                            throw RefactoringHistoryManager.createCoreException(exception);
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block28;
                }
                try {
                    Object result = RefactoringHistoryManager.transformDescriptor(descriptor, false);
                    if (result instanceof Node) {
                        this.writeHistoryEntry(history, (Node)result, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                        RefactoringHistoryManager.writeIndexEntry(index, proxies, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                    }
                }
                catch (IOException exception) {
                    throw RefactoringHistoryManager.createCoreException(exception);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private Document getCachedDocument(IPath path, InputStream input) throws SAXException, IOException, ParserConfigurationException {
        Document document;
        if (path.equals((Object)this.fCachedPath) && this.fCachedDocument != null) {
            return this.fCachedDocument;
        }
        this.fCachedDocument = document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(input));
        this.fCachedPath = path;
        return document;
    }

    private RefactoringSessionDescriptor getCachedSession(IFileStore store, InputStream input) throws CoreException {
        RefactoringSessionDescriptor descriptor;
        if (store.equals(this.fCachedStore) && this.fCachedDescriptor != null) {
            return this.fCachedDescriptor;
        }
        this.fCachedDescriptor = descriptor = new RefactoringSessionReader(true).readSession(new InputSource(input));
        this.fCachedStore = store;
        return descriptor;
    }

    RefactoringHistory readRefactoringHistory(long start, long end, IProgressMonitor monitor) {
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 200);
            HashSet set = new HashSet();
            try {
                IFileStore store;
                if (this.fHistoryStore.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(this.fHistoryStore, this.fProjectName, set, start, end, (IProgressMonitor)new SubProgressMonitor(monitor, 80), RefactoringCoreMessages.RefactoringHistoryService_retrieving_history);
                }
                if ((store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(".refactorings").getChild(".workspace")).fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(store, null, set, start, end, (IProgressMonitor)new SubProgressMonitor(monitor, 80), RefactoringCoreMessages.RefactoringHistoryService_retrieving_history);
                }
            }
            catch (CoreException exception) {
                RefactoringCorePlugin.log(exception);
            }
            RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[set.size()];
            set.toArray(proxies);
            RefactoringHistoryImplementation refactoringHistoryImplementation = new RefactoringHistoryImplementation(proxies);
            return refactoringHistoryImplementation;
        }
        finally {
            monitor.done();
        }
    }

    private void removeRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IPath path, IProgressMonitor monitor, String task) throws CoreException {
        block23: {
            try {
                Node node;
                monitor.beginTask(task, 5);
                IFileStore folder = this.fHistoryStore.getChild(path);
                IFileStore index = folder.getChild("refactorings.index");
                if (!index.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) break block23;
                HashSet resultingProxies = new HashSet(64);
                RefactoringHistoryManager.readRefactoringDescriptorProxies(index, null, resultingProxies, 0L, Long.MAX_VALUE, (IProgressMonitor)new SubProgressMonitor(monitor, 1), task);
                if (resultingProxies.size() == proxies.length) {
                    RefactoringHistoryManager.removeIndexTree(folder, (IProgressMonitor)new SubProgressMonitor(monitor, 1), task);
                    break block23;
                }
                IFileStore history = folder.getChild("refactorings.history");
                if (!history.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) break block23;
                InputStream input = null;
                Document document = null;
                try {
                    try {
                        input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                        document = this.getCachedDocument(path, input);
                    }
                    catch (ParserConfigurationException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                    catch (IOException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                    catch (SAXException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                HashSet<Node> removedNodes = new HashSet<Node>(proxies.length);
                NodeList list = document.getElementsByTagName("refactoring");
                int length = list.getLength();
                int offset = 0;
                while (offset < length) {
                    String value;
                    Node item;
                    node = list.item(offset);
                    NamedNodeMap attributes = node.getAttributes();
                    if (attributes != null && (item = attributes.getNamedItem("stamp")) != null && (value = item.getNodeValue()) != null) {
                        int current = 0;
                        while (current < proxies.length) {
                            RefactoringDescriptorProxy proxy = proxies[current];
                            long stamp = proxy.getTimeStamp();
                            if (value.equals(String.valueOf(stamp))) {
                                resultingProxies.remove(new DefaultRefactoringDescriptorProxy(proxy.getDescription(), proxy.getProject(), stamp));
                                removedNodes.add(node);
                            }
                            ++current;
                        }
                    }
                    ++offset;
                }
                Iterator iterator = removedNodes.iterator();
                while (iterator.hasNext()) {
                    node = (Node)iterator.next();
                    node.getParentNode().removeChild(node);
                }
                try {
                    RefactoringHistoryManager.writeIndexEntry(index, resultingProxies.toArray(new RefactoringDescriptorProxy[resultingProxies.size()]), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2), task);
                    this.writeHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2), task);
                }
                catch (IOException exception) {
                    throw RefactoringHistoryManager.createCoreException(exception);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    void removeRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IProgressMonitor monitor, String task) throws CoreException {
        try {
            HashMap<IPath, ArrayList<RefactoringDescriptorProxy>> paths = new HashMap<IPath, ArrayList<RefactoringDescriptorProxy>>();
            monitor.beginTask(task, proxies.length + 300);
            int index = 0;
            while (index < proxies.length) {
                IPath path = RefactoringHistoryManager.stampToPath(proxies[index].getTimeStamp());
                ArrayList<RefactoringDescriptorProxy> collection = (ArrayList<RefactoringDescriptorProxy>)paths.get(path);
                if (collection == null) {
                    collection = new ArrayList<RefactoringDescriptorProxy>(64);
                    paths.put(path, collection);
                }
                collection.add(proxies[index]);
                ++index;
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 300);
            try {
                Set entries = paths.entrySet();
                subMonitor.beginTask(task, entries.size());
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Collection collection = (Collection)entry.getValue();
                    this.removeRefactoringDescriptors(collection.toArray(new RefactoringDescriptorProxy[collection.size()]), (IPath)entry.getKey(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1), task);
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Exception decompiling
     */
    RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setComment(RefactoringDescriptorProxy proxy, String comment, IProgressMonitor monitor) throws CoreException {
        block19: {
            try {
                IPath path;
                IFileStore folder;
                IFileStore history;
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 100);
                long stamp = proxy.getTimeStamp();
                if (stamp < 0L || !(history = (folder = this.fHistoryStore.getChild(path = RefactoringHistoryManager.stampToPath(stamp))).getChild("refactorings.history")).fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) break block19;
                InputStream input = null;
                try {
                    try {
                        input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 40, 2)));
                        Document document = this.getCachedDocument(path, input);
                        try {
                            input.close();
                            input = null;
                        }
                        catch (IOException iOException) {}
                        String time = String.valueOf(stamp);
                        NodeList list = document.getElementsByTagName("refactoring");
                        int index = 0;
                        while (index < list.getLength()) {
                            Element element = (Element)list.item(index);
                            if (time.equals(element.getAttribute("stamp"))) {
                                element.setAttribute("comment", comment);
                                break;
                            }
                            ++index;
                        }
                        this.writeHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 40, 2), RefactoringCoreMessages.RefactoringHistoryService_updating_history);
                    }
                    catch (ParserConfigurationException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                    catch (IOException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                    catch (SAXException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void writeHistoryEntry(IFileStore file, Node node, IProgressMonitor monitor, String task) throws CoreException {
        block23: {
            OutputStream output = null;
            try {
                monitor.beginTask(task, 2);
                try {
                    try {
                        file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                        output = new BufferedOutputStream(file.openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("method", "xml");
                        transformer.setOutputProperty("encoding", "utf-8");
                        try {
                            transformer.transform(new DOMSource(node), new StreamResult(output));
                        }
                        finally {
                            this.fCachedDocument = null;
                            this.fCachedPath = null;
                            this.fCachedDescriptor = null;
                            this.fCachedStore = null;
                        }
                    }
                    catch (TransformerConfigurationException exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                    catch (TransformerFactoryConfigurationError exception) {
                        throw RefactoringHistoryManager.createCoreException(exception);
                    }
                    catch (TransformerException exception) {
                        Throwable throwable = exception.getException();
                        if (throwable instanceof IOException) {
                            throw RefactoringHistoryManager.createCoreException(exception);
                        }
                        RefactoringCorePlugin.log(exception);
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

