/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.GenTable;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenScope {
    private final Map<Table, GenTable> genTables = new HashMap<Table, GenTable>();
    private IProgressMonitor progressMonitor;

    GenScope(Collection<Table> tables, EntityGenerator.Config entityConfig, IProgressMonitor progressMonitor) {
        this.initialize(tables, entityConfig, progressMonitor);
    }

    private void checkCanceled() {
        if (this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void initialize(Collection<Table> tables, EntityGenerator.Config entityConfig, IProgressMonitor monitor) {
        this.progressMonitor = monitor;
        this.buildGenTables(tables, entityConfig);
        this.checkCanceled();
        this.configureManyToManyRelations();
        this.checkCanceled();
        this.configureManyToOneRelations();
        this.checkCanceled();
        this.configureFieldNames();
        this.checkCanceled();
    }

    private void buildGenTables(Collection<Table> tables, EntityGenerator.Config entityConfig) {
        int size = tables.size();
        HashSet<String> entityNames = new HashSet<String>(size);
        for (Table table : tables) {
            this.buildGenTable(table, entityConfig, entityNames);
            this.progressMonitor.worked(40 / size);
        }
    }

    private void buildGenTable(Table table, EntityGenerator.Config entityConfig, Collection<String> entityNames) {
        this.genTables.put(table, new GenTable(this, table, entityConfig, entityNames));
    }

    private void configureManyToManyRelations() {
        int tablesSize = CollectionTools.size(this.tables());
        Iterator<GenTable> stream = this.tables();
        while (stream.hasNext()) {
            this.checkCanceled();
            stream.next().configureManyToManyRelations();
            this.progressMonitor.worked(730 / tablesSize);
        }
        Set<GenTable> referencedTables = this.buildReferencedTables();
        tablesSize = CollectionTools.size(this.joinTables());
        Iterator<GenTable> stream2 = this.joinTables();
        while (stream2.hasNext()) {
            GenTable joinGenTable = stream2.next();
            if (referencedTables.contains(joinGenTable)) {
                joinGenTable.clearJoinTableRelation();
            }
            this.progressMonitor.worked(40 / tablesSize);
        }
    }

    private void configureManyToOneRelations() {
        int tablesSize = CollectionTools.size(this.entityTables());
        Iterator<GenTable> stream = this.entityTables();
        while (stream.hasNext()) {
            stream.next().configureManyToOneRelations();
            this.progressMonitor.worked(50 / tablesSize);
        }
    }

    private void configureFieldNames() {
        int tablesSize = CollectionTools.size(this.entityTables());
        Iterator<GenTable> stream = this.entityTables();
        while (stream.hasNext()) {
            stream.next().configureFieldNames();
            this.progressMonitor.worked(50 / tablesSize);
        }
    }

    Iterator<GenTable> entityTables() {
        return new FilteringIterator<GenTable>(this.tables()){

            protected boolean accept(Object next) {
                return !((GenTable)next).isJoinTable();
            }
        };
    }

    int numEntityTables() {
        return CollectionTools.size(this.entityTables());
    }

    GenTable genTable(Table table) {
        return this.genTables.get(table);
    }

    private Iterator<GenTable> tables() {
        return this.genTables.values().iterator();
    }

    private Iterator<GenTable> joinTables() {
        return new FilteringIterator<GenTable>(this.tables()){

            protected boolean accept(Object next) {
                return ((GenTable)next).isJoinTable();
            }
        };
    }

    private Set<GenTable> buildReferencedTables() {
        int size = CollectionTools.size(this.tables());
        HashSet<GenTable> referencedTables = new HashSet<GenTable>(this.genTables.size());
        Iterator<GenTable> stream = this.tables();
        while (stream.hasNext()) {
            stream.next().addReferencedTablesTo(referencedTables);
            this.progressMonitor.worked(20 / size);
        }
        return referencedTables;
    }
}

