/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AddExceptionDialog;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class AddExceptionAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        AddExceptionDialog dialog = new AddExceptionDialog();
        if (dialog.open() == 0) {
            boolean caught = dialog.shouldHandleCaughtExceptions();
            boolean uncaught = dialog.shouldHandleUncaughtExceptions();
            Object[] results = dialog.getResult();
            if (results != null && results.length > 0) {
                try {
                    this.createBreakpoint(caught, uncaught, ((TypeNameMatch)results[0]).getType());
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.statusDialog(e.getStatus());
                }
            }
        }
    }

    private void createBreakpoint(final boolean caught, final boolean uncaught, final IType type) throws CoreException {
        final IResource resource = BreakpointUtils.getBreakpointResource((IMember)type);
        final HashMap map = new HashMap(10);
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)type);
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        boolean exists = false;
        int j = 0;
        while (j < breakpoints.length) {
            IJavaBreakpoint breakpoint = (IJavaBreakpoint)breakpoints[j];
            if (breakpoint instanceof IJavaExceptionBreakpoint && breakpoint.getTypeName().equals(type.getFullyQualifiedName())) {
                exists = true;
                break;
            }
            ++j;
        }
        if (!exists) {
            new Job(BreakpointMessages.AddExceptionAction_0){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        JDIDebugModel.createExceptionBreakpoint((IResource)resource, (String)type.getFullyQualifiedName(), (boolean)caught, (boolean)uncaught, (boolean)AddExceptionAction.isChecked(type), (boolean)true, (Map)map);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            }.schedule();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isChecked(IType type) {
        if (type == null) return true;
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType curr = type;
            while (true) {
                if (curr == null) {
                    return true;
                }
                String name = curr.getFullyQualifiedName('.');
                if ("java.lang.RuntimeException".equals(name)) return false;
                if ("java.lang.Error".equals(name)) {
                    return false;
                }
                curr = hierarchy.getSuperclass(curr);
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        return true;
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

