/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.actions;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.SkeletonActionProvider;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.Priority;

public class CommonActionProviderDescriptor
implements INavigatorContentExtPtConstants {
    private static final String DEFAULT_ID = "org.eclipse.ui.navigator.actionProvider";
    private static int count = 0;
    private final IConfigurationElement configurationElement;
    private final boolean isNested;
    private Set dependentDescriptors;
    private Set overridingDescriptors;
    private IConfigurationElement enablementElement;
    private Expression enablement;
    private boolean hasLoadingFailed;
    private String definedId;
    private String visibilityId;
    private String dependsOnId;
    private String overridesId;
    private String toString;
    private Priority priority;

    public CommonActionProviderDescriptor(IConfigurationElement aConfigElement) {
        Assert.isTrue((boolean)"actionProvider".equals(aConfigElement.getName()));
        this.configurationElement = aConfigElement;
        this.isNested = false;
        this.init();
    }

    public CommonActionProviderDescriptor(IConfigurationElement aConfigElement, IConfigurationElement anEnablementExpression, Priority defaultPriority, String anOverrideId, boolean nestedUnderNavigatorContent) {
        Assert.isTrue((boolean)"actionProvider".equals(aConfigElement.getName()));
        Assert.isTrue(("possibleChildren".equals(anEnablementExpression.getName()) || "enablement".equals(anEnablementExpression.getName()) ? 1 : 0) != 0);
        this.configurationElement = aConfigElement;
        this.enablementElement = anEnablementExpression;
        this.visibilityId = anOverrideId;
        this.isNested = nestedUnderNavigatorContent;
        this.priority = defaultPriority;
        this.init();
    }

    private void init() {
        try {
            IConfigurationElement[] children;
            this.definedId = this.configurationElement.getAttribute("id");
            if (this.definedId == null) {
                this.definedId = "org.eclipse.ui.navigator.actionProvider." + count++;
            }
            if (this.visibilityId == null) {
                this.visibilityId = this.definedId;
            }
            this.dependsOnId = this.configurationElement.getAttribute("dependsOn");
            this.overridesId = this.configurationElement.getAttribute("overrides");
            if (this.priority == null) {
                String prio = this.configurationElement.getAttribute("priority");
                this.priority = prio != null ? Priority.get(prio) : Priority.NORMAL;
            }
            if ((children = this.configurationElement.getChildren("enablement")).length == 0 && this.enablementElement != null) {
                this.enablement = new CustomAndExpression(this.enablementElement);
            } else if (children.length == 1) {
                this.enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), children[0]);
            } else {
                System.err.println("Incorrect number of expressions: enablement in navigator extension: " + this.configurationElement.getDeclaringExtension().getUniqueIdentifier() + " in plugin " + this.configurationElement.getDeclaringExtension().getNamespaceIdentifier());
            }
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
        }
    }

    public CommonActionProvider createActionProvider() {
        if (this.hasLoadingFailed) {
            return SkeletonActionProvider.INSTANCE;
        }
        CommonActionProvider provider = null;
        try {
            provider = (CommonActionProvider)this.configurationElement.createExecutableExtension("class");
        }
        catch (CoreException exception) {
            NavigatorPlugin.log(exception.getStatus());
            this.hasLoadingFailed = true;
            provider = SkeletonActionProvider.INSTANCE;
        }
        catch (Exception e) {
            NavigatorPlugin.log((IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e));
            this.hasLoadingFailed = true;
            provider = SkeletonActionProvider.INSTANCE;
        }
        return provider;
    }

    public boolean isEnabledFor(IStructuredSelection aStructuredSelection) {
        block8: {
            if (this.enablement == null) {
                return false;
            }
            if (aStructuredSelection.isEmpty()) {
                EvaluationContext context = null;
                context = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
                context.setAllowPluginActivation(true);
                try {
                    if (this.enablement.evaluate((IEvaluationContext)context) != EvaluationResult.TRUE) {
                        return false;
                    }
                    break block8;
                }
                catch (CoreException e) {
                    NavigatorPlugin.log(4, 0, e.getMessage(), e);
                    return false;
                }
            }
            EvaluationContext context = null;
            Iterator elements = aStructuredSelection.iterator();
            while (elements.hasNext()) {
                context = new EvaluationContext(null, elements.next());
                context.setAllowPluginActivation(true);
                try {
                    if (this.enablement.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE) continue;
                    return false;
                }
                catch (CoreException e) {
                    NavigatorPlugin.log(4, 0, e.getMessage(), e);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isEnabledFor(Object anElement) {
        if (this.enablement == null || anElement == null) {
            return false;
        }
        try {
            EvaluationContext context = new EvaluationContext(null, anElement);
            context.setAllowPluginActivation(true);
            return this.enablement.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
            return false;
        }
    }

    public String getId() {
        return this.visibilityId;
    }

    public String getDefinedId() {
        return this.definedId;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public String getDependsOnId() {
        return this.dependsOnId;
    }

    public String getOverridesId() {
        return this.overridesId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.definedId == null ? 0 : this.definedId.hashCode());
        result = 31 * result + (this.visibilityId == null ? 0 : this.visibilityId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommonActionProviderDescriptor other = (CommonActionProviderDescriptor)obj;
        if (this.definedId == null ? other.definedId != null : !this.definedId.equals(other.definedId)) {
            return false;
        }
        return !(this.visibilityId == null ? other.visibilityId != null : !this.visibilityId.equals(other.visibilityId));
    }

    protected void addDependentDescriptor(CommonActionProviderDescriptor dependentDescriptor) {
        Assert.isTrue((this != dependentDescriptor ? 1 : 0) != 0);
        if (this.dependentDescriptors == null) {
            this.dependentDescriptors = new LinkedHashSet();
        }
        this.dependentDescriptors.add(dependentDescriptor);
    }

    protected void addOverridingDescriptor(CommonActionProviderDescriptor overridingDescriptor) {
        Assert.isTrue((this != overridingDescriptor ? 1 : 0) != 0);
        if (this.overridingDescriptors == null) {
            this.overridingDescriptors = new TreeSet(CommonActionProviderDescriptorCompator.INSTANCE);
        }
        this.overridingDescriptors.add(overridingDescriptor);
    }

    protected boolean hasDependentDescriptors() {
        return this.dependentDescriptors != null && !this.dependentDescriptors.isEmpty();
    }

    protected boolean hasOverridingDescriptors() {
        return this.overridingDescriptors != null && !this.overridingDescriptors.isEmpty();
    }

    protected Iterator dependentDescriptors() {
        return this.dependentDescriptors.iterator();
    }

    protected Iterator overridingDescriptors() {
        return this.overridingDescriptors.iterator();
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "CommonActionProviderDescriptor[definedId=" + this.getDefinedId() + ", visibilityId=" + this.getId() + ", dependsOn=" + this.getDependsOnId() + ", overrides=" + this.getOverridesId() + "]";
        }
        return this.toString;
    }

    public static class CommonActionProviderDescriptorCompator
    implements Comparator {
        public static final CommonActionProviderDescriptorCompator INSTANCE = new CommonActionProviderDescriptorCompator();
        private static final int LESS_THAN = -1;
        private static final int EQUALS = 0;

        public int compare(Object o1, Object o2) {
            CommonActionProviderDescriptor lvalue = null;
            CommonActionProviderDescriptor rvalue = null;
            if (o1 instanceof CommonActionProviderDescriptor) {
                lvalue = (CommonActionProviderDescriptor)o1;
            }
            if (o2 instanceof CommonActionProviderDescriptor) {
                rvalue = (CommonActionProviderDescriptor)o2;
            }
            if (lvalue == null || rvalue == null) {
                return -1;
            }
            if (lvalue.equals(rvalue)) {
                return 0;
            }
            int comparison = lvalue.getPriority().getValue() - rvalue.getPriority().getValue();
            if (comparison == 0) {
                return lvalue.getDefinedId().compareTo(rvalue.getDefinedId());
            }
            return comparison;
        }
    }
}

