/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.ecore.EcoreXMLSchemaBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreXMISchemaBuilder
extends EcoreXMLSchemaBuilder {
    protected static final String XMI_PREFIX = "xmi";
    protected static final String XMI_URI = "http://www.omg.org/XMI";
    protected static final String XMI_SCHEMA_LOCATION = "XMI.xsd";

    public Collection<EObject> generate(EPackage ePackage, EcoreXMLSchemaBuilder.QNameMap qNameMap, boolean minimized, List<EClass> rootList, Map<?, ?> options) {
        this.minimizedXMI = minimized;
        this.rootClasses = rootList;
        if (options != null) {
            this.useEncodedAttributeStyle = Boolean.TRUE.equals(options.get("USE_ENCODE_ATTRIBUTE_STYLE"));
            this.enforceLowerBound = Boolean.TRUE.equals(options.get("ENFORCE_LOWERBOUND"));
        }
        if (rootList != null && !rootList.isEmpty()) {
            for (EClass root : rootList) {
                if (root.getEPackage() == ePackage) continue;
                throw new IllegalArgumentException("Inappropriate root class " + root.getName());
            }
        }
        return this.generate(ePackage, qNameMap);
    }

    @Override
    public Collection<EObject> generate(EPackage ePackage, EcoreXMLSchemaBuilder.QNameMap qNameMap) {
        ArrayList<EObject> result = new ArrayList<EObject>(super.generate(ePackage, qNameMap));
        result.add(1, this.createXMISchema());
        return result;
    }

    protected XSDSchema createXMISchema() {
        XSDSchema xmiSchema = XSDFactory.eINSTANCE.createXSDSchema();
        xmiSchema.setTargetNamespace(XMI_URI);
        xmiSchema.setSchemaForSchemaQNamePrefix("xsd");
        Map<String, String> namespaces = xmiSchema.getQNamePrefixToNamespaceMap();
        namespaces.put(XMI_PREFIX, XMI_URI);
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        XSDAttributeDeclaration xmiIdAttribute = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        xmiIdAttribute.setName("id");
        xmiIdAttribute.setTypeDefinition(xmiSchema.getSchemaForSchema().resolveSimpleTypeDefinition("ID"));
        xmiSchema.getContents().add((Object)xmiIdAttribute);
        XSDAttributeGroupDefinition xmiIdentityAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
        xmiIdentityAttribs.setName("IdentityAttribs");
        EList<XSDAttributeGroupContent> contents = xmiIdentityAttribs.getContents();
        contents.add(this.createAttributeUse(xmiSchema, "label", "string", "optional", "qualified", null));
        contents.add(this.createAttributeUse(xmiSchema, "uuid", "string", "optional", "qualified", null));
        xmiSchema.getContents().add((Object)xmiIdentityAttribs);
        XSDAttributeGroupDefinition xmiLinkAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
        xmiLinkAttribs.setName("LinkAttribs");
        contents = xmiLinkAttribs.getContents();
        contents.add(this.createAttributeUse(xmiSchema, "href", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "idref", "IDREF", "optional", "qualified", null));
        xmiSchema.getContents().add((Object)xmiLinkAttribs);
        XSDAttributeGroupDefinition xmiObjectAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
        xmiObjectAttribs.setName("ObjectAttribs");
        contents = xmiObjectAttribs.getContents();
        contents.add(this.createAttributeGroupReference(xmiSchema, "IdentityAttribs"));
        contents.add(this.createAttributeGroupReference(xmiSchema, "LinkAttribs"));
        contents.add(this.createAttributeUse(xmiSchema, "version", "string", "optional", "qualified", "2.0"));
        contents.add(this.createAttributeUse(xmiSchema, "type", "QName", "optional", "qualified", null));
        xmiSchema.getContents().add((Object)xmiObjectAttribs);
        XSDComplexTypeDefinition xmiComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xmiComplexTypeDefinition.setName("XMI");
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setMinOccurs(0);
        particle.setMaxOccurs(-1);
        XSDModelGroup modelGroup = this.createAnyModelGroup("strict");
        particle.setContent(modelGroup);
        xmiComplexTypeDefinition.setContent(particle);
        contents = xmiComplexTypeDefinition.getAttributeContents();
        contents.add(this.createAttributeGroupReference(xmiSchema, "IdentityAttribs"));
        contents.add(this.createAttributeGroupReference(xmiSchema, "LinkAttribs"));
        contents.add(this.createAttributeUse(xmiSchema, "type", "QName", "optional", "qualified", null));
        contents.add(this.createAttributeUse(xmiSchema, "version", "string", "required", "qualified", "2.0"));
        xmiSchema.getContents().add((Object)xmiComplexTypeDefinition);
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "XMI", "XMI", false));
        XSDComplexTypeDefinition prComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        prComplexTypeDefinition.setName("PackageReference");
        particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setMinOccurs(0);
        particle.setMaxOccurs(-1);
        modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
        this.addElementDeclaration(xmiSchema, modelGroup, "name", "string");
        this.addElementDeclaration(xmiSchema, modelGroup, "version", "string");
        particle.setContent(modelGroup);
        prComplexTypeDefinition.setContent(particle);
        contents = prComplexTypeDefinition.getAttributeContents();
        contents.add(this.createAttributeGroupReference(xmiSchema, "ObjectAttribs"));
        contents.add(this.createAttributeUse(xmiSchema, "name", "string", "optional", null, null));
        xmiSchema.getContents().add((Object)prComplexTypeDefinition);
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "PackageReference", "PackageReference", false));
        xmiSchema.getContents().add((Object)this.createExtendedComplexTypeDefinition(xmiSchema, "Model", "PackageReference"));
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "Model", "Model", false));
        xmiSchema.getContents().add((Object)this.createExtendedComplexTypeDefinition(xmiSchema, "Import", "PackageReference"));
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "Import", "Import", false));
        xmiSchema.getContents().add((Object)this.createExtendedComplexTypeDefinition(xmiSchema, "MetaModel", "PackageReference"));
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "MetaModel", "MetaModel", false));
        XSDComplexTypeDefinition documentationComplexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        documentationComplexType.setName("Documentation");
        particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setMinOccurs(0);
        particle.setMaxOccurs(-1);
        modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
        this.addElementDeclaration(xmiSchema, modelGroup, "contact", "string");
        this.addElementDeclaration(xmiSchema, modelGroup, "exporter", "string");
        this.addElementDeclaration(xmiSchema, modelGroup, "exporterVersion", "string");
        this.addElementDeclaration(xmiSchema, modelGroup, "longDescription", "string");
        this.addElementDeclaration(xmiSchema, modelGroup, "shortDescription", "string");
        this.addElementDeclaration(xmiSchema, modelGroup, "notice", "string");
        this.addElementDeclaration(xmiSchema, modelGroup, "owner", "string");
        particle.setContent(modelGroup);
        documentationComplexType.setContent(particle);
        contents = documentationComplexType.getAttributeContents();
        contents.add(this.createAttributeGroupReference(xmiSchema, "ObjectAttribs"));
        contents.add(this.createAttributeUse(xmiSchema, "contact", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "exporter", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "exporterVersion", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "longDescription", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "shortDescription", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "notice", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "owner", "string", "optional", null, null));
        xmiSchema.getContents().add((Object)documentationComplexType);
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "Documentation", "Documentation", false));
        XSDComplexTypeDefinition extensionComplexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        extensionComplexType.setName("Extension");
        particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setMinOccurs(0);
        particle.setMaxOccurs(-1);
        modelGroup = this.createAnyModelGroup("lax");
        particle.setContent(modelGroup);
        extensionComplexType.setContent(particle);
        contents = extensionComplexType.getAttributeContents();
        contents.add(this.createAttributeGroupReference(xmiSchema, "ObjectAttribs"));
        contents.add(this.createAttributeUse(xmiSchema, "extender", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "extenderID", "string", "optional", null, null));
        xmiSchema.getContents().add((Object)extensionComplexType);
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "Extension", "Extension", false));
        XSDComplexTypeDefinition differenceComplexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        differenceComplexType.setName("Difference");
        particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setMinOccurs(0);
        particle.setMaxOccurs(-1);
        modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle particle2 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration target = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        target.setName("target");
        XSDComplexTypeDefinition anonymous = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle particle3 = XSDFactory.eINSTANCE.createXSDParticle();
        particle3.setMinOccurs(0);
        particle3.setMaxOccurs(-1);
        particle3.setContent(this.createAnyModelGroup("skip"));
        anonymous.setContent(particle3);
        anonymous.setAttributeWildcardContent(this.createAny("skip"));
        target.setAnonymousTypeDefinition(anonymous);
        particle2.setContent(target);
        modelGroup.getContents().add((Object)particle2);
        this.addElementDeclaration(xmiSchema, modelGroup, "difference", "Difference", false);
        this.addElementDeclaration(xmiSchema, modelGroup, "container", "Difference", false);
        particle.setContent(modelGroup);
        differenceComplexType.setContent(particle);
        contents = differenceComplexType.getAttributeContents();
        contents.add(this.createAttributeGroupReference(xmiSchema, "ObjectAttribs"));
        contents.add(this.createAttributeUse(xmiSchema, "target", "IDREFS", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "container", "IDREFS", "optional", null, null));
        xmiSchema.getContents().add((Object)differenceComplexType);
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "Difference", "Difference", false));
        XSDComplexTypeDefinition addComplexType = this.createExtendedComplexTypeDefinition(xmiSchema, "Add", "Difference");
        contents = addComplexType.getAttributeContents();
        contents.add(this.createAttributeUse(xmiSchema, "position", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "addition", "IDREFS", "optional", null, null));
        xmiSchema.getContents().add((Object)addComplexType);
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "Add", "Add", false));
        XSDComplexTypeDefinition replaceComplexType = this.createExtendedComplexTypeDefinition(xmiSchema, "Replace", "Difference");
        contents = replaceComplexType.getAttributeContents();
        contents.add(this.createAttributeUse(xmiSchema, "position", "string", "optional", null, null));
        contents.add(this.createAttributeUse(xmiSchema, "replacement", "IDREFS", "optional", null, null));
        xmiSchema.getContents().add((Object)replaceComplexType);
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "Replace", "Replace", false));
        XSDComplexTypeDefinition deleteComplexType = this.createExtendedComplexTypeDefinition(xmiSchema, "Delete", "Difference");
        xmiSchema.getContents().add((Object)deleteComplexType);
        xmiSchema.getContents().add((Object)this.createElementDeclaration(xmiSchema, "Delete", "Delete", false));
        XSDComplexTypeDefinition xmiAny = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xmiAny.setName("Any");
        particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setMinOccurs(0);
        particle.setMaxOccurs(-1);
        particle.setContent(this.createAnyModelGroup("skip"));
        xmiAny.setContent(particle);
        xmiAny.setAttributeWildcardContent(this.createAny("skip"));
        xmiSchema.getContents().add((Object)xmiAny);
        return xmiSchema;
    }

    protected XSDModelGroup createAnyModelGroup(String processContents) {
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent(this.createAny(processContents));
        modelGroup.getContents().add((Object)particle);
        return modelGroup;
    }

    protected XSDWildcard createAny(String processContents) {
        XSDWildcard any = XSDFactory.eINSTANCE.createXSDWildcard();
        if ("strict".equals(processContents)) {
            any.setProcessContents(XSDProcessContents.STRICT_LITERAL);
        } else if ("skip".equals(processContents)) {
            any.setProcessContents(XSDProcessContents.SKIP_LITERAL);
        } else if ("lax".equals(processContents)) {
            any.setProcessContents(XSDProcessContents.LAX_LITERAL);
        }
        return any;
    }

    protected XSDComplexTypeDefinition createExtendedComplexTypeDefinition(XSDSchema schema, String name, String extension) {
        XSDComplexTypeDefinition complexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        complexType.setName(name);
        complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        complexType.setBaseTypeDefinition(schema.resolveTypeDefinition(extension));
        return complexType;
    }

    protected XSDAttributeGroupDefinition createAttributeGroupReference(XSDSchema schema, String name) {
        XSDAttributeGroupDefinition reference = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
        reference.setResolvedAttributeGroupDefinition(schema.resolveAttributeGroupDefinition(name));
        return reference;
    }

    protected XSDElementDeclaration createElementDeclaration(XSDSchema schema, String name, String type, boolean schemaType) {
        XSDElementDeclaration elementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        elementDeclaration.setName(name);
        if (schemaType) {
            elementDeclaration.setTypeDefinition(schema.getSchemaForSchema().resolveSimpleTypeDefinition(type));
        } else {
            elementDeclaration.setTypeDefinition(schema.resolveSimpleTypeDefinition(type));
        }
        return elementDeclaration;
    }

    protected void addElementDeclaration(XSDSchema schema, XSDModelGroup modelGroup, String name, String type) {
        this.addElementDeclaration(schema, modelGroup, name, type, true);
    }

    protected void addElementDeclaration(XSDSchema schema, XSDModelGroup modelGroup, String name, String type, boolean schemaType) {
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent(this.createElementDeclaration(schema, name, type, schemaType));
        modelGroup.getContents().add((Object)particle);
    }

    protected void addElementDeclarationReference(XSDSchema schema, XSDModelGroup modelGroup, String reference) {
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration elementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        elementDeclaration.setResolvedElementDeclaration(schema.resolveElementDeclaration(reference));
        particle.setContent(elementDeclaration);
        modelGroup.getContents().add((Object)particle);
    }

    protected XSDAttributeUse createAttributeReference(XSDSchema schema, String name) {
        XSDAttributeDeclaration attributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        attributeDeclaration.setResolvedAttributeDeclaration(schema.resolveAttributeDeclaration(name));
        XSDAttributeUse attributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
        attributeUse.setContent(attributeDeclaration);
        return attributeUse;
    }

    protected XSDAttributeUse createAttributeUse(XSDSchema schema, String name, String type, String use, String form, String fixed) {
        XSDAttributeDeclaration attributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        attributeDeclaration.setName(name);
        attributeDeclaration.setTypeDefinition(schema.getSchemaForSchema().resolveSimpleTypeDefinition(type));
        if ("qualified".equals(form)) {
            attributeDeclaration.setForm(XSDForm.QUALIFIED_LITERAL);
        }
        XSDAttributeUse attributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
        attributeUse.setContent(attributeDeclaration);
        if ("optional".equals(use)) {
            attributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
        }
        if ("required".equals(use)) {
            attributeUse.setUse(XSDAttributeUseCategory.REQUIRED_LITERAL);
        }
        if (fixed != null) {
            attributeUse.setConstraint(XSDConstraint.FIXED_LITERAL);
            attributeUse.setLexicalValue("2.0");
        }
        return attributeUse;
    }

    @Override
    protected boolean makeClassElementDeclaration(EClass eClass) {
        return this.rootClasses == null || !this.rootClasses.isEmpty() && this.rootClasses.contains(eClass);
    }

    @Override
    protected XSDModelGroup createModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setMinOccurs(0);
        particle.setMaxOccurs(-1);
        particle.setContent(modelGroup);
        xsdComplexTypeDefinition.setContent(particle);
        return modelGroup;
    }

    @Override
    protected void setAttributeElementMultiplicity(EAttribute attribute, XSDParticle particle) {
    }

    @Override
    protected void additionalProcessing(EClass eClass, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (eClass.getESuperTypes().size() == 0) {
            this.addXMIExtension(this.getModelGroup(xsdComplexTypeDefinition));
            this.addXMIAttributes(xsdComplexTypeDefinition);
        }
    }

    protected void addXMIExtension(XSDModelGroup modelGroup) {
        if (!this.minimizedXMI) {
            this.importXMI();
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            xsdElementDeclaration.setResolvedElementDeclaration(xsdElementDeclaration.resolveElementDeclaration(XMI_URI, "Extension"));
            particle.setContent(xsdElementDeclaration);
            modelGroup.getContents().add((Object)particle);
        }
    }

    protected void addXMIAttributes(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (!this.minimizedXMI) {
            this.importXMI();
            XSDAttributeGroupDefinition objAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            objAttribs.setResolvedAttributeGroupDefinition(objAttribs.resolveAttributeGroupDefinition(XMI_URI, "ObjectAttribs"));
            xsdComplexTypeDefinition.getAttributeContents().add(0, (Object)objAttribs);
        } else if (!this.useEncodedAttributeStyle) {
            this.importXMI();
            XSDAttributeGroupDefinition linkAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            linkAttribs.setResolvedAttributeGroupDefinition(linkAttribs.resolveAttributeGroupDefinition(XMI_URI, "LinkAttribs"));
            xsdComplexTypeDefinition.getAttributeContents().add(0, (Object)linkAttribs);
        }
        if (!this.minimizedXMI) {
            this.importXMI();
            XSDAttributeDeclaration attrDecl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            attrDecl.setResolvedAttributeDeclaration(attrDecl.resolveAttributeDeclaration(XMI_URI, "id"));
            XSDAttributeUse attrUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            attrUse.setContent(attrDecl);
            xsdComplexTypeDefinition.getAttributeContents().add(0, (Object)attrUse);
        }
    }

    @Override
    protected void setDefaultValue(EAttribute attribute, XSDAttributeDeclaration attrDecl) {
    }

    @Override
    protected boolean makeReferenceElement(EReference reference) {
        return reference.isContainment() && !reference.isContainer() || !this.useEncodedAttributeStyle;
    }

    @Override
    protected void setReferenceElementType(EReference reference, XSDElementDeclaration xsdElementDeclaration) {
        if (reference.getEType() != null) {
            super.setReferenceElementType(reference, xsdElementDeclaration);
        } else {
            this.importXMI();
            xsdElementDeclaration.setTypeDefinition(xsdElementDeclaration.resolveSimpleTypeDefinition(XMI_URI, "Any"));
        }
    }

    @Override
    protected void setReferenceElementMultiplicity(EReference reference, XSDParticle particle) {
    }

    protected void importXMI() {
        Map<String, String> namespaces = this.xsdSchema.getQNamePrefixToNamespaceMap();
        if (namespaces.put(XMI_PREFIX, XMI_URI) == null) {
            XSDImport xmiImport = XSDFactory.eINSTANCE.createXSDImport();
            xmiImport.setNamespace(XMI_URI);
            xmiImport.setSchemaLocation(XMI_SCHEMA_LOCATION);
            this.xsdSchema.getContents().add(0, (Object)xmiImport);
        }
    }
}

