/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.ClosableWizardDialog;
import org.eclipse.php.internal.server.ui.ServerEditDialog;
import org.eclipse.php.internal.server.ui.ServerWizard;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected IFile selectedFile = null;
    protected Text fFile;
    protected Label fPublishToLabel;
    protected Text fPublishToRoot;
    protected Text fPublishTo;
    protected Label fURLLabel;
    protected Text fURL;
    protected Button projectButton;
    protected Button fileButton;
    protected Button publish;
    protected Button createNewServer;
    protected Button configureServers;
    protected Button breakOnFirstLine;
    protected Button autoGeneratedURL;
    protected String[] serverTypeIds;
    protected Combo fDebuggersCombo;
    protected Combo serverCombo;
    protected Server server;
    protected boolean serverCanPublish = false;
    protected String contextRoot;
    protected List<Server> servers;
    protected boolean init = true;
    private static final String READ_ONLY = "read-only";
    public static final String AUTO_GENERATED_URL = "auto_generated_url";
    protected WidgetListener fListener = new WidgetListener();
    private boolean saveWorkingCopy;
    private Composite innerPublishContextComposite;
    private Set<String> fDebuggerIds;

    public void createControl(Composite composite) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 512);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createServerControl(composite2);
        this.createFileComponent(composite2);
        this.createBreakControl(composite2);
        this.createURLControl(composite2);
        this.createExtensionControls(composite2);
        Dialog.applyDialogFont((Control)composite2);
        scrolledCompositeImpl.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(point.x, point.y);
        this.setControl((Control)scrolledCompositeImpl);
    }

    public void createExtensionControls(Composite composite) {
    }

    public void createURLControl(Composite composite) {
        Group group = new Group(composite, 0);
        String string = PHPServerUIMessages.getString("ServerTab.url");
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.autoGeneratedURL = new Button((Composite)group, 32);
        this.autoGeneratedURL.setText(PHPServerUIMessages.getString("ServerTab.autoGenerate"));
        this.autoGeneratedURL.setSelection(true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.autoGeneratedURL.setLayoutData((Object)gridData);
        this.autoGeneratedURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ServerLaunchConfigurationTab.this.autoGeneratedURL.getSelection()) {
                    ServerLaunchConfigurationTab.this.initializeURLControl();
                }
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fURLLabel = new Label((Composite)group, 0);
        this.fURLLabel.setText(PHPServerUIMessages.getString("ServerTab.urlLabel"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 1;
        this.fURLLabel.setLayoutData((Object)gridData);
        this.fURL = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fURL.setLayoutData((Object)gridData);
        this.fURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createServerSelectionControl(Composite composite) {
        Font font = composite.getFont();
        GridData gridData = new GridData(256);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText(PHPServerUIMessages.getString("ServerTab.server"));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        GridData gridData2 = new GridData(768);
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)gridData2);
        Composite composite3 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout(2, false);
        composite3.setLayout((Layout)gridLayout);
        composite3.setFont(font);
        Label label = new Label(composite3, 64);
        gridData = new GridData(1);
        gridData.widthHint = 100;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        label.setText("Server Debugger:");
        this.fDebuggersCombo = new Combo(composite3, 12);
        this.fDebuggersCombo.setFont(font);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.fDebuggersCombo.setLayoutData((Object)gridData);
        this.fDebuggersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite composite4 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout(4, false);
        composite4.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        composite4.setLayoutData((Object)gridData);
        composite4.setFont(font);
        label = new Label(composite4, 64);
        gridData = new GridData(1);
        gridData.widthHint = 100;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        label.setText("PHP Server:");
        this.serverCombo = new Combo(composite4, 2060);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.serverCombo.setLayoutData((Object)gridData);
        this.serverCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerLaunchConfigurationTab.this.handleServerSelection();
            }
        });
        this.createNewServer = this.createPushButton(composite4, PHPServerUIMessages.getString("ServerTab.new"), null);
        this.createNewServer.addSelectionListener((SelectionListener)this.fListener);
        this.configureServers = this.createPushButton(composite4, PHPServerUIMessages.getString("ServerTab.configure"), null);
        this.configureServers.addSelectionListener((SelectionListener)this.fListener);
        this.servers = new ArrayList<Server>();
        this.populateServerList(this.servers);
        if (!this.servers.isEmpty()) {
            int n = 0;
            while (n < this.servers.size()) {
                Server server = this.servers.get(n);
                this.serverCombo.add(server.getName());
                ++n;
            }
        }
        if (this.serverCombo.getItemCount() > 0) {
            this.serverCombo.select(0);
        }
        this.fillDebuggers();
        this.serverCombo.forceFocus();
    }

    protected void fillDebuggers() {
        String string2;
        this.fDebuggerIds = PHPDebuggersRegistry.getDebuggersIds();
        for (String string2 : this.fDebuggerIds) {
            this.fDebuggersCombo.add(PHPDebuggersRegistry.getDebuggerName((String)string2));
        }
        string2 = PHPDebuggersRegistry.getDebuggerName((String)PHPDebuggersRegistry.getDefaultDebuggerId());
        int n = this.fDebuggersCombo.indexOf(string2);
        if (n > -1) {
            this.fDebuggersCombo.select(n);
        } else if (this.fDebuggersCombo.getItemCount() > 0) {
            this.fDebuggersCombo.select(0);
        }
    }

    protected void populateServerList(List<Server> list) {
        Server[] serverArray = ServersManager.getServers();
        if (list == null) {
            list = new ArrayList<Server>();
        }
        if (serverArray != null) {
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                list.add(serverArray[n2]);
                ++n2;
            }
        }
    }

    public void createServerControl(Composite composite) {
        this.createServerSelectionControl(composite);
        GridData gridData = new GridData(256);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.handleServerSelection();
    }

    protected void createFileComponent(Composite composite) {
        Group group = new Group(composite, 0);
        String string = PHPServerUIMessages.getString("ServerTab.file_project");
        group.setText(string);
        GridLayout gridLayout = new GridLayout(3, false);
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.fFile = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fFile.setLayoutData((Object)gridData);
        this.fFile.addModifyListener((ModifyListener)this.fListener);
        this.fileButton = this.createPushButton((Composite)group, PHPServerUIMessages.getString("ServerTab.browse"), null);
        gridData = (GridData)this.fileButton.getLayoutData();
        gridData.horizontalSpan = 1;
        this.fileButton.addSelectionListener((SelectionListener)this.fListener);
        this.publish = this.createCheckButton((Composite)group, PHPServerUIMessages.getString("ServerTab.publish"));
        gridData = (GridData)this.publish.getLayoutData();
        gridData.horizontalSpan = 3;
        this.fPublishToLabel = new Label((Composite)group, 0);
        this.fPublishToLabel.setText(PHPServerUIMessages.getString("ServerTab.publishLabel"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalIndent = 20;
        this.fPublishToLabel.setLayoutData((Object)gridData);
        this.innerPublishContextComposite = new Composite((Composite)group, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 0;
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.innerPublishContextComposite.setLayout((Layout)gridLayout);
        this.innerPublishContextComposite.setLayoutData((Object)gridData);
        this.fPublishToRoot = new Text(this.innerPublishContextComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = false;
        this.fPublishToRoot.setLayoutData((Object)gridData);
        this.fPublishToRoot.setEnabled(false);
        this.fPublishTo = new Text(this.innerPublishContextComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fPublishTo.setLayoutData((Object)gridData);
        this.fPublishTo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                if (ServerLaunchConfigurationTab.this.autoGeneratedURL.getSelection()) {
                    ServerLaunchConfigurationTab.this.initializeURLControl();
                }
            }
        });
        this.publish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.handleServerSelection();
    }

    public String[] getRequiredNatures() {
        return null;
    }

    protected void handleServerButtonSelected() {
        final Server server = this.getServerFromWizard();
        if (server != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ServerLaunchConfigurationTab.this.servers.add(server);
                    ServerLaunchConfigurationTab.this.serverCombo.add(server.getName());
                    ServerLaunchConfigurationTab.this.serverCombo.select(ServerLaunchConfigurationTab.this.serverCombo.indexOf(server.getName()));
                    ServerLaunchConfigurationTab.this.handleServerSelection();
                }
            });
        }
    }

    protected void handleConfigureButtonSelected() {
        int n = this.serverCombo.getSelectionIndex();
        Server server = this.servers.get(n);
        String string = server.getName();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        ServerEditDialog serverEditDialog = new ServerEditDialog(shell, server);
        if (serverEditDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return;
        }
        ServersManager.save();
        String string2 = server.getName();
        if (!string2.equals(string)) {
            this.serverCombo.remove(n);
            this.serverCombo.add(string2, n);
            this.serverCombo.select(n);
        }
        this.saveWorkingCopy = true;
        this.handleServerSelection();
    }

    public String[] getFileExtensions() {
        return null;
    }

    private IResource getFileFromDialog(IProject iProject) {
        return LaunchUtilities.getFileFromDialog((IProject)iProject, (Shell)this.getShell(), (String[])this.getFileExtensions(), (String[])this.getRequiredNatures(), (boolean)false);
    }

    protected void handleFileButtonSelected() {
        IResource iResource = null;
        iResource = this.getFileFromDialog(null);
        if (iResource == null) {
            return;
        }
        String string = iResource.getFullPath().toString();
        this.fFile.setText(string);
        if (this.autoGeneratedURL.getSelection()) {
            this.fURL.setText(this.computeURL(this.fPublishTo.getText(), string));
        }
    }

    protected IProject getProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray == null || iProjectArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (iProject.getName().equals(string)) {
                return iProject;
            }
            ++n;
        }
        return null;
    }

    protected void handleServerSelection() {
        Server server;
        int n = this.serverCombo.getItemCount();
        int n2 = this.serverCombo.getSelectionIndex();
        if (!this.servers.isEmpty() && (server = this.servers.get(this.serverCombo.getSelectionIndex())) != null && server instanceof Server) {
            this.server = this.servers.get(this.serverCombo.getSelectionIndex());
            boolean bl = false;
            if (this.server != null) {
                bl = this.server.canPublish();
            }
            this.serverCanPublish = bl;
            if (this.publish != null) {
                this.publish.setSelection(bl);
                this.publish.setEnabled(bl);
            }
            if (this.fURL != null && this.autoGeneratedURL.getSelection()) {
                this.initializeURLControl();
            }
            this.updatePublishContextRoot();
        }
        if (this.server == null && n2 + 1 != n) {
            this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.noSelectedServerError"));
        } else {
            this.setErrorMessage(null);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.setErrorMessage(null);
        try {
            this.selectDefaultServer((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
            this.selectDefaultDebugger((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
        }
        catch (CoreException coreException) {
            Logger.logException((Throwable)coreException);
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.serverCombo.setEnabled(true);
        this.setErrorMessage(null);
        try {
            String string = iLaunchConfiguration.getAttribute("file_name", "");
            String string2 = iLaunchConfiguration.getAttribute("context_root", "");
            String string3 = iLaunchConfiguration.getAttribute("publish_to", "");
            boolean bl = iLaunchConfiguration.getAttribute("publish", false);
            String string4 = iLaunchConfiguration.getAttribute("base_url", "");
            boolean bl2 = iLaunchConfiguration.getAttribute(AUTO_GENERATED_URL, true);
            this.publish.setSelection(bl);
            this.initializeDebuggerControl(iLaunchConfiguration);
            this.initializeServerControl(iLaunchConfiguration);
            this.fFile.setText(string);
            this.updatePublishContextRoot();
            this.fPublishTo.setText(string3);
            if (bl2) {
                this.autoGeneratedURL.setSelection(true);
                String string5 = this.computeURL(string2, string);
                this.fURLLabel.setEnabled(false);
                this.fURL.setText(string5);
                this.fURL.setEnabled(false);
            } else {
                this.autoGeneratedURL.setSelection(false);
                this.fURLLabel.setEnabled(true);
                this.fURL.setText(string4);
                this.fURL.setEnabled(true);
            }
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(iLaunchConfiguration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
        }
        catch (CoreException coreException) {}
        this.initializeExtensionControls(iLaunchConfiguration);
        this.isValid(iLaunchConfiguration);
    }

    private void updatePublishContextRoot() {
        if (this.fPublishToRoot == null) {
            return;
        }
        if (this.server == null || this.server.getDocumentRoot() == null) {
            this.fPublishToRoot.setText("");
            return;
        }
        String string = this.server.getDocumentRoot().trim();
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        this.fPublishToRoot.setText(string);
        this.innerPublishContextComposite.layout();
    }

    protected void initializeExtensionControls(ILaunchConfiguration iLaunchConfiguration) {
    }

    protected String computeURL(String string, String string2) {
        if (this.server == null) {
            return "";
        }
        String string3 = this.server.getBaseURL();
        if (string3.equals("")) {
            string3 = "http://localhost";
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (!string.equals("")) {
            string = string.replaceAll("\\\\", "/");
            stringBuffer.append("/");
            stringBuffer.append(string);
        }
        if (!string2.equals("")) {
            stringBuffer.append(this.formatFileName(string2));
        }
        return stringBuffer.toString();
    }

    private String formatFileName(String string) {
        String string2 = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(string);
        if (iResource == null) {
            return "";
        }
        int n = iResource.getType();
        if (n == 1 || n == 2) {
            string2 = iResource.getProjectRelativePath().toString();
        } else if (iResource.getType() == 4) {
            string2 = "/";
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    protected void initializeURLControl() {
        if (this.fPublishTo == null || this.fFile == null) {
            return;
        }
        this.fURL.setText(this.computeURL(this.fPublishTo.getText(), this.fFile.getText()));
    }

    protected void initializeServerControl(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("name", "");
            if (string != null && !string.equals("")) {
                this.server = ServersManager.getServer((String)string);
                if (this.server == null) {
                    this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.invalidServerError"));
                    this.selectDefaultServer(iLaunchConfiguration);
                } else {
                    this.serverCombo.setText(this.server.getName());
                    this.publish.setEnabled(this.server.canPublish());
                }
            } else {
                this.selectDefaultServer(iLaunchConfiguration);
            }
            if (iLaunchConfiguration.getAttribute(READ_ONLY, false)) {
                this.serverCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    protected void initializeDebuggerControl(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, "");
            if (string != null && !string.equals("")) {
                this.fDebuggersCombo.setText(PHPDebuggersRegistry.getDebuggerName((String)string));
            } else {
                this.selectDefaultDebugger(iLaunchConfiguration);
            }
            if (iLaunchConfiguration.getAttribute(READ_ONLY, false)) {
                this.fDebuggersCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    private void selectDefaultServer(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (this.serverCombo != null && this.serverCombo.getItemCount() > 0) {
            Server server;
            int n;
            String string = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            IProject iProject = null;
            if (string != null) {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            }
            if ((n = this.serverCombo.indexOf((server = ServersManager.getDefaultServer(iProject)).getName())) > -1) {
                this.serverCombo.select(n);
            } else {
                this.serverCombo.select(0);
            }
            this.server = ServersManager.getServer((String)this.serverCombo.getText());
            this.publish.setEnabled(this.server.canPublish());
        }
    }

    private void selectDefaultDebugger(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (this.fDebuggersCombo != null && this.fDebuggersCombo.getItemCount() > 0) {
            String string;
            String string2;
            int n;
            String string3 = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            IProject iProject = null;
            if (string3 != null) {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string3);
            }
            if ((n = this.fDebuggersCombo.indexOf(string2 = PHPDebuggersRegistry.getDebuggerName((String)(string = PHPProjectPreferences.getDefaultDebuggerID(iProject))))) > -1) {
                this.fDebuggersCombo.select(n);
            } else {
                this.fDebuggersCombo.select(0);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
        if (this.server != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("name", this.server.getName());
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("name", null);
        }
        String string = this.fFile.getText();
        String string2 = this.fPublishTo.getText();
        String string3 = this.fURL.getText();
        boolean bl = this.publish.getSelection();
        this.contextRoot = this.autoGeneratedURL.getSelection() ? (bl ? string2.replaceAll("\\\\", "/") : ServerLaunchConfigurationTab.computeContextRoot(string3, string, this.server)) : ServerLaunchConfigurationTab.computeContextRoot(string3, string, this.server);
        iLaunchConfigurationWorkingCopy.setAttribute("file_name", string);
        iLaunchConfigurationWorkingCopy.setAttribute("context_root", this.contextRoot);
        iLaunchConfigurationWorkingCopy.setAttribute("publish_to", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("publish", bl);
        iLaunchConfigurationWorkingCopy.setAttribute("base_url", string3);
        iLaunchConfigurationWorkingCopy.setAttribute(AUTO_GENERATED_URL, this.autoGeneratedURL.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        boolean bl2 = this.autoGeneratedURL.getSelection();
        this.fURLLabel.setEnabled(!bl2);
        this.fURL.setEnabled(!bl2);
        boolean bl3 = this.publish.getSelection();
        this.fPublishToLabel.setEnabled(bl3);
        this.fPublishTo.setEnabled(bl3);
        this.applyExtension(iLaunchConfigurationWorkingCopy);
        if (this.saveWorkingCopy) {
            try {
                iLaunchConfigurationWorkingCopy.doSave();
            }
            catch (CoreException coreException) {}
            this.saveWorkingCopy = false;
        }
        this.applyLaunchDelegateConfiguration(iLaunchConfigurationWorkingCopy);
    }

    protected void applyLaunchDelegateConfiguration(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = null;
        try {
            string = iLaunchConfigurationWorkingCopy.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
            AbstractDebuggerConfiguration abstractDebuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)string);
            iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, abstractDebuggerConfiguration.getWebLaunchDelegateClass());
        }
        catch (Exception exception) {
            Logger.logException((Throwable)exception);
        }
    }

    protected void createBreakControl(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Breakpoint");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.breakOnFirstLine = this.createCheckButton((Composite)group, "Break at First Line");
        this.breakOnFirstLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerLaunchConfigurationTab.this.setDirty(true);
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        String string = this.getLaunchConfigurationDialog().getMode();
        boolean bl = "debug".equals(string);
        this.breakOnFirstLine.setEnabled(bl);
    }

    private static String computeContextRoot(String string, String string2, Server server) {
        if (server == null) {
            return "";
        }
        String string3 = server.getBaseURL();
        if (string.length() > string3.length() + 1) {
            string = string.substring(string3.length() + 1);
        } else if (string.length() == string3.length() || string.length() == string3.length() + 1) {
            return "";
        }
        if (string2.length() > 0) {
            int n = (string2 = string2.substring(1)).indexOf(47);
            string2 = n < 0 ? "" : string2.substring(n);
        }
        if (string.length() <= string2.length()) {
            return "";
        }
        string = string.substring(0, string.length() - string2.length());
        return string;
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        Object object;
        block6: {
            this.setMessage(null);
            this.setErrorMessage(null);
            try {
                String string = iLaunchConfiguration.getAttribute("name", "");
                if (string.equals("") || (object = ServersManager.getServer((String)string)) != null) break block6;
                this.deleteLaunchConfiguration(iLaunchConfiguration);
                ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                int n = 0;
                while (n < iLaunchConfigurationArray.length) {
                    iLaunchConfiguration = iLaunchConfigurationArray[n];
                    string = iLaunchConfiguration.getAttribute("name", "");
                    if (!string.equals("") && ServersManager.getServer((String)string) == null) {
                        this.deleteLaunchConfiguration(iLaunchConfiguration);
                    }
                    ++n;
                }
                return false;
            }
            catch (CoreException coreException) {}
        }
        object = iLaunchConfiguration.getAttribute("file_name", "");
        if (!FileUtils.fileExists((String)object)) {
            this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.file_project_doesNotExist"));
            return false;
        }
        return this.isValidExtension(iLaunchConfiguration);
    }

    private void deleteLaunchConfiguration(final ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ILaunchConfiguration iLaunchConfiguration2 = iLaunchConfiguration;
                try {
                    if (iLaunchConfiguration2 instanceof ILaunchConfigurationWorkingCopy) {
                        iLaunchConfiguration2 = ((ILaunchConfigurationWorkingCopy)iLaunchConfiguration2).getOriginal();
                    }
                    if (iLaunchConfiguration2 != null) {
                        iLaunchConfiguration2.delete();
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    protected boolean isValidExtension(ILaunchConfiguration iLaunchConfiguration) {
        return true;
    }

    public Image getImage() {
        return null;
    }

    public String getName() {
        return PHPServerUIMessages.getString("ServerTab.server");
    }

    public void addControlAccessibleListener(Control control, String string) {
        String[] stringArray = string.split("&");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stringBuffer.toString()));
    }

    private String getSelectedDebuggerId() {
        int n = this.fDebuggersCombo.getSelectionIndex();
        String string = "org.eclipse.php.debug.core.zendDebugger";
        if (n > -1 && this.fDebuggerIds.size() > n) {
            string = this.fDebuggerIds.toArray()[n].toString();
        }
        return string;
    }

    protected Server getServerFromWizard() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        Server server = null;
        ServerWizard serverWizard = new ServerWizard();
        ClosableWizardDialog closableWizardDialog = new ClosableWizardDialog(shell, (IWizard)serverWizard);
        if (closableWizardDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return null;
        }
        server = (Server)serverWizard.getRootFragment().getWizardModel().getObject("server");
        if (server != null) {
            ServersManager.addServer((Server)server);
            ServersManager.save();
        }
        return server;
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            if (ServerLaunchConfigurationTab.this.autoGeneratedURL.getSelection()) {
                ServerLaunchConfigurationTab.this.initializeURLControl();
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ServerLaunchConfigurationTab.this.setDirty(true);
            Object object = selectionEvent.getSource();
            if (object == ServerLaunchConfigurationTab.this.fileButton) {
                ServerLaunchConfigurationTab.this.handleFileButtonSelected();
            } else if (object == ServerLaunchConfigurationTab.this.createNewServer) {
                ServerLaunchConfigurationTab.this.handleServerButtonSelected();
            } else if (object == ServerLaunchConfigurationTab.this.configureServers) {
                ServerLaunchConfigurationTab.this.handleConfigureButtonSelected();
            }
        }
    }
}

