/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentImportDataModelProperties;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public abstract class J2EEArtifactImportDataModelProvider
extends AbstractDataModelProvider
implements IJ2EEComponentImportDataModelProperties,
IDataModelListener {
    private static final String USE_DEFAULT_PROJECT_NAME = "J2EEArtifactImportDataModelProvider.USE_DEFAULT_PROJECT_NAME";
    public static final String FACET_RUNTIME = "IJ2EEArtifactImportDataModelProperties.FACET_RUNTIME";
    private IDataModel componentCreationDM;
    private Throwable archiveOpenFailure = null;
    private boolean settingFileName = false;
    private boolean doingComponentUpdate;

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.FILE");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.SAVE_FILTER");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose");
        propertyNames.add(USE_DEFAULT_PROJECT_NAME);
        propertyNames.add("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
        propertyNames.add("IJ2EEComponentImportDataModelProperties.COMPONENT");
        propertyNames.add(FACET_RUNTIME);
        propertyNames.add("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
        return propertyNames;
    }

    public void init() {
        super.init();
        this.componentCreationDM = this.createJ2EEComponentCreationDataModel();
        this.componentCreationDM.setBooleanProperty("FacetProjectCreationDataModelProvider.FORCE_VERSION_COMPLIANCE", false);
        this.componentCreationDM.addListener((IDataModelListener)this);
        this.model.addNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION", this.componentCreationDM);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(USE_DEFAULT_PROJECT_NAME)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJ2EEComponentImportDataModelProperties.COMPONENT")) {
            String projectName = this.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
            IProject project = ProjectUtilities.getProject((String)projectName);
            return ComponentCore.createComponent((IProject)project);
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER")) {
            if (propertyValue != null) {
                if (!this.settingFileName) {
                    this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", null);
                }
                this.updateDefaultComponentName();
            }
            return true;
        }
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.FILE")) {
            ArchiveWrapper archiveWrapper;
            if (!(propertyValue == null || this.settingFileName || (archiveWrapper = this.getArchiveWrapper()) != null && archiveWrapper.getCommonArchive() == propertyValue)) {
                archiveWrapper = new ArchiveWrapper((Archive)propertyValue);
                this.setProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER", archiveWrapper);
            }
        } else if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.SAVE_FILTER") && this.getArchiveWrapper() != null && this.getArchiveWrapper().getCommonArchive() != null) {
            this.getArchiveWrapper().getCommonArchive().setSaveFilter(this.getSaveFilter());
        } else if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName)) {
            try {
                this.archiveOpenFailure = null;
                this.handleArchiveSetup((String)propertyValue);
            }
            catch (OpenFailureException oe) {
                this.archiveOpenFailure = oe;
            }
            catch (ArchiveOpenFailureException e) {
                this.archiveOpenFailure = e;
            }
        } else {
            if ("IJ2EEComponentImportDataModelProperties.COMPONENT".equals(propertyName)) {
                throw new RuntimeException(String.valueOf(propertyName) + " should not be set.");
            }
            if ("IJ2EEComponentImportDataModelProperties.PROJECT_NAME".equals(propertyName)) {
                ArrayList nestedModels = new ArrayList(this.model.getNestedModels());
                IDataModel nestedModel = null;
                int i = 0;
                while (i < nestedModels.size()) {
                    nestedModel = (IDataModel)nestedModels.get(i);
                    try {
                        nestedModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
                    }
                    catch (Exception e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                    ++i;
                }
            } else if (FACET_RUNTIME.equals(propertyName)) {
                throw new RuntimeException(String.valueOf(propertyName) + " should not be set.");
            }
        }
        return true;
    }

    private void updateDefaultComponentName() {
        ArchiveWrapper wrapper = this.getArchiveWrapper();
        if (wrapper != null && this.getBooleanProperty(USE_DEFAULT_PROJECT_NAME)) {
            try {
                this.doingComponentUpdate = true;
                IPath path = wrapper.getPath();
                String defaultProjectName = path.segment(path.segmentCount() - 1);
                if (defaultProjectName.indexOf(46) > 0) {
                    defaultProjectName = defaultProjectName.substring(0, defaultProjectName.lastIndexOf(46));
                }
                this.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", defaultProjectName);
            }
            finally {
                this.doingComponentUpdate = false;
            }
        }
    }

    private boolean handleArchiveSetup(String fileName) throws OpenFailureException, ArchiveOpenFailureException {
        try {
            this.settingFileName = true;
            ArchiveWrapper wrapper = this.getArchiveWrapper();
            if (wrapper != null) {
                wrapper.close();
                this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", null);
                this.setProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER", null);
            }
            String uri = this.getStringProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
            if (!this.archiveExistsOnFile()) {
                return false;
            }
            wrapper = this.openArchiveWrapper(uri);
            if (wrapper != null) {
                this.setProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER", wrapper);
                if (wrapper.getCommonArchive() != null) {
                    this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", wrapper.getCommonArchive());
                }
            }
            boolean bl = wrapper != null;
            return bl;
        }
        finally {
            this.settingFileName = false;
        }
    }

    protected ArchiveWrapper openArchiveWrapper(String uri) throws OpenFailureException, ArchiveOpenFailureException {
        ArchiveWrapper archiveWrapper;
        block8: {
            boolean isEE5;
            IArchive archive;
            block6: {
                ArchiveWrapper archiveWrapper2;
                block7: {
                    archive = null;
                    isEE5 = false;
                    try {
                        Path path = new Path(uri);
                        archive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)path);
                        archive.setPath((IPath)path);
                        JavaEEQuickPeek jqp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archive);
                        if (jqp.getJavaEEVersion() == -1 && jqp.getType() == -1) {
                            this.handleUnknownType(jqp);
                        }
                        if (jqp.getJavaEEVersion() != 50) break block6;
                        isEE5 = true;
                        archiveWrapper2 = new ArchiveWrapper(archive);
                        if (isEE5) break block7;
                    }
                    catch (Throwable throwable) {
                        if (!isEE5) {
                            JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
                        }
                        throw throwable;
                    }
                    JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
                }
                return archiveWrapper2;
            }
            Archive commonArchive = this.openArchive(uri);
            if (commonArchive != null) {
                commonArchive.setSaveFilter(this.getSaveFilter());
            }
            archiveWrapper = new ArchiveWrapper(commonArchive);
            if (isEE5) break block8;
            JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
        }
        return archiveWrapper;
    }

    protected void handleUnknownType(JavaEEQuickPeek jqp) {
    }

    protected abstract Archive openArchive(String var1) throws OpenFailureException;

    private boolean closeArchive() {
        if (this.getArchiveWrapper() != null) {
            this.getArchiveWrapper().close();
        }
        return true;
    }

    public IStatus validate(String propertyName) {
        if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName) && !this.isPropertySet("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER")) {
            String fileName = this.getStringProperty(propertyName);
            if (fileName == null || fileName.length() == 0) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"5", (Object[])new Object[]{ArchiveUtil.getModuleFileTypeName((int)this.getType())}));
            }
            if (this.archiveOpenFailure != null) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)this.archiveOpenFailure.getMessage()));
            }
            if (fileName != null && !this.archiveExistsOnFile()) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"6", (Object[])new Object[]{ArchiveUtil.getModuleFileTypeName((int)this.getType())}));
            }
        } else {
            if ("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION".equals(propertyName)) {
                return this.getDataModel().getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION").validate(true);
            }
            if (FACET_RUNTIME.equals(propertyName)) {
                return this.validateVersionSupportedByServer();
            }
        }
        return OK_STATUS;
    }

    protected int getJ2EEVersion() {
        return 0;
    }

    protected abstract IDataModel createJ2EEComponentCreationDataModel();

    protected abstract int getType();

    private boolean archiveExistsOnFile() {
        String jarName = (String)this.getProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        if (jarName != null && jarName.length() > 0) {
            File file = new File(jarName);
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    public void dispose() {
        if (this.getBooleanProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose")) {
            this.closeArchive();
        }
        super.dispose();
    }

    protected final void setArchiveFile(Archive archiveFile) {
        this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", archiveFile);
    }

    protected final ArchiveWrapper getArchiveWrapper() {
        return (ArchiveWrapper)this.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
    }

    protected final Archive getArchiveFile() {
        return (Archive)this.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
    }

    protected final ArchiveOptions getArchiveOptions() {
        ArchiveOptions opts = new ArchiveOptions();
        opts.setIsReadOnly(true);
        return opts;
    }

    private SaveFilter getSaveFilter() {
        return (SaveFilter)this.getProperty("IJ2EEArtifactImportDataModelProperties.SAVE_FILTER");
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        return super.getValidPropertyDescriptors(propertyName);
    }

    public void propertyChanged(DataModelEvent event) {
        if (!this.doingComponentUpdate && event.getDataModel() == this.componentCreationDM && event.getPropertyName().equals("IJ2EEComponentImportDataModelProperties.PROJECT_NAME") && this.getBooleanProperty(USE_DEFAULT_PROJECT_NAME)) {
            this.setBooleanProperty(USE_DEFAULT_PROJECT_NAME, false);
        }
        if (event.getDataModel() == this.componentCreationDM && event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            this.model.notifyPropertyChange(FACET_RUNTIME, 2);
        }
    }

    protected IStatus validateVersionSupportedByServer() {
        if (this.model.isPropertySet("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER") && this.model.isPropertySet("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            IDataModel projectModel = this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)projectModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            Collection projectFacets = (Collection)this.getProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION");
            IRuntime runtime = (IRuntime)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (runtime != null) {
                Iterator iterator = projectFacets.iterator();
                while (iterator.hasNext()) {
                    IDataModel facetDataModel = map.getFacetDataModel(((IProjectFacet)iterator.next()).getId());
                    IProjectFacetVersion facetVersion = (IProjectFacetVersion)facetDataModel.getProperty("IFacetDataModelPropeties.FACET_VERSION");
                    if (facetVersion.getProjectFacet().getId().equals("jst.java")) {
                        Set<IProjectFacet> set = Collections.singleton(facetVersion.getProjectFacet());
                        try {
                            Set correctSet = runtime.getDefaultFacets(set);
                            IProjectFacetVersion correctVersion = null;
                            Iterator correctVersions = correctSet.iterator();
                            while (correctVersions.hasNext() && correctVersion == null) {
                                IProjectFacetVersion version = (IProjectFacetVersion)correctVersions.next();
                                if (!version.getProjectFacet().getId().equals("jst.java")) continue;
                                correctVersion = version;
                            }
                            if (correctVersion != null && !facetVersion.equals(correctVersion)) {
                                facetDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", correctVersion);
                                facetVersion = correctVersion;
                            }
                        }
                        catch (CoreException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                    }
                    if (runtime.supports(facetVersion)) continue;
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.VERSION_NOT_SUPPORTED);
                }
            }
        }
        return OK_STATUS;
    }
}

