/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.internal.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.internal.databinding.internal.beans.ListenerSupport;

public class JavaBeanObservableList
extends ObservableList
implements IBeanObservable {
    private final Object object;
    private PropertyChangeListener collectionListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeanObservableList.this.updating) {
                JavaBeanObservableList.this.updateWrappedList(Arrays.asList(JavaBeanObservableList.this.getValues()));
            }
        }
    };
    private boolean updating = false;
    private PropertyDescriptor descriptor;
    private ListenerSupport collectionListenSupport;

    public JavaBeanObservableList(Realm realm, Object object, PropertyDescriptor descriptor, Class elementType) {
        super(realm, new ArrayList(), (Object)elementType);
        this.object = object;
        this.descriptor = descriptor;
        this.collectionListenSupport = new ListenerSupport(this.collectionListener, descriptor.getName());
        this.wrappedList.addAll(Arrays.asList(this.getValues()));
    }

    protected void firstListenerAdded() {
        this.collectionListenSupport.hookListener(this.object);
    }

    protected void lastListenerRemoved() {
        if (this.collectionListenSupport != null) {
            this.collectionListenSupport.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        this.lastListenerRemoved();
    }

    private Object primGetValues() {
        Exception ex = null;
        try {
            Method readMethod = this.descriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new BindingException("Could not read collection values", (Throwable)ex);
    }

    private Object[] getValues() {
        Collection list;
        Object[] values = null;
        Object result = this.primGetValues();
        values = this.descriptor.getPropertyType().isArray() ? (Object[])result : ((list = (Collection)result) != null ? list.toArray() : new Object[]{});
        return values;
    }

    public Object getObserved() {
        return this.object;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.descriptor;
    }

    private void setValues() {
        if (this.descriptor.getPropertyType().isArray()) {
            Class<?> componentType = this.descriptor.getPropertyType().getComponentType();
            Object[] newArray = (Object[])Array.newInstance(componentType, this.wrappedList.size());
            this.wrappedList.toArray(newArray);
            this.primSetValues(newArray);
        } else {
            this.primSetValues(new ArrayList(this.wrappedList));
        }
    }

    private void primSetValues(Object newValue) {
        Exception ex = null;
        try {
            Method writeMethod = this.descriptor.getWriteMethod();
            if (!writeMethod.isAccessible()) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(this.object, newValue);
            return;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        throw new BindingException("Could not write collection values", (Throwable)ex);
    }

    public Object set(int index, Object element) {
        this.getterCalled();
        this.updating = true;
        try {
            Object oldElement = this.wrappedList.set(index, element);
            this.setValues();
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, (Object)element), (ListDiffEntry)Diffs.createListDiffEntry((int)(index + 1), (boolean)false, (Object)oldElement)));
            Object object = oldElement;
            return object;
        }
        finally {
            this.updating = false;
        }
    }

    public Object remove(int index) {
        this.getterCalled();
        this.updating = true;
        try {
            Object oldElement = this.wrappedList.remove(index);
            this.setValues();
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, oldElement)));
            Object e = oldElement;
            return e;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean add(Object element) {
        this.updating = true;
        try {
            int index = this.wrappedList.size();
            boolean result = this.wrappedList.add(element);
            this.setValues();
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, (Object)element)));
            boolean bl = result;
            return bl;
        }
        finally {
            this.updating = false;
        }
    }

    public void add(int index, Object element) {
        this.updating = true;
        try {
            this.wrappedList.add(index, element);
            this.setValues();
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, (Object)element)));
        }
        finally {
            this.updating = false;
        }
    }

    public boolean addAll(Collection c) {
        if (c.isEmpty()) {
            return false;
        }
        this.updating = true;
        try {
            int index = this.wrappedList.size();
            boolean result = this.wrappedList.addAll(c);
            this.setValues();
            ListDiffEntry[] entries = new ListDiffEntry[c.size()];
            int i = 0;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                entries[i++] = Diffs.createListDiffEntry((int)index++, (boolean)true, o);
            }
            this.fireListChange(Diffs.createListDiff((ListDiffEntry[])entries));
            boolean bl = result;
            return bl;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean addAll(int index, Collection c) {
        if (c.isEmpty()) {
            return false;
        }
        this.updating = true;
        try {
            boolean result = this.wrappedList.addAll(index, c);
            this.setValues();
            ListDiffEntry[] entries = new ListDiffEntry[c.size()];
            int i = 0;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                entries[i++] = Diffs.createListDiffEntry((int)index++, (boolean)true, o);
            }
            this.fireListChange(Diffs.createListDiff((ListDiffEntry[])entries));
            boolean bl = result;
            return bl;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean remove(Object o) {
        this.getterCalled();
        int index = this.wrappedList.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.updating = true;
        try {
            Object oldElement = this.wrappedList.remove(index);
            this.setValues();
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, oldElement)));
            return true;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean removeAll(Collection c) {
        this.getterCalled();
        boolean changed = false;
        this.updating = true;
        try {
            ArrayList<ListDiffEntry> diffEntries = new ArrayList<ListDiffEntry>();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                int index = this.wrappedList.indexOf(o);
                if (index == -1) continue;
                changed = true;
                Object oldElement = this.wrappedList.remove(index);
                diffEntries.add(Diffs.createListDiffEntry((int)index, (boolean)false, oldElement));
            }
            this.setValues();
            this.fireListChange(Diffs.createListDiff((ListDiffEntry[])diffEntries.toArray(new ListDiffEntry[diffEntries.size()])));
            boolean bl = changed;
            return bl;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean retainAll(Collection c) {
        this.getterCalled();
        boolean changed = false;
        this.updating = true;
        try {
            ArrayList<ListDiffEntry> diffEntries = new ArrayList<ListDiffEntry>();
            int index = 0;
            Iterator it = this.wrappedList.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                boolean retain = c.contains(o);
                if (retain) {
                    ++index;
                    continue;
                }
                changed = true;
                it.remove();
                diffEntries.add(Diffs.createListDiffEntry((int)index, (boolean)false, o));
            }
            this.setValues();
            this.fireListChange(Diffs.createListDiff((ListDiffEntry[])diffEntries.toArray(new ListDiffEntry[diffEntries.size()])));
            boolean bl = changed;
            return bl;
        }
        finally {
            this.updating = false;
        }
    }

    public void clear() {
        this.updating = true;
        try {
            ArrayList<ListDiffEntry> diffEntries = new ArrayList<ListDiffEntry>();
            Iterator it = this.wrappedList.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                diffEntries.add(Diffs.createListDiffEntry((int)0, (boolean)false, o));
            }
            this.setValues();
            this.fireListChange(Diffs.createListDiff((ListDiffEntry[])diffEntries.toArray(new ListDiffEntry[diffEntries.size()])));
        }
        finally {
            this.updating = false;
        }
    }
}

