/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.internal.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.internal.beans.IdentityWrapper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ListenerSupport {
    private Set elementsListenedTo = new HashSet();
    private PropertyChangeListener listener;
    private String propertyName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ListenerSupport(final PropertyChangeListener listener, final String propertyName) {
        Assert.isNotNull((Object)listener);
        Assert.isNotNull((Object)propertyName);
        this.propertyName = propertyName;
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (propertyName.equals(evt.getPropertyName())) {
                    listener.propertyChange(evt);
                }
            }
        };
    }

    public void hookListener(Object target) {
        if (this.processListener("addPropertyChangeListener", "Could not attach listener to ", target)) {
            this.elementsListenedTo.add(new IdentityWrapper(target));
        }
    }

    public void setHookTargets(Object[] targets) {
        HashSet elementsToUnhook = new HashSet(this.elementsListenedTo);
        if (targets != null) {
            int i = 0;
            while (i < targets.length) {
                Object newValue = targets[i];
                IdentityWrapper identityWrapper = new IdentityWrapper(newValue);
                if (!elementsToUnhook.remove(identityWrapper)) {
                    this.hookListener(newValue);
                }
                ++i;
            }
        }
        Iterator it = elementsToUnhook.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            Class<?> clazz = o.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.core.internal.databinding.internal.beans.IdentityWrapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                o = new IdentityWrapper(o);
            }
            this.elementsListenedTo.remove(o);
            this.unhookListener(o);
        }
    }

    public void unhookListener(Object target) {
        Class<?> clazz = target.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.databinding.internal.beans.IdentityWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            target = ((IdentityWrapper)target).unwrap();
        }
        if (this.processListener("removePropertyChangeListener", "Cound not remove listener from ", target)) {
            this.elementsListenedTo.remove(new IdentityWrapper(target));
        }
    }

    public void dispose() {
        if (this.elementsListenedTo != null) {
            Object[] targets = this.elementsListenedTo.toArray();
            int i = 0;
            while (i < targets.length) {
                this.unhookListener(targets[i]);
                ++i;
            }
            this.elementsListenedTo = null;
            this.listener = null;
        }
    }

    public Object[] getHookedTargets() {
        Object[] targets = null;
        if (this.elementsListenedTo != null && this.elementsListenedTo.size() > 0) {
            Object[] identityList = this.elementsListenedTo.toArray();
            targets = new Object[identityList.length];
            int i = 0;
            while (i < identityList.length) {
                targets[i] = ((IdentityWrapper)identityList[i]).unwrap();
                ++i;
            }
        }
        return targets;
    }

    private boolean processListener(String methodName, String message, Object target) {
        AccessibleObject method = null;
        Object[] parameters = null;
        try {
            try {
                Class<?> clazz = target.getClass();
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.beans.PropertyChangeListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                method = clazz.getMethod(methodName, classArray);
                parameters = new Object[]{this.propertyName, this.listener};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Class<?> clazz = target.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("java.beans.PropertyChangeListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz4;
                method = clazz.getMethod(methodName, classArray);
                parameters = new Object[]{this.listener};
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException e) {
            this.log(2, String.valueOf(message) + target, e);
        }
        if (method != null) {
            if (!method.isAccessible()) {
                ((Method)method).setAccessible(true);
            }
            try {
                ((Method)method).invoke(target, parameters);
                return true;
            }
            catch (IllegalArgumentException e) {
                this.log(2, String.valueOf(message) + target, e);
            }
            catch (IllegalAccessException e) {
                this.log(2, String.valueOf(message) + target, e);
            }
            catch (InvocationTargetException e) {
                this.log(2, String.valueOf(message) + target, e);
            }
        }
        return false;
    }

    private void log(int severity, String message, Throwable throwable) {
        Policy.getLog().log((IStatus)new Status(severity, "org.eclipse.core.databinding", 0, message, throwable));
    }
}

