/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables.details;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.details.DetailMessages;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneManager;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DetailPaneProxy {
    private IDetailPane fCurrentPane;
    private Control fCurrentControl;
    private IDetailPaneContainer fParentContainer;

    public DetailPaneProxy(IDetailPaneContainer parent) {
        this.fParentContainer = parent;
    }

    public void display(IStructuredSelection selection) {
        if ((selection == null || selection.isEmpty()) && this.fCurrentPane != null) {
            this.fCurrentPane.display(selection);
            return;
        }
        String preferredPaneID = DetailPaneManager.getDefault().getPreferredPaneFromSelection(selection);
        if (this.fCurrentPane != null && preferredPaneID != null && preferredPaneID.equals(this.fCurrentPane.getID())) {
            this.fCurrentPane.display(selection);
            return;
        }
        this.setupPane(preferredPaneID, selection);
        this.fParentContainer.paneChanged(preferredPaneID);
    }

    public boolean setFocus() {
        if (this.fCurrentPane != null) {
            return this.fCurrentPane.setFocus();
        }
        return false;
    }

    public void dispose() {
        if (this.fCurrentPane != null) {
            this.fCurrentPane.dispose();
        }
        if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
            this.fCurrentControl.dispose();
        }
    }

    public Object getAdapter(Class required) {
        if (this.fCurrentPane != null && this.fCurrentPane instanceof IAdaptable) {
            return ((IAdaptable)this.fCurrentPane).getAdapter(required);
        }
        return null;
    }

    public Control getCurrentControl() {
        return this.fCurrentControl;
    }

    public String getCurrentPaneID() {
        if (this.fCurrentPane != null) {
            return this.fCurrentPane.getID();
        }
        return null;
    }

    private void setupPane(String paneID, IStructuredSelection selection) {
        if (this.fCurrentPane != null) {
            this.fCurrentPane.dispose();
        }
        if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
            this.fCurrentControl.dispose();
        }
        if (paneID != null) {
            this.fCurrentPane = DetailPaneManager.getDefault().getDetailPaneFromID(paneID);
            if (this.fCurrentPane != null) {
                this.fCurrentPane.init(this.fParentContainer.getWorkbenchPartSite());
                this.fCurrentControl = this.fCurrentPane.createControl(this.fParentContainer.getParentComposite());
                if (this.fCurrentControl != null) {
                    this.fParentContainer.getParentComposite().layout(true);
                    this.fCurrentPane.display(selection);
                } else {
                    this.createErrorLabel(DetailMessages.DetailPaneProxy_0);
                    DebugUIPlugin.log(new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "The detail pane \"" + this.fCurrentPane.getID() + "\" did not create and return a control.")));
                }
            } else {
                this.createErrorLabel(DetailMessages.DetailPaneProxy_0);
                DebugUIPlugin.log(new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Could not create the detail pane with ID " + paneID)));
            }
        } else {
            this.createErrorLabel(DetailMessages.DetailPaneProxy_1);
            DebugUIPlugin.log(new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "No detail panes could be found to display the current selection.")));
        }
    }

    private void createErrorLabel(String message) {
        if (this.fCurrentPane != null) {
            this.fCurrentPane.dispose();
        }
        if (this.fCurrentControl != null && !this.fCurrentControl.isDisposed()) {
            this.fCurrentControl.dispose();
        }
        Label errorLabel = new Label(this.fParentContainer.getParentComposite(), 16384);
        errorLabel.setText(message);
        errorLabel.setLayoutData((Object)new GridData(1808));
        this.fCurrentControl = errorLabel;
        this.fParentContainer.getParentComposite().layout();
    }
}

