/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.core.phpIni.IniModifier;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.DebugSessionIdGenerator;
import org.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPExecutableDebuggerInitializer;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPExecutableLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final boolean WINDOWS = File.separatorChar == '\\';
    public static final String SAVE_AUTOMATICALLY = "save_automatically";
    public static final String EXECUTABLE_LAUNCH = "executable_launch";
    private static final String UNTITLED_FOLDER_PATH = "Untitled_Documents";
    protected Map<String, String> envVariables = null;

    public ILaunch getLaunch(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        return new PHPLaunch(iLaunchConfiguration, string, null);
    }

    public void debugPHPExecutable(ILaunch iLaunch, String string, String string2) throws DebugException {
        try {
            iLaunch.setAttribute(EXECUTABLE_LAUNCH, "true");
            IDebugParametersInitializer iDebugParametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(iLaunch);
            PHPExecutableDebuggerInitializer pHPExecutableDebuggerInitializer = new PHPExecutableDebuggerInitializer(iLaunch);
            pHPExecutableDebuggerInitializer.initializeDebug(new File(string).getAbsolutePath(), new File(string2).getAbsolutePath(), iDebugParametersInitializer.generateQuery(iLaunch), this.envVariables, iLaunch.getAttribute("PHPIniLocation"));
        }
        catch (IOException iOException) {
            Logger.logException("PHPDebugTarget: Debugger didn't find file to debug.", iOException);
            String string3 = PHPDebugCoreMessages.DebuggerFileNotFound_1;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string3, (Throwable)iOException));
        }
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        File file;
        Object object;
        if (!DaemonPlugin.getDefault().validateCommunicationDaemons("org.eclipse.php.debug.core.zendDebugger")) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        if (!PHPLaunchUtilities.notifyPreviousLaunches(iLaunch)) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        PHPLaunchUtilities.showDebugView();
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        String string2 = iLaunchConfiguration.getAttribute("ATTR_LOCATION", null);
        String string3 = iLaunchConfiguration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        String string4 = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
        boolean bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (string4 == null || string4.equals("")) {
            this.displayErrorMessage("Please set a valid PHP file for this launch.");
            return;
        }
        if (string2 == null) {
            this.displayErrorMessage("Please set a valid PHP executable for this launch.");
            return;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(string4);
        IProject iProject = null;
        IProject iProject2 = null;
        String string5 = null;
        if (string3 == null) {
            object = iWorkspaceRoot.findMember((IPath)path);
            if (object == null && (!WINDOWS || ExternalFilesRegistry.getInstance().isEntryExist(path.toString()))) {
                iProject = iProject2 = ExternalFilesRegistry.getInstance().getExternalFilesProject();
                string5 = path.makeAbsolute().toString();
            } else if (object == null || !object.isAccessible()) {
                this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_ResourceNotFound, (Object)path));
                return;
            }
            if (iProject == null) {
                iProject = object.getProject();
                string5 = object.getLocation().toString();
            }
            if (iProject == null) {
                this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_InvalidDebugResource, (Object)path));
                return;
            }
        } else {
            try {
                object = new Path(string3);
                iProject = iWorkspaceRoot.getProject(object.lastSegment());
                string5 = path.makeAbsolute().toString();
            }
            catch (Exception exception) {}
        }
        if (iProject == null || !iProject.isAccessible() && iProject != iProject2) {
            this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_InvalidDebugResource, (Object)path));
            return;
        }
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
        object = IniModifier.findPHPIni((String)string2);
        if (iProject != iProject2 && iProject.hasNature("org.eclipse.php.core.PHPNature")) {
            if (object != null && (file = IniModifier.addIncludePath((File)object, (IProject)iProject)) != null) {
                iLaunch.setAttribute("PHPIniLocation", file.getAbsolutePath());
            }
        } else if (object != null) {
            iLaunch.setAttribute("PHPIniLocation", ((File)object).getAbsolutePath());
        }
        if (string.equals("debug") || bl) {
            boolean bl2 = iLaunchConfiguration.getAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine(iProject));
            int n = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
            String string6 = iProject.getFullPath().toString();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)iLaunchConfiguration : iLaunchConfiguration.getWorkingCopy();
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string6);
            iLaunchConfigurationWorkingCopy.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(iProject));
            iLaunchConfigurationWorkingCopy.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(iProject));
            iLaunchConfigurationWorkingCopy.doSave();
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            int n2 = DebugSessionIdGenerator.generateSessionID();
            PHPSessionLaunchMapper.put(n2, iLaunch);
            iLaunch.setAttribute("port", Integer.toString(n));
            iLaunch.setAttribute("firstLineBreakpoint", Boolean.toString(bl2));
            iLaunch.setAttribute("debugSessionID", Integer.toString(n2));
            this.debugPHPExecutable(iLaunch, string2, string5);
        } else {
            IProcess iProcess;
            Object object2;
            file = new Path(string2);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            IPath iPath = iProject.getRawLocation();
            if (iPath == null) {
                iPath = iProject.getLocation();
            }
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            Path path2 = new Path(string4);
            if (string4.startsWith("/")) {
                path2 = path2.removeFirstSegments(1);
            }
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            String[] stringArray = DebugPlugin.getDefault().getLaunchManager().getEnvironment(iLaunchConfiguration);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            File file2 = new File(file.removeLastSegments(1).toString());
            String string7 = file2.getAbsolutePath();
            String string8 = iLaunch.getAttribute("PHPIniLocation");
            if (string8 != null && !string8.equals("")) {
                string7 = string8;
            }
            IResource iResource = iWorkspaceRoot.findMember((IPath)path);
            String string9 = null;
            string9 = iResource != null ? iResource.getLocation().toOSString() : path.toOSString();
            String[] stringArray2 = PHPLaunchUtilities.getCommandLine(iLaunch.getLaunchConfiguration(), file.toOSString(), string7, string9, string8);
            if (!WINDOWS) {
                object2 = new StringBuffer();
                if (System.getProperty("os.name").startsWith("Mac")) {
                    ((StringBuffer)object2).append("DYLD_LIBRARY_PATH");
                } else {
                    ((StringBuffer)object2).append("LD_LIBRARY_PATH");
                }
                ((StringBuffer)object2).append('=');
                ((StringBuffer)object2).append(file2.getAbsolutePath());
                iProcess = new String[stringArray == null ? 1 : stringArray.length + 1];
                if (stringArray != null) {
                    System.arraycopy(stringArray, 0, iProcess, 0, stringArray.length);
                }
                iProcess[((String[])iProcess).length - 1] = ((StringBuffer)object2).toString();
                stringArray = iProcess;
            }
            object2 = DebugPlugin.exec((String[])stringArray2, (File)file2, (String[])stringArray);
            iProcess = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string10 = file.lastSegment();
            String string11 = file.getFileExtension();
            if (string11 != null) {
                string10 = string10.substring(0, string10.length() - (string11.length() + 1));
            }
            string10 = string10.toLowerCase();
            hashMap.put(IProcess.ATTR_PROCESS_TYPE, string10);
            if (object2 != null) {
                subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 80);
                subProgressMonitor.beginTask(MessageFormat.format("start launch", iLaunchConfiguration.getName()), -1);
                iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)object2, (String)file.toOSString(), hashMap);
                if (iProcess == null) {
                    ((Process)object2).destroy();
                    throw new CoreException((IStatus)new Status(4, PHPDebugPlugin.getID(), 0, null, null));
                }
                subProgressMonitor.done();
            }
            iProcess.setAttribute(IProcess.ATTR_CMDLINE, string4);
            if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)iLaunchConfiguration)) {
                while (!iProcess.isTerminated()) {
                    try {
                        if (iProgressMonitor.isCanceled()) {
                            iProcess.terminate();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
                RefreshTab.refreshResources((ILaunchConfiguration)iLaunchConfiguration, (IProgressMonitor)subProgressMonitor);
            }
        }
    }

    private void displayErrorMessage(final String string) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Debugger_LaunchError_title, (String)string);
            }
        });
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        String string2 = iLaunchConfiguration.getAttribute("ATTR_FILE", "");
        if ("".equals(string2)) {
            return super.saveBeforeLaunch(iLaunchConfiguration, string, iProgressMonitor);
        }
        IPath iPath = Path.fromOSString((String)string2);
        if (iPath.segmentCount() > 1 && UNTITLED_FOLDER_PATH.equals(iPath.segment(iPath.segmentCount() - 2))) {
            return true;
        }
        return super.saveBeforeLaunch(iLaunchConfiguration, string, iProgressMonitor);
    }
}

