/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ArrayAccess
extends Variable {
    public static final int VARIABLE_ARRAY = 1;
    public static final int VARIABLE_HASHTABLE = 2;
    private final Expression index;
    private final int arrayType;

    public ArrayAccess(int n, int n2, VariableBase variableBase, Expression expression, int n3) {
        super(n, n2, variableBase);
        this.index = expression;
        this.arrayType = n3;
        variableBase.setParent(this);
        if (expression != null) {
            expression.setParent(this);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getVariableName().accept(visitor);
        if (this.index != null) {
            this.index.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getVariableName().traverseTopDown(visitor);
        if (this.index != null) {
            this.index.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getVariableName().traverseBottomUp(visitor);
        if (this.index != null) {
            this.index.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<ArrayAccess");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" type='").append(ArrayAccess.getArrayType(this.arrayType)).append("'>\n");
        this.getVariableName().toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n").append("\t").append(string).append("<Index>\n");
        if (this.index != null) {
            this.index.toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t").append(string).append("</Index>\n");
        stringBuffer.append(string).append("</ArrayAccess>");
    }

    public static String getArrayType(int n) {
        switch (n) {
            case 1: {
                return "array";
            }
            case 2: {
                return "hashtable";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getType() {
        return 0;
    }

    public Expression getIndex() {
        return this.index;
    }

    public int getArrayType() {
        return this.arrayType;
    }
}

