/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ClassDeclaration
extends TypeDeclaration {
    public static final int MODIFIER_NONE = 0;
    public static final int MODIFIER_ABSTRACT = 1;
    public static final int MODIFIER_FINAL = 2;
    private final int modifier;
    private final Identifier superClass;

    private ClassDeclaration(int n, int n2, int n3, Identifier identifier, Identifier identifier2, Identifier[] identifierArray, Block block) {
        super(n, n2, identifier, identifierArray, block);
        this.modifier = n3;
        this.superClass = identifier2;
        if (identifier2 != null) {
            identifier2.setParent(this);
        }
    }

    public ClassDeclaration(int n, int n2, int n3, Identifier identifier, Identifier identifier2, List list, Block block) {
        this(n, n2, n3, identifier, identifier2, list == null ? null : list.toArray(new Identifier[list.size()]), block);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getName().accept(visitor);
        if (this.superClass != null) {
            this.superClass.accept(visitor);
        }
        Identifier[] identifierArray = this.getInterfaces();
        int n = 0;
        while (identifierArray != null && n < identifierArray.length) {
            identifierArray[n].accept(visitor);
            ++n;
        }
        this.getBody().accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getName().traverseTopDown(visitor);
        if (this.superClass != null) {
            this.superClass.traverseTopDown(visitor);
        }
        Identifier[] identifierArray = this.getInterfaces();
        int n = 0;
        while (identifierArray != null && n < identifierArray.length) {
            identifierArray[n].traverseTopDown(visitor);
            ++n;
        }
        this.getBody().traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getName().traverseBottomUp(visitor);
        if (this.superClass != null) {
            this.superClass.traverseBottomUp(visitor);
        }
        Identifier[] identifierArray = this.getInterfaces();
        int n = 0;
        while (identifierArray != null && n < identifierArray.length) {
            identifierArray[n].traverseBottomUp(visitor);
            ++n;
        }
        this.getBody().traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public static String getModifier(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "abstract";
            }
            case 2: {
                return "final";
            }
        }
        throw new IllegalArgumentException();
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<ClassDeclaration");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" modifier='").append(ClassDeclaration.getModifier(this.modifier)).append("'>\n");
        stringBuffer.append(string).append("\t").append("<ClassName>\n");
        this.getName().toString(stringBuffer, "\t\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append(string).append("\t").append("</ClassName>\n");
        stringBuffer.append(string).append("\t").append("<SuperClassName>\n");
        if (this.superClass != null) {
            this.superClass.toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append(string).append("\t").append("</SuperClassName>\n");
        stringBuffer.append(string).append("\t").append("<Interfaces>\n");
        Identifier[] identifierArray = this.getInterfaces();
        int n = 0;
        while (identifierArray != null && n < identifierArray.length) {
            identifierArray[n].toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append(string).append("\t").append("</Interfaces>\n");
        this.getBody().toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append(string).append("</ClassDeclaration>");
    }

    public int getType() {
        return 12;
    }

    public int getModifier() {
        return this.modifier;
    }

    public Identifier getSuperClass() {
        return this.superClass;
    }
}

