/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FieldsDeclaration
extends BodyDeclaration {
    private final Variable[] variableNames;
    private final Expression[] initialValues;

    public FieldsDeclaration(int n, int n2, int n3, List list) {
        super(n, n2, n3);
        assert (list != null && list.size() > 0);
        this.variableNames = new Variable[list.size()];
        this.initialValues = new Expression[list.size()];
        int n4 = 0;
        for (ASTNode[] aSTNodeArray : list) {
            this.variableNames[n4] = (Variable)aSTNodeArray[0];
            this.initialValues[n4] = (Expression)aSTNodeArray[1];
            aSTNodeArray[0].setParent(this);
            if (aSTNodeArray[1] != null) {
                aSTNodeArray[1].setParent(this);
            }
            ++n4;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int n = 0;
        while (n < this.variableNames.length) {
            this.variableNames[n].accept(visitor);
            Expression expression = this.initialValues[n];
            if (expression != null) {
                expression.accept(visitor);
            }
            ++n;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int n = 0;
        while (n < this.variableNames.length) {
            this.variableNames[n].traverseTopDown(visitor);
            Expression expression = this.initialValues[n];
            if (expression != null) {
                expression.traverseTopDown(visitor);
            }
            ++n;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int n = 0;
        while (n < this.variableNames.length) {
            this.variableNames[n].traverseBottomUp(visitor);
            Expression expression = this.initialValues[n];
            if (expression != null) {
                expression.traverseBottomUp(visitor);
            }
            ++n;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<FieldsDeclaration");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" modifier='").append(this.getModifierString()).append("'>\n");
        int n = 0;
        while (n < this.variableNames.length) {
            stringBuffer.append(string).append("\t").append("<VariableName>\n");
            this.variableNames[n].toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
            stringBuffer.append(string).append("\t").append("</VariableName>\n");
            stringBuffer.append(string).append("\t").append("<InitialValue>\n");
            Expression expression = this.initialValues[n];
            if (expression != null) {
                expression.toString(stringBuffer, "\t\t" + string);
                stringBuffer.append("\n");
            }
            stringBuffer.append(string).append("\t").append("</InitialValue>\n");
            ++n;
        }
        stringBuffer.append(string).append("</FieldsDeclaration>");
    }

    public int getType() {
        return 25;
    }

    public Expression[] getInitialValues() {
        return this.initialValues;
    }

    public Variable[] getVariableNames() {
        return this.variableNames;
    }
}

