/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Include
extends Expression {
    public static final int IT_REQUIRE = 0;
    public static final int IT_REQUIRE_ONCE = 1;
    public static final int IT_INCLUDE = 2;
    public static final int IT_INCLUDE_ONCE = 3;
    private final Expression expr;
    private final int includeType;

    public Include(int n, int n2, Expression expression, int n3) {
        super(n, n2);
        assert (expression != null);
        this.expr = expression;
        this.includeType = n3;
        expression.setParent(this);
    }

    public static String getType(int n) {
        switch (n) {
            case 0: {
                return "require";
            }
            case 1: {
                return "require_once";
            }
            case 2: {
                return "include";
            }
            case 3: {
                return "include_once";
            }
        }
        throw new IllegalArgumentException();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expr.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expr.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expr.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<Include");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" kind='").append(Include.getType(this.includeType)).append("'>\n");
        this.expr.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n").append(string).append("</Include>");
    }

    public int getType() {
        return 36;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public int getIncludeType() {
        return this.includeType;
    }
}

