/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaJoinTable;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.DefaultLazyFetchType;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.core.internal.mappings.IMultiRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.INonOwningMapping;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaMultiRelationshipMapping
extends JavaRelationshipMapping
implements IMultiRelationshipMapping {
    protected static final String MAPPED_BY_EDEFAULT = null;
    protected String mappedBy = MAPPED_BY_EDEFAULT;
    protected static final String ORDER_BY_EDEFAULT = null;
    protected String orderBy = ORDER_BY_EDEFAULT;
    protected static final DefaultLazyFetchType FETCH_EDEFAULT = DefaultLazyFetchType.DEFAULT;
    protected DefaultLazyFetchType fetch = FETCH_EDEFAULT;
    protected IJoinTable joinTable;
    protected static final String MAP_KEY_EDEFAULT = null;
    protected String mapKey = MAP_KEY_EDEFAULT;
    private final AnnotationElementAdapter<String> mappedByAdapter;
    private final AnnotationAdapter orderByAnnotationAdapter;
    private final AnnotationElementAdapter<String> orderByValueAdapter;
    public static final DeclarationAnnotationAdapter ORDER_BY_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OrderBy");
    private static final DeclarationAnnotationElementAdapter<String> ORDER_BY_VALUE_ADAPTER = JavaMultiRelationshipMapping.buildOrderByValueAdapter();
    private final AnnotationAdapter mapKeyAnnotationAdapter;
    private final AnnotationElementAdapter<String> mapKeyNameAdapter;
    public static final DeclarationAnnotationAdapter MAP_KEY_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.MapKey");
    private static final DeclarationAnnotationElementAdapter<String> MAP_KEY_NAME_ADAPTER = JavaMultiRelationshipMapping.buildMapKeyNameAdapter();

    protected JavaMultiRelationshipMapping() {
        throw new UnsupportedOperationException("Use JavaMultiRelationshipMapping(Attribute) instead");
    }

    protected JavaMultiRelationshipMapping(Attribute attribute) {
        super(attribute);
        this.mappedByAdapter = this.buildAnnotationElementAdapter(this.mappedByAdapter());
        this.orderByAnnotationAdapter = new MemberAnnotationAdapter(attribute, ORDER_BY_ADAPTER);
        this.orderByValueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, ORDER_BY_VALUE_ADAPTER);
        this.mapKeyAnnotationAdapter = new MemberAnnotationAdapter(attribute, MAP_KEY_ADAPTER);
        this.mapKeyNameAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, MAP_KEY_NAME_ADAPTER);
        this.joinTable = JpaJavaMappingsFactory.eINSTANCE.createJavaJoinTable(this.buildOwner(), attribute);
        ((InternalEObject)this.joinTable).eInverseAdd((InternalEObject)this, -9, null, null);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> mappedByAdapter();

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(INonOwningMapping.class)) {
            case 5: {
                this.mappedByAdapter.setValue((String)notification.getNewValue());
                break;
            }
        }
        switch (notification.getFeatureID(IMultiRelationshipMapping.class)) {
            case 6: {
                String orderBy = (String)notification.getNewValue();
                if (orderBy == null) {
                    this.orderByAnnotationAdapter.removeAnnotation();
                    break;
                }
                if ("".equals(orderBy)) {
                    Annotation orderByAnnotation = this.orderByAnnotationAdapter.getAnnotation();
                    if (orderByAnnotation != null) {
                        if ("".equals(this.orderByValueAdapter.getValue())) break;
                        this.orderByValueAdapter.setValue(null);
                        break;
                    }
                    this.orderByAnnotationAdapter.newMarkerAnnotation();
                    break;
                }
                this.orderByValueAdapter.setValue(orderBy);
                break;
            }
            case 9: {
                String mk = (String)notification.getNewValue();
                if (mk == null) {
                    this.mapKeyAnnotationAdapter.removeAnnotation();
                    break;
                }
                this.mapKeyNameAdapter.setValue(mk);
                break;
            }
            case 7: {
                this.getFetchAdapter().setValue(((DefaultLazyFetchType)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
        }
    }

    private ITable.Owner buildOwner() {
        return new ITable.Owner(){

            public ITextRange validationTextRange() {
                return JavaMultiRelationshipMapping.this.validationTextRange();
            }

            public ITypeMapping getTypeMapping() {
                return JavaMultiRelationshipMapping.this.typeMapping();
            }
        };
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_MULTI_RELATIONSHIP_MAPPING;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldMappedBy, (Object)this.mappedBy));
        }
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public void setOrderBy(String newOrderBy) {
        String oldOrderBy = this.orderBy;
        this.orderBy = newOrderBy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldOrderBy, (Object)this.orderBy));
        }
    }

    @Override
    public boolean isNoOrdering() {
        return this.getOrderBy() == null;
    }

    @Override
    public void setNoOrdering() {
        this.setOrderBy(null);
    }

    @Override
    public boolean isOrderByPk() {
        return "".equals(this.getOrderBy());
    }

    @Override
    public void setOrderByPk() {
        this.setOrderBy("");
    }

    @Override
    public boolean isCustomOrdering() {
        return !StringTools.stringIsEmpty((String)this.getOrderBy());
    }

    @Override
    public ITextRange mappedByTextRange() {
        return this.elementTextRange(this.mappedByAdapter());
    }

    @Override
    public DefaultLazyFetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(DefaultLazyFetchType newFetch) {
        DefaultLazyFetchType oldFetch = this.fetch;
        DefaultLazyFetchType defaultLazyFetchType = this.fetch = newFetch == null ? FETCH_EDEFAULT : newFetch;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldFetch, (Object)this.fetch));
        }
    }

    @Override
    public IJoinTable getJoinTable() {
        return this.joinTable;
    }

    public NotificationChain basicSetJoinTable(IJoinTable newJoinTable, NotificationChain msgs) {
        IJoinTable oldJoinTable = this.joinTable;
        this.joinTable = newJoinTable;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldJoinTable, (Object)newJoinTable);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public boolean isJoinTableSpecified() {
        return this.getJavaJoinTable().isSpecified();
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public void setMapKey(String newMapKey) {
        String oldMapKey = this.mapKey;
        this.mapKey = newMapKey;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldMapKey, (Object)this.mapKey));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return this.basicSetJoinTable(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getMappedBy();
            }
            case 6: {
                return this.getOrderBy();
            }
            case 7: {
                return this.getFetch();
            }
            case 8: {
                return this.getJoinTable();
            }
            case 9: {
                return this.getMapKey();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setMappedBy((String)newValue);
                return;
            }
            case 6: {
                this.setOrderBy((String)newValue);
                return;
            }
            case 7: {
                this.setFetch((DefaultLazyFetchType)((Object)newValue));
                return;
            }
            case 9: {
                this.setMapKey((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setMappedBy(MAPPED_BY_EDEFAULT);
                return;
            }
            case 6: {
                this.setOrderBy(ORDER_BY_EDEFAULT);
                return;
            }
            case 7: {
                this.setFetch(FETCH_EDEFAULT);
                return;
            }
            case 9: {
                this.setMapKey(MAP_KEY_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return MAPPED_BY_EDEFAULT == null ? this.mappedBy != null : !MAPPED_BY_EDEFAULT.equals(this.mappedBy);
            }
            case 6: {
                return ORDER_BY_EDEFAULT == null ? this.orderBy != null : !ORDER_BY_EDEFAULT.equals(this.orderBy);
            }
            case 7: {
                return this.fetch != FETCH_EDEFAULT;
            }
            case 8: {
                return this.joinTable != null;
            }
            case 9: {
                return MAP_KEY_EDEFAULT == null ? this.mapKey != null : !MAP_KEY_EDEFAULT.equals(this.mapKey);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == INonOwningMapping.class) {
            switch (derivedFeatureID) {
                case 5: {
                    return 5;
                }
            }
            return -1;
        }
        if (baseClass == IMultiRelationshipMapping.class) {
            switch (derivedFeatureID) {
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == INonOwningMapping.class) {
            switch (baseFeatureID) {
                case 5: {
                    return 5;
                }
            }
            return -1;
        }
        if (baseClass == IMultiRelationshipMapping.class) {
            switch (baseFeatureID) {
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappedBy: ");
        result.append(this.mappedBy);
        result.append(", orderBy: ");
        result.append(this.orderBy);
        result.append(", fetch: ");
        result.append((Object)this.fetch);
        result.append(", mapKey: ");
        result.append(this.mapKey);
        result.append(')');
        return result.toString();
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
    }

    protected void refreshDefaultOrderBy(DefaultsContext defaultsContext) {
        IEntity targetEntity = this.getResolvedTargetEntity();
        if (targetEntity != null) {
            this.setOrderBy(String.valueOf(targetEntity.primaryKeyAttributeName()) + " ASC");
        }
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setMappedBy(this.mappedByAdapter.getValue(astRoot));
        this.updateOrderByFromJava(astRoot);
        this.getJavaJoinTable().updateFromJava(astRoot);
        this.updateMapKeyFromJava(astRoot);
    }

    private void updateOrderByFromJava(CompilationUnit astRoot) {
        String orderBy = this.orderByValueAdapter.getValue(astRoot);
        if (orderBy == null) {
            if (this.orderByAnnotation(astRoot) == null) {
                this.setNoOrdering();
            } else {
                this.setOrderByPk();
            }
        } else if ("".equals(orderBy)) {
            this.setOrderByPk();
        } else {
            this.setOrderBy(orderBy);
        }
    }

    private Annotation orderByAnnotation(CompilationUnit astRoot) {
        return this.orderByAnnotationAdapter.getAnnotation(astRoot);
    }

    private void updateMapKeyFromJava(CompilationUnit astRoot) {
        this.setMapKey(this.mapKeyNameAdapter.getValue(astRoot));
    }

    private JavaJoinTable getJavaJoinTable() {
        return (JavaJoinTable)this.joinTable;
    }

    @Override
    protected void updateFetchFromJava(CompilationUnit astRoot) {
        this.setFetch(DefaultLazyFetchType.fromJavaAnnotationValue(this.getFetchAdapter().getValue(astRoot)));
    }

    private boolean mappedByTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.mappedByAdapter(), pos, astRoot);
    }

    private boolean mapKeyNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(MAP_KEY_NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public Iterator<String> candidateMapKeyNames() {
        return this.allTargetEntityAttributeNames();
    }

    protected Iterator<String> candidateMapKeyNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateMapKeyNames(), filter);
    }

    protected Iterator<String> quotedCandidateMapKeyNames(Filter<String> filter) {
        return StringTools.quote(this.candidateMapKeyNames(filter));
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getJavaJoinTable().candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.mappedByTouches(pos, astRoot)) {
            return this.quotedCandidateMappedByAttributeNames(filter);
        }
        if (this.mapKeyNameTouches(pos, astRoot)) {
            return this.quotedCandidateMapKeyNames(filter);
        }
        return null;
    }

    @Override
    protected String javaDefaultTargetEntity(String signature) {
        String typeName = super.javaDefaultTargetEntity(signature);
        return JavaMultiRelationshipMapping.typeNamedIsContainer(typeName) ? this.javaDefaultTargetEntityFromContainer(signature) : null;
    }

    protected String javaDefaultTargetEntityFromContainer(String signature) {
        String[] parmSignatures = Signature.getTypeArguments((String)signature);
        if (parmSignatures == null || parmSignatures.length != 1) {
            return null;
        }
        String elementSignature = parmSignatures[0];
        String elementTypeName = JavaMultiRelationshipMapping.buildReferenceEntityTypeName(elementSignature, this.jdtType());
        return JavaMultiRelationshipMapping.typeNamedIsContainer(elementTypeName) ? null : elementTypeName;
    }

    private static DeclarationAnnotationElementAdapter<String> buildOrderByValueAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(ORDER_BY_ADAPTER, "value", false);
    }

    private static DeclarationAnnotationElementAdapter<String> buildMapKeyNameAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(MAP_KEY_ADAPTER, "name", false);
    }
}

