/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.jdtutility.AbstractDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;

public abstract class AbstractNestedDeclarationAnnotationAdapter
extends AbstractDeclarationAnnotationAdapter {
    private final DeclarationAnnotationAdapter outerAnnotationAdapter;
    private final String elementName;
    private final boolean removeOuterAnnotationWhenEmpty;

    protected AbstractNestedDeclarationAnnotationAdapter(DeclarationAnnotationAdapter outerAnnotationAdapter, String annotationName) {
        this(outerAnnotationAdapter, "value", annotationName);
    }

    protected AbstractNestedDeclarationAnnotationAdapter(DeclarationAnnotationAdapter outerAnnotationAdapter, String elementName, String annotationName) {
        this(outerAnnotationAdapter, elementName, annotationName, true);
    }

    protected AbstractNestedDeclarationAnnotationAdapter(DeclarationAnnotationAdapter outerAnnotationAdapter, String elementName, String annotationName, boolean removeOuterAnnotationWhenEmpty) {
        super(annotationName);
        this.outerAnnotationAdapter = outerAnnotationAdapter;
        this.elementName = elementName;
        this.removeOuterAnnotationWhenEmpty = removeOuterAnnotationWhenEmpty;
    }

    public Annotation getAnnotation(ModifiedDeclaration declaration) {
        Annotation outer = this.outerAnnotationAdapter.getAnnotation(declaration);
        if (outer == null) {
            return null;
        }
        Expression value = this.elementValue(outer);
        if (value == null) {
            return null;
        }
        Annotation inner = this.getAnnotation(value);
        if (inner == null) {
            return null;
        }
        return this.nameMatches(declaration, inner) ? inner : null;
    }

    public void removeAnnotation(ModifiedDeclaration declaration) {
        Annotation outer = this.outerAnnotationAdapter.getAnnotation(declaration);
        if (outer == null) {
            return;
        }
        Expression value = this.elementValue(outer);
        if (value == null) {
            return;
        }
        if (this.removeAnnotation(declaration, outer, value)) {
            return;
        }
        Annotation inner = this.annotationValue(value);
        if (inner == null) {
            return;
        }
        if (this.nameMatches(declaration, inner)) {
            this.removeElementAndNormalize(declaration, outer);
        }
    }

    public ASTNode astNode(ModifiedDeclaration declaration) {
        Annotation annotation = this.getAnnotation(declaration);
        return annotation != null ? annotation : this.outerAnnotationAdapter.astNode(declaration);
    }

    protected void addAnnotation(ModifiedDeclaration declaration, Annotation inner) {
        Annotation outer = this.outerAnnotationAdapter.getAnnotation(declaration);
        if (outer == null) {
            this.buildNewOuterAnnotation(declaration, inner);
        } else if (outer.isMarkerAnnotation()) {
            this.modifyAnnotation(declaration, (MarkerAnnotation)outer, inner);
        } else if (outer.isSingleMemberAnnotation()) {
            this.modifyAnnotation(declaration, (SingleMemberAnnotation)outer, inner);
        } else if (outer.isNormalAnnotation()) {
            this.modifyAnnotation(declaration, (NormalAnnotation)outer, inner);
        } else {
            throw new IllegalStateException("unknown annotation type: " + outer);
        }
    }

    protected abstract Annotation getAnnotation(Expression var1);

    protected abstract boolean removeAnnotation(ModifiedDeclaration var1, Annotation var2, Expression var3);

    protected abstract void modifyAnnotationValue(SingleMemberAnnotation var1, Annotation var2);

    protected abstract void modifyMemberValuePair(MemberValuePair var1, Annotation var2);

    public DeclarationAnnotationAdapter getOuterAnnotationAdapter() {
        return this.outerAnnotationAdapter;
    }

    public String getElementName() {
        return this.elementName;
    }

    protected Annotation annotationValue(Expression expression) {
        switch (expression.getNodeType()) {
            case 77: 
            case 78: 
            case 79: {
                return (Annotation)expression;
            }
        }
        return null;
    }

    protected void removeElementAndNormalize(ModifiedDeclaration declaration, Annotation outer) {
        if (outer.isNormalAnnotation()) {
            this.removeElementAndNormalize(declaration, (NormalAnnotation)outer);
        } else if (outer.isSingleMemberAnnotation()) {
            this.removeElementAndNormalize(declaration, (SingleMemberAnnotation)outer);
        } else if (outer.isMarkerAnnotation()) {
            this.removeElementAndNormalize(declaration, (MarkerAnnotation)outer);
        } else {
            throw new IllegalArgumentException("unknown annotation type: " + outer);
        }
    }

    protected void removeElementAndNormalize(ModifiedDeclaration declaration, NormalAnnotation outer) {
        this.removeElement(outer);
        this.normalizeAnnotation(declaration, outer);
    }

    protected void removeElement(NormalAnnotation annotation) {
        Iterator<MemberValuePair> stream = this.values(annotation).iterator();
        while (stream.hasNext()) {
            MemberValuePair pair = stream.next();
            if (!pair.getName().getFullyQualifiedName().equals(this.elementName)) continue;
            stream.remove();
            break;
        }
    }

    protected void normalizeAnnotation(ModifiedDeclaration declaration, NormalAnnotation outer) {
        List<MemberValuePair> values = this.values(outer);
        switch (values.size()) {
            case 0: {
                if (this.removeOuterAnnotationWhenEmpty) {
                    this.outerAnnotationAdapter.removeAnnotation(declaration);
                    break;
                }
                this.outerAnnotationAdapter.newMarkerAnnotation(declaration);
                break;
            }
            case 1: {
                MemberValuePair pair = values.get(0);
                if (!pair.getName().getFullyQualifiedName().equals("value")) break;
                Expression vv = pair.getValue();
                vv = (Expression)ASTNode.copySubtree((AST)vv.getAST(), (ASTNode)vv);
                this.outerAnnotationAdapter.newSingleMemberAnnotation(declaration).setValue(vv);
                break;
            }
        }
    }

    protected void removeElementAndNormalize(ModifiedDeclaration declaration, SingleMemberAnnotation outer) {
        if (this.elementName.equals("value")) {
            if (this.removeOuterAnnotationWhenEmpty) {
                this.outerAnnotationAdapter.removeAnnotation(declaration);
            } else {
                this.outerAnnotationAdapter.newMarkerAnnotation(declaration);
            }
        }
    }

    protected void removeElementAndNormalize(ModifiedDeclaration declaration, MarkerAnnotation outer) {
        if (this.removeOuterAnnotationWhenEmpty) {
            this.outerAnnotationAdapter.removeAnnotation(declaration);
        }
    }

    protected Expression elementValue(Annotation annotation) {
        if (annotation.isNormalAnnotation()) {
            return this.elementValue((NormalAnnotation)annotation);
        }
        if (annotation.isSingleMemberAnnotation()) {
            return this.elementValue((SingleMemberAnnotation)annotation);
        }
        return null;
    }

    protected Expression elementValue(NormalAnnotation annotation) {
        MemberValuePair pair = this.memberValuePair(annotation);
        return pair == null ? null : pair.getValue();
    }

    protected Expression elementValue(SingleMemberAnnotation annotation) {
        return this.elementName.equals("value") ? annotation.getValue() : null;
    }

    protected MemberValuePair memberValuePair(NormalAnnotation annotation) {
        for (MemberValuePair pair : this.values(annotation)) {
            if (!pair.getName().getFullyQualifiedName().equals(this.elementName)) continue;
            return pair;
        }
        return null;
    }

    protected void buildNewOuterAnnotation(ModifiedDeclaration declaration, Annotation inner) {
        if (this.elementName.equals("value")) {
            this.outerAnnotationAdapter.newSingleMemberAnnotation(declaration).setValue(this.buildNewInnerExpression(inner));
        } else {
            List<MemberValuePair> values = this.values(this.outerAnnotationAdapter.newNormalAnnotation(declaration));
            values.add(this.newMemberValuePair(this.buildNewInnerExpression(inner)));
        }
    }

    protected abstract Expression buildNewInnerExpression(Annotation var1);

    protected MemberValuePair newMemberValuePair(String name, Expression value) {
        AST ast = value.getAST();
        MemberValuePair pair = ast.newMemberValuePair();
        pair.setName(ast.newSimpleName(name));
        pair.setValue(value);
        return pair;
    }

    protected MemberValuePair newMemberValuePair(Expression value) {
        return this.newMemberValuePair(this.elementName, value);
    }

    protected void modifyAnnotation(ModifiedDeclaration declaration, MarkerAnnotation outer, Annotation inner) {
        this.buildNewOuterAnnotation(declaration, inner);
    }

    protected void modifyAnnotation(ModifiedDeclaration declaration, SingleMemberAnnotation outer, Annotation inner) {
        if (this.elementName.equals("value")) {
            this.modifyAnnotationValue(outer, inner);
        } else {
            this.modifyAnnotationNonValue(declaration, outer, inner);
        }
    }

    protected void modifyAnnotationNonValue(ModifiedDeclaration declaration, SingleMemberAnnotation outer, Annotation inner) {
        Expression vv = outer.getValue();
        vv = (Expression)ASTNode.copySubtree((AST)vv.getAST(), (ASTNode)vv);
        NormalAnnotation newOuter = this.outerAnnotationAdapter.newNormalAnnotation(declaration);
        List<MemberValuePair> values = this.values(newOuter);
        values.add(this.newMemberValuePair("value", vv));
        values.add(this.newMemberValuePair(this.buildNewInnerExpression(inner)));
    }

    protected void modifyAnnotation(ModifiedDeclaration declaration, NormalAnnotation outer, Annotation inner) {
        MemberValuePair pair = this.memberValuePair(outer);
        if (pair == null) {
            List<MemberValuePair> values = this.values(outer);
            values.add(this.newMemberValuePair((Expression)inner));
        } else {
            this.modifyMemberValuePair(pair, inner);
        }
    }
}

